/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.syntax.Qualifier;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QDRExpression
extends TypedExpression {
    private Qualifier[] m_Qualifiers = null;
    private TypedExpression m_BaseExpression = null;

    public Qualifier[] getQualifiersInternal() {
        return this.m_Qualifiers;
    }

    private QDRExpression(TypedExpression typedExpression, Qualifier[] qualifierArray, boolean bl) {
        QDRExpression.validateValue(typedExpression);
        QDRExpression.validateValues(qualifierArray);
        this.m_Qualifiers = (Qualifier[])qualifierArray.clone();
        this.m_BaseExpression = typedExpression;
        this.initialize();
    }

    private static Qualifier[] createQualifierArray(List<Qualifier> list) {
        if (null == list) {
            return null;
        }
        Qualifier[] qualifierArray = new Qualifier[list.size()];
        list.toArray(qualifierArray);
        return qualifierArray;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.print(this.getBaseExpression());
        syntaxPrintingContext.append("[");
        for (int i = 0; i < this.getQualifiersInternal().length; ++i) {
            if (0 != i) {
                syntaxPrintingContext.append(", ");
            }
            syntaxPrintingContext.print(this.getQualifiersInternal()[i]);
        }
        syntaxPrintingContext.append("]");
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_BaseExpression = validationContext.validateExp(this.m_BaseExpression);
        validationContext.pop();
        validationContext.validateComponents(this, this.getQualifiersInternal());
        this.setDataType(this.getBaseExpression().getDataType());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.getBaseExpression().isDefinitionComplete() && this.areComponentsComplete(this.getQualifiersInternal());
    }

    public QDRExpression(TypedExpression typedExpression, Qualifier[] qualifierArray) {
        this(typedExpression, qualifierArray, true);
    }

    public QDRExpression(TypedExpression typedExpression, List<Qualifier> list) {
        this(typedExpression, QDRExpression.createQualifierArray(list), false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitQDRExpression(this, object);
    }

    public TypedExpression getBaseExpression() {
        return this.m_BaseExpression;
    }

    public Qualifier[] getQualifiers() {
        return (Qualifier[])this.m_Qualifiers.clone();
    }

    @Override
    public boolean isCompositeObject() {
        return true;
    }
}

