/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.SQLDataType;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OLAPDMLExpression
extends TypedExpression {
    private TypedExpression m_OlapDML;
    private MdmPrimaryDimension[] m_Dimensions;
    private SQLDataType m_SQLDataType;

    private MdmPrimaryDimension[] getDimensionsInternal() {
        return this.m_Dimensions;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("OLAP_DML_EXPRESSION(");
        syntaxPrintingContext.print(this.getOlapDML());
        syntaxPrintingContext.append(", ");
        syntaxPrintingContext.append(this.getSQLDataType().getSQLText());
        for (int i = 0; i < this.getDimensionsInternal().length; ++i) {
            syntaxPrintingContext.newLineAndIndent();
            if (0 == i) {
                syntaxPrintingContext.append(" DIMENSION BY ");
            } else {
                syntaxPrintingContext.append(", ");
            }
            syntaxPrintingContext.appendIdentifier(this.getDimensionsInternal()[i].getInternalID());
        }
        syntaxPrintingContext.append(")");
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return true;
    }

    public OLAPDMLExpression(TypedExpression typedExpression, DataType dataType, MdmPrimaryDimension[] mdmPrimaryDimensionArray) {
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(dataType);
        OLAPDMLExpression.validateValues(mdmPrimaryDimensionArray);
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = new SQLDataType(dataType);
        this.setDataType(dataType);
        this.m_Dimensions = (MdmPrimaryDimension[])mdmPrimaryDimensionArray.clone();
        this.initialize();
    }

    public OLAPDMLExpression(TypedExpression typedExpression, DataType dataType, List<MdmPrimaryDimension> list) {
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(dataType);
        OLAPDMLExpression.validateValues(list);
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = new SQLDataType(dataType);
        this.setDataType(dataType);
        this.m_Dimensions = new MdmPrimaryDimension[list.size()];
        list.toArray(this.m_Dimensions);
        this.initialize();
    }

    public OLAPDMLExpression(TypedExpression typedExpression, SQLDataType sQLDataType, MdmPrimaryDimension[] mdmPrimaryDimensionArray) {
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(sQLDataType);
        OLAPDMLExpression.validateValues(mdmPrimaryDimensionArray);
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = sQLDataType;
        this.setDataType(sQLDataType.getDataType());
        this.m_Dimensions = (MdmPrimaryDimension[])mdmPrimaryDimensionArray.clone();
        this.initialize();
    }

    public OLAPDMLExpression(TypedExpression typedExpression, SQLDataType sQLDataType, List<MdmPrimaryDimension> list) {
        OLAPDMLExpression.validateValue(typedExpression);
        OLAPDMLExpression.validateValue(sQLDataType);
        OLAPDMLExpression.validateValues(list);
        this.m_OlapDML = typedExpression;
        this.m_SQLDataType = sQLDataType;
        this.setDataType(sQLDataType.getDataType());
        this.m_Dimensions = new MdmPrimaryDimension[list.size()];
        list.toArray(this.m_Dimensions);
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitOLAPDMLExpression(this, object);
    }

    public TypedExpression getOlapDML() {
        return this.m_OlapDML;
    }

    public MdmPrimaryDimension[] getDimensions() {
        return (MdmPrimaryDimension[])this.m_Dimensions.clone();
    }

    public SQLDataType getSQLDataType() {
        return this.m_SQLDataType;
    }
}

