/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.SimpleCommand;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;

public final class LoadCommand
extends SimpleCommand {
    public static final String DEFAULT_OPTION = "";
    public static final String SYNCH_OPTION = "SYNCH";
    public static final String NO_SYNCH_OPTION = "NO SYNCH";
    public static final String PRUNE_OPTION = "PRUNE";
    public static final String SERIAL_OPTION = "SERIAL";
    public static final String PARALLEL_OPTION = "PARALLEL";
    static final String[] ALL_LOAD_OPTIONS = new String[]{"", "SYNCH", "NO SYNCH", "PRUNE", "PARALLEL", "SERIAL"};
    public static final LoadCommand DEFAULT = new LoadCommand("");
    public static final LoadCommand SYNCH = new LoadCommand("SYNCH");
    public static final LoadCommand SERIAL = new LoadCommand("SERIAL");
    public static final LoadCommand PARALLEL = new LoadCommand("PARALLEL");
    public static final LoadCommand NO_SYNCH = new LoadCommand("NO SYNCH");
    public static final LoadCommand PRUNE = new LoadCommand("PRUNE");
    private String m_Option;
    private String m_CubeMapName;
    private Condition m_WhereCondition;

    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("LOAD");
        if (this.getLoadOption() != DEFAULT_OPTION) {
            syntaxPrintingContext.append(" ");
            syntaxPrintingContext.append(this.getLoadOption());
        }
        if (null != this.getCubeMapName()) {
            syntaxPrintingContext.append(" FROM ");
            syntaxPrintingContext.append(this.getCubeMapName());
        }
        if (null != this.getWhereCondition()) {
            syntaxPrintingContext.append(" WHERE ");
            syntaxPrintingContext.print(this.getWhereCondition());
        }
    }

    public LoadCommand(boolean bl) {
        this(bl ? SYNCH_OPTION : NO_SYNCH_OPTION);
    }

    public boolean isSynch() {
        return SYNCH_OPTION == this.m_Option;
    }

    public boolean isPrune() {
        return PRUNE_OPTION == this.m_Option;
    }

    public LoadCommand() {
        this(DEFAULT_OPTION, null, null);
    }

    public LoadCommand(String string) {
        this(string, null, null);
    }

    public LoadCommand(String string, Condition condition) {
        this(string, condition, null);
    }

    public LoadCommand(String string, Condition condition, String string2) {
        this.m_Option = LoadCommand.validateEnum(string, ALL_LOAD_OPTIONS);
        this.m_CubeMapName = string2;
        this.m_WhereCondition = condition;
    }

    public LoadCommand(String string, String string2) {
        this(string, null, string2);
    }

    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitLoadCommand(this, object);
    }

    public String getCubeMapName() {
        return this.m_CubeMapName;
    }

    public String getLoadOption() {
        return this.m_Option;
    }

    public Condition getWhereCondition() {
        return this.m_WhereCondition;
    }
}

