/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmBaseMeasure;
import oracle.olapi.syntax.BuildCommand;
import oracle.olapi.syntax.SimpleCommand;
import oracle.olapi.syntax.SymmetricCondition;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupCommand
extends BuildCommand {
    private SimpleCommand[] m_Commands;
    private SymmetricCondition m_SymmetricCondition;
    private MdmBaseMeasure[] m_Measures;

    private MdmBaseMeasure[] getMeasuresInternal() {
        return this.m_Measures;
    }

    private SimpleCommand[] getCommandsInternal() {
        return this.m_Commands;
    }

    private GroupCommand(SimpleCommand[] simpleCommandArray, SymmetricCondition symmetricCondition, MdmBaseMeasure[] mdmBaseMeasureArray, boolean bl) {
        if (null == symmetricCondition && null == mdmBaseMeasureArray) {
            throw new SyntaxException("List of WhereConditions and/or Measures expected");
        }
        this.m_SymmetricCondition = symmetricCondition;
        if (null != mdmBaseMeasureArray) {
            GroupCommand.validateValues(mdmBaseMeasureArray);
            this.m_Measures = bl ? (MdmBaseMeasure[])mdmBaseMeasureArray.clone() : mdmBaseMeasureArray;
        }
        GroupCommand.validateValues(simpleCommandArray);
        this.m_Commands = bl ? (SimpleCommand[])simpleCommandArray.clone() : simpleCommandArray;
        this.initialize();
    }

    private static SimpleCommand[] createSimpleCommandArray(List<SimpleCommand> list) {
        if (null == list) {
            return null;
        }
        SimpleCommand[] simpleCommandArray = new SimpleCommand[list.size()];
        list.toArray(simpleCommandArray);
        return simpleCommandArray;
    }

    private static MdmBaseMeasure[] createMdmBaseMeasureArray(List<MdmBaseMeasure> list) {
        if (null == list) {
            return null;
        }
        MdmBaseMeasure[] mdmBaseMeasureArray = new MdmBaseMeasure[list.size()];
        list.toArray(mdmBaseMeasureArray);
        return mdmBaseMeasureArray;
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        super.validate(validationContext);
        validationContext.pop();
        validationContext.validateComponents(this, this.getCommandsInternal());
        if (null != this.getWhereCondition()) {
            validationContext.validateSymmetricCond(this.getWhereCondition());
        }
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.areComponentsComplete(this.getCommandsInternal());
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        int n;
        syntaxPrintingContext.append("FOR");
        syntaxPrintingContext.incrementIndent();
        if (null != this.getWhereCondition()) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.print(this.getWhereCondition());
        }
        if (null != this.getMeasuresInternal()) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.append("MEASURES");
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.append("(");
            syntaxPrintingContext.newLineAndIndent();
            for (n = 0; n < this.getMeasuresInternal().length; ++n) {
                if (0 != n) {
                    syntaxPrintingContext.append(", ");
                }
                syntaxPrintingContext.appendIdentifier(this.getMeasuresInternal()[n].getInternalID());
            }
            syntaxPrintingContext.append(")");
        }
        syntaxPrintingContext.decrementIndent();
        syntaxPrintingContext.newLineAndIndent();
        syntaxPrintingContext.append("BUILD");
        syntaxPrintingContext.newLineAndIndent();
        syntaxPrintingContext.append("(");
        for (n = 0; n < this.getCommandsInternal().length; ++n) {
            if (0 != n) {
                syntaxPrintingContext.append(", ");
            }
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.print(this.getCommandsInternal()[n]);
        }
        syntaxPrintingContext.newLineAndIndent();
        syntaxPrintingContext.append(")");
    }

    public GroupCommand(SimpleCommand[] simpleCommandArray, SymmetricCondition symmetricCondition) {
        this(simpleCommandArray, symmetricCondition, null, true);
    }

    public GroupCommand(SimpleCommand[] simpleCommandArray, MdmBaseMeasure[] mdmBaseMeasureArray) {
        this(simpleCommandArray, null, mdmBaseMeasureArray, true);
    }

    public GroupCommand(SimpleCommand[] simpleCommandArray, SymmetricCondition symmetricCondition, MdmBaseMeasure[] mdmBaseMeasureArray) {
        this(simpleCommandArray, symmetricCondition, mdmBaseMeasureArray, true);
    }

    public GroupCommand(List<SimpleCommand> list, SymmetricCondition symmetricCondition, List<MdmBaseMeasure> list2) {
        this(GroupCommand.createSimpleCommandArray(list), symmetricCondition, GroupCommand.createMdmBaseMeasureArray(list2), false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitGroupCommand(this, object);
    }

    public MdmBaseMeasure[] getMeasures() {
        if (null == this.getMeasuresInternal()) {
            return null;
        }
        return (MdmBaseMeasure[])this.getMeasuresInternal().clone();
    }

    public SymmetricCondition getWhereCondition() {
        return this.m_SymmetricCondition;
    }

    public SimpleCommand[] getCommands() {
        return (SimpleCommand[])this.getCommandsInternal().clone();
    }
}

