/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmDimensionLevel;
import oracle.olapi.metadata.mdm.MdmHierarchyLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmValueHierarchy;
import oracle.olapi.syntax.DataObject;
import oracle.olapi.syntax.DimensionArgument;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.FunctionDescriptorArgument;
import oracle.olapi.syntax.UnresolvedDimensionArgument;
import oracle.olapi.syntax.UnresolvedExpression;
import oracle.olapi.syntax.ValidationContext;

public final class FunctionDescriptorDimensionArgument
extends FunctionDescriptorArgument {
    public static int DIMENSION_LEVEL = 1;
    public static int PRIMARY_DIMENSION = 2;
    public static int HIERARCHY_LEVEL = 4;
    public static int LEVEL_HIERARCHY = 8;
    public static int VALUE_HIERARCHY = 16;
    private String m_Name = null;
    private int m_Mask = 0;

    FunctionDescriptorDimensionArgument(String string, int n, boolean bl, boolean bl2) {
        super(bl, bl2);
        this.m_Name = string;
        this.m_Mask = n;
    }

    int validate(FunctionArgument[] functionArgumentArray, FunctionArgument[] functionArgumentArray2, ValidationContext validationContext, int n) {
        DataObject dataObject;
        FunctionArgument functionArgument = null;
        if (functionArgumentArray.length > n) {
            functionArgument = functionArgumentArray[n];
        }
        int n2 = this.getMask();
        if (functionArgument instanceof UnresolvedExpression) {
            dataObject = (UnresolvedExpression)functionArgument;
            functionArgument = ((UnresolvedExpression)dataObject).resolveToDimension(validationContext, n2);
        }
        if (!(functionArgument instanceof DimensionArgument)) {
            return -1;
        }
        dataObject = (DimensionArgument)functionArgument;
        validationContext.validate(dataObject);
        functionArgumentArray2[n] = functionArgument;
        if (dataObject instanceof UnresolvedDimensionArgument) {
            return n + 1;
        }
        MdmDimension mdmDimension = ((DimensionArgument)dataObject).getDimension();
        if ((n2 & PRIMARY_DIMENSION) > 0 && mdmDimension instanceof MdmPrimaryDimension) {
            return n + 1;
        }
        if ((n2 & HIERARCHY_LEVEL) > 0 && mdmDimension instanceof MdmHierarchyLevel) {
            return n + 1;
        }
        if ((n2 & LEVEL_HIERARCHY) > 0 && mdmDimension instanceof MdmLevelHierarchy) {
            return n + 1;
        }
        if ((n2 & VALUE_HIERARCHY) > 0 && mdmDimension instanceof MdmValueHierarchy) {
            return n + 1;
        }
        if ((n2 & DIMENSION_LEVEL) > 0 && mdmDimension instanceof MdmDimensionLevel) {
            return n + 1;
        }
        return -1;
    }

    public void toSyntaxInternal(StringBuffer stringBuffer) {
        stringBuffer.append(this.getArgumentName());
    }

    public String getArgumentName() {
        return this.m_Name;
    }

    public int getMask() {
        return this.m_Mask;
    }

    public static int getMinExpectedNumComponents(int n) {
        if ((n & PRIMARY_DIMENSION) > 0) {
            return 2;
        }
        if ((n & LEVEL_HIERARCHY) > 0 || (n & VALUE_HIERARCHY) > 0 || (n & DIMENSION_LEVEL) > 0) {
            return 3;
        }
        return 4;
    }

    public static int getMaxExpectedNumComponents(int n) {
        if ((n & HIERARCHY_LEVEL) > 0) {
            return 4;
        }
        if ((n & LEVEL_HIERARCHY) > 0 || (n & VALUE_HIERARCHY) > 0 || (n & DIMENSION_LEVEL) > 0) {
            return 3;
        }
        return 2;
    }
}

