/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.data.source.ColumnDefinition;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.metadata.mdm.MdmQueryColumn;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

public final class ColumnExpression
extends TypedExpression {
    private Query m_Query = null;
    private MdmQueryColumn m_QueryColumn = null;
    private ColumnDefinition m_ColumnDefinition = null;

    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        String string = this.getQuery().getName();
        if (null != string) {
            string = string + ".";
        }
        string = string + this.getColumnName();
        syntaxPrintingContext.appendIdentifier(string);
    }

    MdmQueryColumn getQueryColumn() {
        return this.m_QueryColumn;
    }

    public SyntaxObject validate(ValidationContext validationContext) {
        return this;
    }

    protected boolean checkIfDefinitionIsComplete() {
        return true;
    }

    public ColumnExpression(MdmQueryColumn mdmQueryColumn, Query query) {
        ColumnExpression.validateValue(mdmQueryColumn);
        ColumnExpression.validateValue(query);
        this.m_Query = query;
        this.m_QueryColumn = mdmQueryColumn;
        this.setDataType(mdmQueryColumn.getSQLDataType().getDataType());
        this.initialize();
    }

    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitColumnExpression(this, object);
    }

    public Query getQuery() {
        return this.m_Query;
    }

    public String getColumnName() {
        return this.getQueryColumn().getName();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ColumnExpression)) {
            return false;
        }
        ColumnExpression columnExpression = (ColumnExpression)object;
        return this.getColumnName().equalsIgnoreCase(columnExpression.getColumnName()) && this.getQuery().equals(columnExpression.getQuery());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source getListSource(DataProvider dataProvider) {
        if (null == this.m_ColumnDefinition) {
            ColumnExpression columnExpression = this;
            synchronized (columnExpression) {
                if (null == this.m_ColumnDefinition) {
                    this.m_ColumnDefinition = new ColumnDefinition(this, dataProvider, dataProvider.getTransactionProvider().getCurrentTransaction());
                }
            }
        }
        if (this.m_ColumnDefinition.getDataProvider() != dataProvider) {
            throw new SyntaxException("WrongDataProvider");
        }
        return this.m_ColumnDefinition.getSource();
    }
}

