/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.ArrayList;
import java.util.List;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.metadata.deployment.AWCubeOrganization;
import oracle.olapi.metadata.deployment.AWPrimaryDimensionOrganization;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSource;
import oracle.olapi.syntax.BuildItem;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuildProcess
extends SyntaxObject {
    public static final int VALIDATION_BUILD = 1;
    public static final int NO_COMMIT_BUILD = 2;
    private BuildItem[] m_BuildItems = null;
    private int m_Flags = 0;
    private String m_LogOptions = null;

    private BuildItem[] getBuildItemsInternal() {
        return this.m_BuildItems;
    }

    private BuildProcess(BuildItem[] buildItemArray, int n, String string, boolean bl) {
        BuildProcess.validateValues(buildItemArray);
        this.m_Flags = n;
        this.m_LogOptions = string;
        this.m_BuildItems = bl ? (BuildItem[])buildItemArray.clone() : buildItemArray;
        this.initialize();
    }

    private static BuildItem[] createBuildItemArray(List<BuildItem> list) {
        if (null == list) {
            return null;
        }
        BuildItem[] buildItemArray = new BuildItem[list.size()];
        list.toArray(buildItemArray);
        return buildItemArray;
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        super.validate(validationContext);
        validationContext.pop();
        validationContext.validateComponents(this, this.getBuildItemsInternal());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.areComponentsComplete(this.getBuildItemsInternal());
    }

    public List<AW> getReferencedAWs() {
        ArrayList<AW> arrayList = new ArrayList<AW>();
        BuildItem[] buildItemArray = this.getBuildItems();
        for (int i = 0; i < buildItemArray.length; ++i) {
            BaseMetadataObject baseMetadataObject;
            MdmSource mdmSource;
            BuildItem buildItem = buildItemArray[i];
            if (buildItem.getBuildObject() instanceof MdmPrimaryDimension) {
                mdmSource = (MdmPrimaryDimension)buildItem.getBuildObject();
                if (!(((MdmPrimaryDimension)mdmSource).getOrganization() instanceof AWPrimaryDimensionOrganization) || null == ((AWPrimaryDimensionOrganization)(baseMetadataObject = (AWPrimaryDimensionOrganization)((MdmPrimaryDimension)mdmSource).getOrganization())).getAW() || arrayList.contains(((AWPrimaryDimensionOrganization)baseMetadataObject).getAW())) continue;
                arrayList.add(((AWPrimaryDimensionOrganization)baseMetadataObject).getAW());
                continue;
            }
            if (!(buildItem.getBuildObject() instanceof MdmCube) || !(((MdmCube)(mdmSource = (MdmCube)buildItem.getBuildObject())).getOrganization() instanceof AWCubeOrganization) || null == ((AWCubeOrganization)(baseMetadataObject = (AWCubeOrganization)((MdmCube)mdmSource).getOrganization())).getAW() || arrayList.contains(((AWCubeOrganization)baseMetadataObject).getAW())) continue;
            arrayList.add(((AWCubeOrganization)baseMetadataObject).getAW());
        }
        return arrayList;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        int n;
        syntaxPrintingContext.append("BUILD ");
        if (this.isValidationBuild()) {
            syntaxPrintingContext.append("VALIDATE ");
        } else if ((this.m_Flags & 2) > 0) {
            syntaxPrintingContext.append("NO COMMIT ");
        }
        boolean bl = false;
        for (n = 0; n < this.getBuildItemsInternal().length; ++n) {
            if (null == this.getBuildItemsInternal()[n].getInlineBuildSpecification()) continue;
            bl = true;
            break;
        }
        for (n = 0; n < this.getBuildItemsInternal().length; ++n) {
            if (0 != n) {
                syntaxPrintingContext.append(", ");
            }
            if (bl) {
                syntaxPrintingContext.newLineAndIndent();
            }
            syntaxPrintingContext.print(this.getBuildItemsInternal()[n]);
        }
        if (this.getLogOptions() != null && this.getLogOptions().length() > 0 && syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("1.2")) {
            syntaxPrintingContext.append(" LOG_SPEC ");
            syntaxPrintingContext.appendQuotedString(this.getLogOptions());
        }
    }

    public BuildProcess(BuildItem[] buildItemArray) {
        this(buildItemArray, 0, null, true);
    }

    public BuildProcess(List<BuildItem> list) {
        this(BuildProcess.createBuildItemArray(list), 0, null, false);
    }

    public BuildProcess(List<BuildItem> list, int n) {
        this(BuildProcess.createBuildItemArray(list), n, null, false);
    }

    public BuildProcess(List<BuildItem> list, int n, String string) {
        this(BuildProcess.createBuildItemArray(list), n, string, false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitBuildProcess(this, object);
    }

    public BuildItem[] getBuildItems() {
        return (BuildItem[])this.getBuildItemsInternal().clone();
    }

    public String getLogOptions() {
        return this.m_LogOptions;
    }

    public boolean isValidationBuild() {
        return (this.m_Flags & 1) > 0;
    }
}

