/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.ArrayList;
import java.util.List;
import oracle.olapi.metadata.mdm.MdmQuery;
import oracle.olapi.metadata.mdm.MdmQueryColumn;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BaseQuery
extends Query {
    private MdmQuery m_MdmQuery;
    private List<ColumnExpression> m_ColumnExpressions = new ArrayList<ColumnExpression>();

    private synchronized ColumnExpression getColumnExpression(MdmQueryColumn mdmQueryColumn) {
        for (ColumnExpression columnExpression : this.m_ColumnExpressions) {
            if (columnExpression.getQueryColumn() != mdmQueryColumn) continue;
            return columnExpression;
        }
        ColumnExpression columnExpression = new ColumnExpression(mdmQueryColumn, this);
        this.m_ColumnExpressions.add(columnExpression);
        return columnExpression;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.appendIdentifier(this.getMdmQuery().getQueryName());
    }

    public BaseQuery(MdmQuery mdmQuery) {
        BaseQuery.validateValue(mdmQuery);
        this.m_MdmQuery = mdmQuery;
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitBaseQuery(this, object);
    }

    public MdmQuery getMdmQuery() {
        return this.m_MdmQuery;
    }

    @Override
    public String getName() {
        return this.getMdmQuery().getQueryName();
    }

    @Override
    public synchronized List<ColumnExpression> getColumnExpressions() {
        List<MdmQueryColumn> list = this.getMdmQuery().getQueryColumns();
        ArrayList<ColumnExpression> arrayList = new ArrayList<ColumnExpression>();
        for (MdmQueryColumn mdmQueryColumn : list) {
            arrayList.add(this.getColumnExpression(mdmQueryColumn));
        }
        return arrayList;
    }

    @Override
    public ColumnExpression getColumnExpression(String string) {
        MdmQueryColumn mdmQueryColumn = this.getMdmQuery().getQueryColumn(string);
        if (null == mdmQueryColumn) {
            return null;
        }
        return this.getColumnExpression(mdmQueryColumn);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseQuery)) {
            return false;
        }
        BaseQuery baseQuery = (BaseQuery)object;
        return this.getMdmQuery() == baseQuery.getMdmQuery();
    }
}

