/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmBaseMeasure;
import oracle.olapi.syntax.Qualifier;
import oracle.olapi.syntax.SimpleCommand;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AssignmentCommand
extends SimpleCommand {
    private MdmBaseMeasure m_Measure;
    private Qualifier[] m_Qualifiers = null;
    private TypedExpression m_Rhs = null;

    public Qualifier[] getQualifiersInternal() {
        return this.m_Qualifiers;
    }

    private AssignmentCommand(MdmBaseMeasure mdmBaseMeasure, Qualifier[] qualifierArray, boolean bl, TypedExpression typedExpression) {
        AssignmentCommand.validateValue(mdmBaseMeasure);
        AssignmentCommand.validateValue(typedExpression);
        this.m_Qualifiers = null != qualifierArray ? (Qualifier[])qualifierArray.clone() : new Qualifier[0];
        this.m_Measure = mdmBaseMeasure;
        this.m_Rhs = typedExpression;
        this.initialize();
    }

    private static Qualifier[] createQualifierArray(List<Qualifier> list) {
        if (null == list) {
            return null;
        }
        Qualifier[] qualifierArray = new Qualifier[list.size()];
        list.toArray(qualifierArray);
        return qualifierArray;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("SET ");
        syntaxPrintingContext.appendIdentifier(this.getBaseMeasure().getInternalID());
        if (this.getQualifiersInternal().length > 0) {
            syntaxPrintingContext.append("[");
            for (int i = 0; i < this.getQualifiersInternal().length; ++i) {
                if (0 != i) {
                    syntaxPrintingContext.append(", ");
                }
                syntaxPrintingContext.print(this.getQualifiersInternal()[i]);
            }
            syntaxPrintingContext.append("]");
        }
        syntaxPrintingContext.append(" = ");
        syntaxPrintingContext.print(this.getRHSExpression());
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        validationContext.pop();
        validationContext.validateComponents(this, this.getQualifiersInternal());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.getRHSExpression().isDefinitionComplete() && this.areComponentsComplete(this.getQualifiersInternal());
    }

    public AssignmentCommand(MdmBaseMeasure mdmBaseMeasure, Qualifier[] qualifierArray, TypedExpression typedExpression) {
        this(mdmBaseMeasure, qualifierArray, true, typedExpression);
    }

    public AssignmentCommand(MdmBaseMeasure mdmBaseMeasure, List<Qualifier> list, TypedExpression typedExpression) {
        this(mdmBaseMeasure, AssignmentCommand.createQualifierArray(list), false, typedExpression);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitAssignmentCommand(this, object);
    }

    public MdmBaseMeasure getBaseMeasure() {
        return this.m_Measure;
    }

    public Qualifier[] getQualifiers() {
        return (Qualifier[])this.getQualifiersInternal().clone();
    }

    public TypedExpression getRHSExpression() {
        return this.m_Rhs;
    }
}

