/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmBaseMeasure;
import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.FunctionDescriptor;
import oracle.olapi.syntax.FunctionDescriptorCatalog;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AggregationCase
extends SyntaxObject {
    private String m_FunctionName;
    private FunctionDescriptor m_FunctionDescriptor;
    private FunctionArgument[] m_Arguments;
    private MdmBaseMeasure m_Measure;

    private FunctionArgument[] getArgumentsInternal() {
        return this.m_Arguments;
    }

    AggregationCase(String string, FunctionArgument[] functionArgumentArray, MdmBaseMeasure mdmBaseMeasure, boolean bl) {
        AggregationCase.validateValue(string);
        AggregationCase.validateValue(mdmBaseMeasure);
        this.m_FunctionName = string;
        this.m_Measure = mdmBaseMeasure;
        this.m_Arguments = null != functionArgumentArray && bl ? AggregationCase.getFunctionArgumentArrayClone(functionArgumentArray) : new FunctionArgument[0];
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append(" WHEN ");
        syntaxPrintingContext.append(this.getMeasure().getID());
        syntaxPrintingContext.append(" THEN ");
        syntaxPrintingContext.append(this.getFunctionName());
        if (null != this.getArgumentsInternal() && this.getArgumentsInternal().length > 0) {
            Expression.printExpressions(this.getArgumentsInternal(), syntaxPrintingContext);
        }
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        FunctionArgument[] functionArgumentArray = null;
        if (null != this.getArgumentsInternal()) {
            functionArgumentArray = new FunctionArgument[this.getArgumentsInternal().length];
        }
        this.m_FunctionDescriptor = FunctionDescriptorCatalog.getValidFunctionDescriptor(this.getFunctionName(), this.getArgumentsInternal(), functionArgumentArray, null, null, 16, "UnknownSolveFunction", validationContext);
        this.m_Arguments = functionArgumentArray;
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (null != this.getArgumentsInternal()) {
            return this.areComponentsComplete(this.getArgumentsInternal());
        }
        return true;
    }

    public AggregationCase(String string, List<FunctionArgument> list, MdmBaseMeasure mdmBaseMeasure) {
        this(string, AggregationCase.getFunctionArgumentArrayClone(list), mdmBaseMeasure, false);
    }

    public AggregationCase(String string, FunctionArgument[] functionArgumentArray, MdmBaseMeasure mdmBaseMeasure) {
        this(string, functionArgumentArray, mdmBaseMeasure, true);
    }

    public FunctionArgument[] getArguments() {
        return (FunctionArgument[])this.getArgumentsInternal().clone();
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.m_FunctionDescriptor;
    }

    public String getFunctionName() {
        return this.m_FunctionName;
    }

    public MdmBaseMeasure getMeasure() {
        return this.m_Measure;
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitAggregationCase(this, object);
    }
}

