/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.syntax.AggregateOverClause;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AggregateOverMembersClause
extends AggregateOverClause {
    private String[] m_Members;
    private MdmPrimaryDimension m_Dimension;

    private String[] getMembersInternal() {
        return this.m_Members;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.appendIdentifier(this.getDimension().getInternalID());
        syntaxPrintingContext.append(" IN (");
        for (int i = 0; i < this.getMembersInternal().length; ++i) {
            if (0 < i) {
                syntaxPrintingContext.append(", ");
            }
            syntaxPrintingContext.appendQuotedString(this.getMembersInternal()[i]);
        }
        syntaxPrintingContext.append(")");
    }

    private AggregateOverMembersClause(MdmPrimaryDimension mdmPrimaryDimension, String[] stringArray, boolean bl) {
        AggregateOverMembersClause.validateValue(mdmPrimaryDimension);
        this.m_Dimension = mdmPrimaryDimension;
        AggregateOverMembersClause.validateValues(stringArray);
        this.m_Members = bl ? (String[])stringArray.clone() : stringArray;
    }

    private static String[] createStringArray(List<String> list) {
        if (null == list) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    public AggregateOverMembersClause(MdmPrimaryDimension mdmPrimaryDimension, String[] stringArray) {
        this(mdmPrimaryDimension, stringArray, true);
    }

    public AggregateOverMembersClause(MdmPrimaryDimension mdmPrimaryDimension, List<String> list) {
        this(mdmPrimaryDimension, AggregateOverMembersClause.createStringArray(list), false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitAggregateOverMembersClause(this, object);
    }

    public MdmPrimaryDimension getDimension() {
        return this.m_Dimension;
    }

    public String[] getMembers() {
        return (String[])this.getMembersInternal().clone();
    }
}

