/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.session;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import oracle.express.ExpressServerException;
import oracle.express.TaskInterruptedException;
import oracle.express.idl.ExpressConnectionModule.ConnectionInterface;
import oracle.express.idl.ExpressConnectionModule.PropertyStruct;
import oracle.express.idl.ExpressConnectionModule.RemoteAPIVersionMismatchException;
import oracle.express.idl.ExpressConnectionModule.RemoteAuthenticationException;
import oracle.express.idl.ExpressConnectionModule.ServerInterface;
import oracle.express.idl.ExpressModule.ExpressException;
import oracle.express.idl.ExpressModule.RemoteTaskInterruptedException;
import oracle.express.idl.util.StringHolder;
import oracle.jdbc.OracleConnection;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.ServerVersionException;
import oracle.olapi.session.UserSession;
import oracle.olapi.transaction.BaseTransaction;
import oracle.olapi.transaction.Transaction;

public final class UserSessionFactory {
    private DataProvider _dp = null;
    private UserSession _defaultSession = null;
    private WeakSet sessions = new WeakSet(5);

    public UserSessionFactory(DataProvider dataProvider) {
        this._dp = dataProvider;
    }

    DataProvider getDataProvider() {
        return this._dp;
    }

    public synchronized UserSession createUserSession(OracleConnection oracleConnection, ServerInterface serverInterface, Locale locale, Properties properties) throws ExpressServerException, TaskInterruptedException {
        PropertyStruct[] propertyStructArray = this._propertiesToPropertySequence(properties);
        ConnectionInterface connectionInterface = this.createConnectionInterface(serverInterface, locale, propertyStructArray);
        UserSession userSession = new UserSession(this, oracleConnection, connectionInterface, serverInterface, locale, properties);
        this.sessions.add(userSession);
        if (this.getDefaultSession() == null) {
            this.setDefaultSession(userSession);
        }
        return userSession;
    }

    public void closeAll() {
        while (!this.sessions.isEmpty()) {
            UserSession userSession = this.sessions.first();
            userSession.closeSession();
        }
    }

    synchronized void removeUserSession(UserSession userSession) {
        Transaction transaction = userSession.getRootTransaction();
        if (this.getDefaultSession() == userSession) {
            this.setDefaultSession(null);
        }
        this.sessions.remove(userSession);
        if (null != transaction) {
            this.getDataProvider().getBaseTransactionProvider().replaceTransaction((BaseTransaction)transaction, null);
        }
        if (this.sessions.isEmpty()) {
            this.getDataProvider()._close();
        }
    }

    public int getConnectionCount() {
        int n = this.sessions.size();
        return n;
    }

    public UserSession findUserSession(OracleConnection oracleConnection) {
        return this.sessions.find(oracleConnection);
    }

    static String _getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    private ConnectionInterface createConnectionInterface(ServerInterface serverInterface, Locale locale, PropertyStruct[] propertyStructArray) throws ExpressServerException, TaskInterruptedException {
        ConnectionInterface connectionInterface = null;
        try {
            StringHolder stringHolder = new StringHolder();
            connectionInterface = serverInterface.connect(UserSessionFactory._getHostName(), locale.getLanguage(), locale.getCountry(), locale.getVariant(), propertyStructArray, stringHolder);
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (RemoteAuthenticationException remoteAuthenticationException) {
        }
        catch (ExpressException expressException) {
            throw new ExpressServerException(expressException);
        }
        catch (RemoteAPIVersionMismatchException remoteAPIVersionMismatchException) {
            throw new ServerVersionException(remoteAPIVersionMismatchException.toString());
        }
        catch (RemoteTaskInterruptedException remoteTaskInterruptedException) {
            throw new TaskInterruptedException(remoteTaskInterruptedException.toString());
        }
        return connectionInterface;
    }

    public void setDefaultSession(UserSession userSession) {
        this._defaultSession = userSession;
    }

    public UserSession getDefaultSession() {
        return this._defaultSession;
    }

    private PropertyStruct[] _propertiesToPropertySequence(Properties properties) {
        PropertyStruct[] propertyStructArray;
        int n = 0;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            ++n;
            propertyStructArray = (String)enumeration.nextElement();
        }
        propertyStructArray = new PropertyStruct[n];
        Enumeration<?> enumeration2 = properties.propertyNames();
        for (int i = 0; i < n; ++i) {
            String string = (String)enumeration2.nextElement();
            propertyStructArray[i] = new PropertyStruct(string, properties.getProperty(string));
        }
        return propertyStructArray;
    }

    private class WeakSet {
        private Set _sessions;
        private ReferenceQueue refQueue = new ReferenceQueue();

        public WeakSet(int n) {
            this._sessions = new HashSet(n);
        }

        public synchronized void add(UserSession userSession) {
            WeakReference<UserSession> weakReference = new WeakReference<UserSession>(userSession, this.refQueue);
            this._sessions.add(weakReference);
            this.checkSet();
        }

        public synchronized void remove(UserSession userSession) {
            Reference reference = null;
            Iterator iterator = this._sessions.iterator();
            while (iterator.hasNext() && reference == null) {
                UserSession userSession2;
                Reference reference2 = (Reference)iterator.next();
                if (reference2 == null || (userSession2 = (UserSession)reference2.get()) != userSession) continue;
                reference = reference2;
            }
            if (reference != null) {
                this._sessions.remove(reference);
            }
            reference.enqueue();
            this.checkSet();
        }

        public synchronized UserSession first() {
            UserSession userSession = null;
            Iterator iterator = this._sessions.iterator();
            while (iterator.hasNext() && userSession == null) {
                this.checkSet();
                Reference reference = (Reference)iterator.next();
                if (reference == null) continue;
                userSession = (UserSession)reference.get();
            }
            return userSession;
        }

        public synchronized UserSession find(OracleConnection oracleConnection) {
            this.checkSet();
            UserSession userSession = null;
            Iterator iterator = this._sessions.iterator();
            while (iterator.hasNext() && userSession == null) {
                UserSession userSession2;
                Reference reference = (Reference)iterator.next();
                if (reference == null || (userSession2 = (UserSession)reference.get()) == null || userSession2.getConnection() != oracleConnection) continue;
                userSession = userSession2;
            }
            return userSession;
        }

        protected synchronized boolean isEmpty() {
            this.checkSet();
            return this._sessions.isEmpty();
        }

        protected synchronized void checkSet() {
            Reference reference = this.refQueue.poll();
            while (reference != null) {
                UserSession userSession = (UserSession)reference.get();
                if (userSession != null) {
                    userSession._dispose();
                }
                reference = this.refQueue.poll();
            }
        }

        public synchronized int size() {
            this.checkSet();
            return this._sessions.size();
        }
    }
}

