/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.session;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import oracle.express.ObjectClosedException;
import oracle.express.idl.ExpressConnectionModule.ConnectionInterface;
import oracle.express.idl.ExpressConnectionModule.ConnectionInterfaceStub;
import oracle.express.idl.ExpressConnectionModule.ServerInterface;
import oracle.express.idl.ExpressModule.ExpressException;
import oracle.express.idl.ExpressOlapiDataSourceModule.DataProviderInterface;
import oracle.express.idl.ExpressOlapiDataSourceModule.DataProviderInterfaceHelper;
import oracle.express.idl.util.OlapiException;
import oracle.jdbc.OracleConnection;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.metadata.ServerXMLParserCallback;
import oracle.olapi.metadata.XMLParserCallback;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.session.UserSessionFactory;
import oracle.olapi.transaction.ActiveSubtransactionsException;
import oracle.olapi.transaction.BaseTransaction;
import oracle.olapi.transaction.Branch;
import oracle.olapi.transaction.BranchActiveException;
import oracle.olapi.transaction.NotCommittableException;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionInactiveException;
import oracle.olapi.transaction.TransactionProvider;

public class UserSession {
    private UserSessionFactory m_Factory;
    private OracleConnection m_Connection;
    private ConnectionInterface m_ConnectionInterface;
    private ServerInterface m_ServerInterface;
    private DataProviderInterface m_DataProviderInterface;
    private BaseTransaction m_RootTransaction;
    private Locale m_Locale;
    private Properties m_Settings;
    private String m_NLSLanguage_Full = null;
    private String m_NLSLanguage_LangOnly = null;
    private XMLParserCallback m_XMLParserCallback = null;
    private Branch m_Branch = null;
    private boolean m_CreatingBranch = false;

    UserSession(UserSessionFactory userSessionFactory, OracleConnection oracleConnection, ConnectionInterface connectionInterface, ServerInterface serverInterface, Locale locale, Properties properties) {
        this.m_Factory = userSessionFactory;
        this.m_Connection = oracleConnection;
        this.m_ConnectionInterface = connectionInterface;
        this.m_ServerInterface = serverInterface;
        this.m_DataProviderInterface = null;
        this.m_RootTransaction = null;
        this.m_Locale = locale;
        this.m_Settings = properties;
        this.m_XMLParserCallback = new ServerXMLParserCallback();
        this.initDefaultLanguage();
    }

    public void setRootBaseTransaction(BaseTransaction baseTransaction) {
        this.m_RootTransaction = baseTransaction;
    }

    public BaseTransaction getRootBaseTransaction() {
        return this.m_RootTransaction;
    }

    public Transaction getRootTransaction() {
        return this.getRootBaseTransaction();
    }

    public OracleConnection getConnection() {
        return this.m_Connection;
    }

    public ConnectionInterface getConnectionInterface() {
        return this.m_ConnectionInterface;
    }

    public ServerInterface getServerInterface() {
        return this.m_ServerInterface;
    }

    Locale getLocale() {
        return this.m_Locale;
    }

    public DataProviderInterface getDataProviderInterface() throws ObjectClosedException {
        if (!this.isOpen()) {
            throw new ObjectClosedException();
        }
        if (this.m_DataProviderInterface == null) {
            this.m_DataProviderInterface = DataProviderInterfaceHelper.narrow(this.m_ConnectionInterface);
        }
        return this.m_DataProviderInterface;
    }

    public boolean isOpen() {
        boolean bl = false;
        try {
            bl = !this.m_Connection.isClosed();
        }
        catch (SQLException sQLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return bl;
    }

    public boolean isCreatingBranch() {
        return this.m_CreatingBranch;
    }

    public void creatingBranch(boolean bl) {
        this.m_CreatingBranch = bl;
    }

    void _dispose() {
        this._shutdown();
        this.m_RootTransaction = null;
        this.m_Connection = null;
    }

    public void closeSession() {
        this.m_Factory.removeUserSession(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _shutdown() {
        try {
            if (this.m_ConnectionInterface != null) {
                this.m_ConnectionInterface.close();
            }
        }
        catch (ExpressException expressException) {
        }
        finally {
            this.m_ConnectionInterface = null;
            this.m_DataProviderInterface = null;
            this.m_ServerInterface = null;
        }
    }

    public DataProvider getDataProvider() {
        return this.m_Factory.getDataProvider();
    }

    public Properties getSettings() {
        return (Properties)this.m_Settings.clone();
    }

    public final String getDefaultLanguage() {
        return this.getDefaultLanguage(true);
    }

    public final String getDefaultLanguage(boolean bl) {
        if (bl) {
            return this.m_NLSLanguage_Full;
        }
        return this.m_NLSLanguage_LangOnly;
    }

    private final void initDefaultLanguage() {
        if (this.m_NLSLanguage_Full == null) {
            if (!this.isOpen()) {
                throw new ObjectClosedException();
            }
            Statement statement = null;
            try {
                statement = this.getConnection().createStatement();
                String string = "select userenv('language'), value from nls_session_parameters where parameter = 'NLS_LANGUAGE'";
                ResultSet resultSet = statement.executeQuery(string);
                resultSet.next();
                this.m_NLSLanguage_Full = resultSet.getString(1);
                this.m_NLSLanguage_LangOnly = resultSet.getString(2);
            }
            catch (SQLException sQLException) {
                throw new OlapiException((Object)sQLException);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void setServerXMLParserCallback(XMLParserCallback xMLParserCallback) {
        this.m_XMLParserCallback = xMLParserCallback;
    }

    public XMLParserCallback getServerXMLParserCallback() {
        return this.m_XMLParserCallback;
    }

    public final void interrupt() {
        ConnectionInterfaceStub connectionInterfaceStub = (ConnectionInterfaceStub)this.getConnectionInterface();
        try {
            connectionInterfaceStub.interruptCurrentStmtExecution();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Branch getBranch() {
        return this.m_Branch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Branch createBranch(List list, List list2) throws NotCommittableException, TransactionInactiveException, ActiveSubtransactionsException {
        if (this.getBranch() != null) {
            throw new BranchActiveException();
        }
        this.creatingBranch(true);
        try {
            TransactionProvider transactionProvider = this.getDataProvider().getTransactionProvider();
            Transaction transaction = transactionProvider.getCurrentTransaction();
            while (transaction != null) {
                Transaction transaction2 = transaction.getParent();
                transactionProvider.prepareCurrentTransaction();
                transactionProvider.commitCurrentTransaction();
                transaction = transaction2;
            }
        }
        finally {
            this.creatingBranch(false);
        }
        this.m_Branch = new Branch(this, list, list2);
        this.getRootBaseTransaction().getBaseTransactionProvider().commitRootTransaction(this.getRootBaseTransaction(), false);
        return this.getBranch();
    }

    public Branch createBranch(AW aW, String string) throws NotCommittableException, TransactionInactiveException, ActiveSubtransactionsException {
        ArrayList<AW> arrayList = new ArrayList<AW>(1);
        arrayList.add(aW);
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        arrayList2.add(string);
        return this.createBranch(arrayList, arrayList2);
    }

    public Branch createBranch(List list) throws NotCommittableException, TransactionInactiveException, ActiveSubtransactionsException {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add("READ_ONLY");
        }
        return this.createBranch(list, arrayList);
    }

    public Branch createBranch(AW aW) throws NotCommittableException, TransactionInactiveException, ActiveSubtransactionsException {
        ArrayList<AW> arrayList = new ArrayList<AW>(1);
        arrayList.add(aW);
        return this.createBranch(arrayList);
    }

    public Branch createBranch() throws NotCommittableException, TransactionInactiveException, ActiveSubtransactionsException {
        return this.createBranch((List)null, (List)null);
    }

    public void branchClosed() {
        this.m_Branch = null;
    }
}

