/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.util.UtilityBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExportXML
extends UtilityBase {
    public static final String AW_NAME_PROPERTY = "aw";
    public static final String DIMENSION_NAME_PROPERTY = "dimension";
    public static final String CUBE_NAME_PROPERTY = "cube";
    public static final String ORG_SCHEMA_NAME_PROPERTY = "orgSchema";
    public static final String BUILD_PROCESS_NAME_PROPERTY = "buildProcess";

    protected static Properties parseCommandLineProperties(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; i += 2) {
            if (i + 1 == stringArray.length) {
                throw new IllegalArgumentException("Command-line arguments must be specified in the form -<PropertyName> <PropertyValue>, with name and value separated by whitespace.");
            }
            String string = stringArray[i].substring(1);
            String string2 = stringArray[i + 1];
            if (string.equalsIgnoreCase(AW_NAME_PROPERTY)) {
                string = string + ++n;
            } else if (string.equalsIgnoreCase(DIMENSION_NAME_PROPERTY)) {
                string = string + ++n2;
            } else if (string.equalsIgnoreCase(CUBE_NAME_PROPERTY)) {
                string = string + ++n3;
            } else if (string.equalsIgnoreCase(ORG_SCHEMA_NAME_PROPERTY)) {
                string = string + ++n4;
            } else if (string.equalsIgnoreCase(BUILD_PROCESS_NAME_PROPERTY)) {
                string = string + ++n5;
            }
            properties.put(string, string2);
        }
        return properties;
    }

    private static BaseMetadataObject getObject(MdmDatabaseSchema mdmDatabaseSchema, String string, List list) {
        for (BaseMetadataObject baseMetadataObject : list) {
            String string2 = null;
            string2 = baseMetadataObject instanceof AW ? ((AW)baseMetadataObject).getName() : ((MdmObject)baseMetadataObject).getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            return baseMetadataObject;
        }
        return null;
    }

    private static void exportXML(MdmMetadataProvider mdmMetadataProvider, List<BaseMetadataObject> list) {
        String string = null;
        try {
            string = mdmMetadataProvider.exportFullXML(list, null, false);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        try {
            Properties properties = ExportXML.parseCommandLineProperties(stringArray);
            OracleConnection oracleConnection = ExportXML.connect(properties);
            DataProvider dataProvider = ExportXML.createDataProvider(oracleConnection, properties);
            MdmMetadataProvider mdmMetadataProvider = dataProvider.getMdmMetadataProvider();
            MdmDatabaseSchema mdmDatabaseSchema = ExportXML.getDatabaseSchema(mdmMetadataProvider, properties);
            ArrayList<BaseMetadataObject> arrayList = new ArrayList<BaseMetadataObject>();
            String string = null;
            String string2 = null;
            BaseMetadataObject baseMetadataObject = null;
            int n = 1;
            string2 = AW_NAME_PROPERTY;
            while ((string = (String)properties.get(string2 + n)) != null) {
                baseMetadataObject = ExportXML.getObject(mdmDatabaseSchema, string, mdmDatabaseSchema.getAWs());
                if (null != baseMetadataObject) {
                    arrayList.add(baseMetadataObject);
                }
                ++n;
            }
            n = 1;
            string2 = DIMENSION_NAME_PROPERTY;
            while ((string = (String)properties.get(string2 + n)) != null) {
                baseMetadataObject = ExportXML.getObject(mdmDatabaseSchema, string, mdmDatabaseSchema.getDimensions());
                if (null != baseMetadataObject) {
                    arrayList.add(baseMetadataObject);
                }
                ++n;
            }
            n = 1;
            string2 = CUBE_NAME_PROPERTY;
            while ((string = (String)properties.get(string2 + n)) != null) {
                baseMetadataObject = ExportXML.getObject(mdmDatabaseSchema, string, mdmDatabaseSchema.getCubes());
                if (null != baseMetadataObject) {
                    arrayList.add(baseMetadataObject);
                }
                ++n;
            }
            n = 1;
            string2 = ORG_SCHEMA_NAME_PROPERTY;
            while ((string = (String)properties.get(string2 + n)) != null) {
                baseMetadataObject = ExportXML.getObject(mdmDatabaseSchema, string, mdmDatabaseSchema.getOrganizationalSchemas());
                if (null != baseMetadataObject) {
                    arrayList.add(baseMetadataObject);
                }
                ++n;
            }
            n = 1;
            string2 = BUILD_PROCESS_NAME_PROPERTY;
            while ((string = (String)properties.get(string2 + n)) != null) {
                baseMetadataObject = ExportXML.getObject(mdmDatabaseSchema, string, mdmDatabaseSchema.getNamedBuildProcesses());
                if (null != baseMetadataObject) {
                    arrayList.add(baseMetadataObject);
                }
                ++n;
            }
            if (arrayList.size() == 0) {
                arrayList.add(mdmDatabaseSchema);
            }
            ExportXML.exportXML(mdmMetadataProvider, arrayList);
            dataProvider.close();
            oracleConnection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.toString());
        }
    }
}

