/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.metadata.deployment.AW;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmNamedBuildProcess;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmOrganizationalSchema;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmRootSchema;

public final class DeleteDBSchemaElements {
    public static final String JDBC_URL_PROPERTY_NAME = "url";
    public static final String USER_ID_PROPERTY_NAME = "user";
    public static final String PASSWORD_PROPERTY_NAME = "password";
    public static final String AW_NAME_PROPERTY = "aw";
    public static final String DIMENSION_NAME_PROPERTY = "dimension";
    public static final String CUBE_NAME_PROPERTY = "cube";
    public static final String ORG_SCHEMA_NAME_PROPERTY = "orgSchema";
    public static final String BUILD_PROCESS_NAME_PROPERTY = "buildProcess";
    public static final String TRACE = "trace";

    private static Properties parseCommandLineProperties(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; i += 2) {
            if (i + 1 == stringArray.length) {
                throw new IllegalArgumentException("Command-line arguments must be specified in the form -<PropertyName> <PropertyValue>, with name and value separated by whitespace.");
            }
            String string = stringArray[i].substring(1);
            String string2 = stringArray[i + 1];
            if (string.equalsIgnoreCase(AW_NAME_PROPERTY)) {
                string = string + ++n;
            } else if (string.equalsIgnoreCase(DIMENSION_NAME_PROPERTY)) {
                string = string + ++n2;
            } else if (string.equalsIgnoreCase(CUBE_NAME_PROPERTY)) {
                string = string + ++n3;
            } else if (string.equalsIgnoreCase(ORG_SCHEMA_NAME_PROPERTY)) {
                string = string + ++n4;
            } else if (string.equalsIgnoreCase(BUILD_PROCESS_NAME_PROPERTY)) {
                string = string + ++n5;
            }
            properties.put(string, string2);
        }
        properties.put("MetadataReaderMode", "11_ONLY");
        if (0 == n + n2 + n3 + n4 + n5) {
            throw new IllegalArgumentException("Must specifiy at least one of: -aw, -dimension, -cube, -orgSchema, -buildProcess");
        }
        return properties;
    }

    private static OracleConnection connect(Properties properties) throws SQLException {
        String string = (String)properties.get(JDBC_URL_PROPERTY_NAME);
        if (null == string) {
            throw new IllegalArgumentException("Must specifiy -url");
        }
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection connection = DriverManager.getConnection(string, properties);
        String string2 = (String)properties.get(TRACE);
        if ("YES".equalsIgnoreCase(string2)) {
            Statement statement = connection.createStatement();
            statement.execute("ALTER SESSION SET EVENTS='10046 trace name context forever, level 4'");
            statement.execute("ALTER SESSION SET TIMED_STATISTICS=TRUE");
            statement.execute("ALTER SESSION SET \"_XSOLAPI_DML_TRACE\"=TRUE");
            statement.execute("ALTER SESSION SET EVENTS='37377 trace name context forever, level 4'");
        }
        return (OracleConnection)connection;
    }

    private static Object getObjectToDelete(MdmDatabaseSchema mdmDatabaseSchema, String string, List list) {
        for (Object e : list) {
            String string2 = null;
            string2 = e instanceof AW ? ((AW)e).getName() : ((MdmObject)e).getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            System.out.println("Deleting " + e.getClass().getSimpleName() + " " + mdmDatabaseSchema.getName().toUpperCase() + "." + string.toUpperCase());
            return e;
        }
        return null;
    }

    private static void deleteAW(MdmDatabaseSchema mdmDatabaseSchema, String string) {
        AW aW = (AW)DeleteDBSchemaElements.getObjectToDelete(mdmDatabaseSchema, string, mdmDatabaseSchema.getAWs());
        if (aW != null) {
            mdmDatabaseSchema.removeAW(aW, true);
        }
    }

    private static void deleteDim(MdmDatabaseSchema mdmDatabaseSchema, String string) {
        MdmPrimaryDimension mdmPrimaryDimension = (MdmPrimaryDimension)DeleteDBSchemaElements.getObjectToDelete(mdmDatabaseSchema, string, mdmDatabaseSchema.getDimensions());
        if (mdmPrimaryDimension != null) {
            mdmDatabaseSchema.removeDimension(mdmPrimaryDimension);
        }
    }

    private static void deleteCube(MdmDatabaseSchema mdmDatabaseSchema, String string) {
        MdmCube mdmCube = (MdmCube)DeleteDBSchemaElements.getObjectToDelete(mdmDatabaseSchema, string, mdmDatabaseSchema.getCubes());
        if (mdmCube != null) {
            mdmDatabaseSchema.removeCube(mdmCube);
        }
    }

    private static void deleteOrgSchema(MdmDatabaseSchema mdmDatabaseSchema, String string) {
        MdmOrganizationalSchema mdmOrganizationalSchema = (MdmOrganizationalSchema)DeleteDBSchemaElements.getObjectToDelete(mdmDatabaseSchema, string, mdmDatabaseSchema.getOrganizationalSchemas());
        if (mdmOrganizationalSchema != null) {
            mdmDatabaseSchema.removeOrganizationalSchema(mdmOrganizationalSchema);
        }
    }

    private static void deleteBuildProcess(MdmDatabaseSchema mdmDatabaseSchema, String string) {
        MdmNamedBuildProcess mdmNamedBuildProcess = (MdmNamedBuildProcess)DeleteDBSchemaElements.getObjectToDelete(mdmDatabaseSchema, string, mdmDatabaseSchema.getNamedBuildProcesses());
        if (mdmNamedBuildProcess != null) {
            mdmDatabaseSchema.removeNamedBuildProcess(mdmNamedBuildProcess);
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            Properties properties = DeleteDBSchemaElements.parseCommandLineProperties(stringArray);
            OracleConnection oracleConnection = DeleteDBSchemaElements.connect(properties);
            System.out.println("Connected");
            DataProvider dataProvider = new DataProvider(null, properties);
            dataProvider.createSession(oracleConnection);
            if ("YES".equalsIgnoreCase((String)properties.get("pause"))) {
                System.out.println("Execution paused. Press return to continue.");
                try {
                    System.in.read();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.out.println("Create OLAP API Session");
            MdmMetadataProvider mdmMetadataProvider = dataProvider.getMdmMetadataProvider();
            MdmRootSchema mdmRootSchema = (MdmRootSchema)mdmMetadataProvider.getRootSchema();
            String string2 = (String)properties.get(USER_ID_PROPERTY_NAME);
            MdmDatabaseSchema mdmDatabaseSchema = mdmRootSchema.getDatabaseSchema(string2.toUpperCase());
            int n = 1;
            String string3 = AW_NAME_PROPERTY;
            while ((string = (String)properties.get(string3 + n)) != null) {
                DeleteDBSchemaElements.deleteAW(mdmDatabaseSchema, string);
                ++n;
            }
            n = 1;
            string3 = DIMENSION_NAME_PROPERTY;
            while ((string = (String)properties.get(string3 + n)) != null) {
                DeleteDBSchemaElements.deleteDim(mdmDatabaseSchema, string);
                ++n;
            }
            n = 1;
            string3 = CUBE_NAME_PROPERTY;
            while ((string = (String)properties.get(string3 + n)) != null) {
                DeleteDBSchemaElements.deleteCube(mdmDatabaseSchema, string);
                ++n;
            }
            n = 1;
            string3 = ORG_SCHEMA_NAME_PROPERTY;
            while ((string = (String)properties.get(string3 + n)) != null) {
                DeleteDBSchemaElements.deleteOrgSchema(mdmDatabaseSchema, string);
                ++n;
            }
            n = 1;
            string3 = BUILD_PROCESS_NAME_PROPERTY;
            while ((string = (String)properties.get(string3 + n)) != null) {
                DeleteDBSchemaElements.deleteBuildProcess(mdmDatabaseSchema, string);
                ++n;
            }
            System.out.println("Committing...");
            dataProvider.getTransactionProvider().commitCurrentTransaction();
            System.out.println("Commit Successful");
            dataProvider.close();
            oracleConnection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.toString());
        }
    }
}

