/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mtm;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mtm.MtmDataTypeConverter;
import oracle.olapi.metadata.mtm.MtmSource;
import oracle.olapi.metadata.mtm.MtmSourceDefinition;
import oracle.olapi.metadata.mtm.MtmTabularSource;
import oracle.olapi.metadata.mtm.MtmValueExpression;
import oracle.olapi.metadata.mtm.MtmXMLTags;

public abstract class MtmColumnExpression
extends MtmValueExpression
implements MtmSource {
    MtmSourceDefinition m_SourceDefinition = null;
    private boolean m_useNewXMLTag = true;
    private static final int[] NEW_TAG_SERVER_VERSION = new int[]{9, 2, 0, 4};

    MtmColumnExpression(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
        this.determineVersion(baseMetadataProvider);
    }

    public String getColumnName() {
        return this.getPropertyStringValue(MtmXMLTags.COLUMN_NAME);
    }

    public MtmTabularSource getTable() {
        return (MtmTabularSource)this.getPropertyObjectValue(MtmXMLTags.TABLE);
    }

    protected XMLTag getXMLTag() {
        return MtmXMLTags.COLUMN_EXPRESSION_TAG;
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        if (MtmXMLTags.COLUMN_NAME.matches(string, string2)) {
            return MtmXMLTags.COLUMN_NAME;
        }
        if (MtmXMLTags.TABLE.matches(string, string2)) {
            return MtmXMLTags.TABLE;
        }
        return super.getPropertyXMLTag(string, string2);
    }

    public void setColumnName(String string) {
        this.setPropertyStringValue(MtmXMLTags.COLUMN_NAME, string);
    }

    public void setTable(MtmTabularSource mtmTabularSource) {
        this.setPropertyObjectValue(MtmXMLTags.TABLE, mtmTabularSource);
    }

    protected boolean isNewTagSupported() {
        return this.m_useNewXMLTag;
    }

    private void determineVersion(BaseMetadataProvider baseMetadataProvider) {
        this.m_useNewXMLTag = baseMetadataProvider.getDataProvider().isServerVersionLaterThan(NEW_TAG_SERVER_VERSION);
    }

    public FundamentalMetadataObject getSourceDataType() {
        MtmDataTypeConverter mtmDataTypeConverter = this.getMetadataProvider().getMtmDataTypeConverter();
        return mtmDataTypeConverter.getFundamentalDataType(this.getColumnDataType());
    }

    public MetadataObject getSourceType() {
        return this.getSourceDataType();
    }

    public Source getSource() {
        return this.getSourceDefinition().getSource();
    }

    public SourceDefinition getSourceDefinition() {
        if (null == this.m_SourceDefinition) {
            this.m_SourceDefinition = new MtmSourceDefinition(this.getMetadataProvider(), this, this.getMetadataProvider().getDataProvider());
        }
        return this.m_SourceDefinition;
    }

    public Set getInputDefinitions() {
        return Collections.EMPTY_SET;
    }

    public List getOutputDefinitions() {
        return Collections.EMPTY_LIST;
    }
}

