/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmQueryColumn;
import oracle.olapi.metadata.mdm.MdmViewColumnOwner;
import oracle.olapi.syntax.SQLDataType;

public final class MdmViewColumn
implements MdmQueryColumn {
    private MdmViewColumnOwner m_Owner;
    private XMLTag m_NameTag;
    private String m_DefaultName;
    private SQLDataType m_FixedDataType;

    private XMLTag getNameTag() {
        return this.m_NameTag;
    }

    private SQLDataType getFixedDataType() {
        return this.m_FixedDataType;
    }

    private void setDefaultName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuffer.append('_');
                continue;
            }
            stringBuffer.append(c);
        }
        this.m_DefaultName = stringBuffer.toString();
    }

    MdmViewColumn(MdmViewColumnOwner mdmViewColumnOwner, String string, XMLTag xMLTag) {
        this(mdmViewColumnOwner, string, xMLTag, null);
    }

    MdmViewColumn(MdmViewColumnOwner mdmViewColumnOwner, String string, XMLTag xMLTag, SQLDataType sQLDataType) {
        this.m_Owner = mdmViewColumnOwner;
        this.m_NameTag = xMLTag;
        this.setDefaultName(string);
        this.m_FixedDataType = sQLDataType;
    }

    public String getName() {
        return this.getDefaultName();
    }

    public String getViewColumnName() {
        String string = this.getOwner().getColumnName(this.getNameTag());
        if (null == string || string.length() == 0) {
            string = this.getDefaultName();
        }
        return string;
    }

    public void setViewColumnName(String string) {
        this.getOwner().setColumnName(this.getNameTag(), string);
    }

    public SQLDataType getSQLDataType() {
        if (null != this.getFixedDataType()) {
            return this.getFixedDataType();
        }
        return this.getOwner().getSQLDataType();
    }

    public MdmViewColumnOwner getOwner() {
        return this.m_Owner;
    }

    public String getDefaultName() {
        return this.m_DefaultName;
    }
}

