/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.metadata.DuplicateMetadataIDException;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mapping.SolvedValueHierarchyMap;
import oracle.olapi.metadata.mdm.MdmDimensionMemberInfo;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmInvalidValueException;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.metadata.mtm.MtmValueHierarchyMap;

public final class MdmValueHierarchy
extends MdmHierarchy {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.SOLVED_VALUE_HIERARCHY_MAP};

    MdmValueHierarchy(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    MdmValueHierarchy(String string, short s, MdmPrimaryDimension mdmPrimaryDimension) {
        super(string, s, mdmPrimaryDimension);
    }

    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        return mdmObjectVisitor.visitMdmValueHierarchy(this, object);
    }

    public MtmValueHierarchyMap getValueHierarchyMap() throws MetadataNotFoundException {
        return (MtmValueHierarchyMap)this.getSourceMap();
    }

    protected XMLTag getXMLTag() {
        return MdmXMLTags.VALUE_HIERARCHY_TAG;
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public MdmDimensionMemberInfo getDefaultMember() throws MetadataNotFoundException {
        String string = this.getPropertyStringValue(MdmXMLTags.DEFAULT_MEMBER);
        if (string != null) {
            return new MdmDimensionMemberInfo(this, (Object)string);
        }
        throw new MetadataNotFoundException();
    }

    public void setDefaultMember(MdmDimensionMemberInfo mdmDimensionMemberInfo) throws MetadataNotFoundException, MdmInvalidValueException {
        if (mdmDimensionMemberInfo.getHierarchy() != this) {
            throw new MdmInvalidValueException("Default member must be a member of this hierarchy.");
        }
        this.setPropertyStringValue(MdmXMLTags.DEFAULT_MEMBER, mdmDimensionMemberInfo.getLocalValue().toString());
    }

    public final SolvedValueHierarchyMap getSolvedHierarchyMap() {
        return (SolvedValueHierarchyMap)this.getPropertyObjectValue(MdmXMLTags.SOLVED_VALUE_HIERARCHY_MAP);
    }

    public final void setSolvedHierarchyMap(SolvedValueHierarchyMap solvedValueHierarchyMap) {
        this.setPropertyObjectValue(MdmXMLTags.SOLVED_VALUE_HIERARCHY_MAP, solvedValueHierarchyMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolvedValueHierarchyMap findOrCreateSolvedValueHierarchyMap() {
        SolvedValueHierarchyMap solvedValueHierarchyMap = null;
        String string = MdmValueHierarchy.generateID(new String[]{this.getInternalID(), "MAP"});
        MetadataObject metadataObject = this.getMetadataProvider().fetchMetadataObject(string);
        if (null == metadataObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                metadataObject = this.getMetadataProvider().fetchMetadataObject(string);
                if (null == metadataObject) {
                    solvedValueHierarchyMap = new SolvedValueHierarchyMap(string, 0, this);
                    this.setSolvedHierarchyMap(solvedValueHierarchyMap);
                    return solvedValueHierarchyMap;
                }
            }
        }
        if (metadataObject instanceof SolvedValueHierarchyMap) {
            solvedValueHierarchyMap = (SolvedValueHierarchyMap)metadataObject;
            this.setSolvedHierarchyMap(solvedValueHierarchyMap);
        } else if (null != metadataObject) {
            throw new DuplicateMetadataIDException(metadataObject.getID());
        }
        return solvedValueHierarchyMap;
    }
}

