/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.Iterator;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.DuplicateMetadataIDException;
import oracle.olapi.metadata.MetadataModificationException;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mapping.HierarchyLevelMap;
import oracle.olapi.metadata.mdm.Mdm11_ObjectVisitor;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmDimensionLevel;
import oracle.olapi.metadata.mdm.MdmInvalidValueException;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSubDimension;
import oracle.olapi.metadata.mdm.MdmXMLTags;

public class MdmHierarchyLevel
extends MdmSubDimension {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.DIMENSION_LEVEL_REF, MdmXMLTags.HIERARCHY_LEVEL_MAP, MdmXMLTags.HIERARCHY_ID};

    public static final XMLTag classGetContainedByPropertyTag() {
        return MdmXMLTags.HIERARCHY_ID;
    }

    MdmHierarchyLevel(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    MdmHierarchyLevel(String string, short s, MdmLevelHierarchy mdmLevelHierarchy) {
        super(null, string, s, mdmLevelHierarchy);
    }

    protected XMLTag getXMLTag() {
        return MdmXMLTags.HIERARCHY_LEVEL_TAG;
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        if (mdmObjectVisitor instanceof Mdm11_ObjectVisitor) {
            return ((Mdm11_ObjectVisitor)mdmObjectVisitor).visitMdmHierarchyLevel(this, object);
        }
        return null;
    }

    public MdmLevelHierarchy getLevelHierarchy() {
        return (MdmLevelHierarchy)this.getContainedByObject();
    }

    public final String getName() throws MetadataNotFoundException {
        if (this.getDimensionLevel() != null) {
            return this.getDimensionLevel().getName();
        }
        return super.getName();
    }

    public MdmDimension getEnclosingDimension() {
        return this.getLevelHierarchy();
    }

    void setLevelHierarchy(MdmLevelHierarchy mdmLevelHierarchy) {
        this.setContainedByObject(mdmLevelHierarchy);
    }

    public int getLevelDepth() {
        Iterator iterator = this.getLevelHierarchy().getLevels().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            MdmHierarchyLevel mdmHierarchyLevel = (MdmHierarchyLevel)iterator.next();
            if (mdmHierarchyLevel == this) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public MdmDimensionLevel getDimensionLevel() {
        return (MdmDimensionLevel)this.getPropertyObjectValue(MdmXMLTags.DIMENSION_LEVEL_REF);
    }

    public void setDimensionLevel(MdmDimensionLevel mdmDimensionLevel) {
        if (this.getDimensionLevel() != null && this.getDimensionLevel() != mdmDimensionLevel) {
            throw new MdmInvalidValueException("Cannot change DimensionLevel of a HierarchyLevel.");
        }
        this.setPropertyObjectValue(MdmXMLTags.DIMENSION_LEVEL_REF, mdmDimensionLevel);
    }

    public final void setName(String string) {
        if (this.getDimensionLevel() != null) {
            throw new MetadataModificationException("UnmodifiableAttribute", MdmXMLTags.NAME.getVersionedValue("1.0"), this.getID());
        }
        super.setName(string);
    }

    public final MdmPrimaryDimension getPrimaryDimension(short s) {
        MdmLevelHierarchy mdmLevelHierarchy = (MdmLevelHierarchy)this.getContainedByObject(s);
        return mdmLevelHierarchy.getPrimaryDimension(s);
    }

    public final HierarchyLevelMap getHierarchyLevelMap() {
        return (HierarchyLevelMap)this.getPropertyObjectValue(MdmXMLTags.HIERARCHY_LEVEL_MAP);
    }

    protected final SourceDefinition getTypeDefinition() {
        return this.getLevelHierarchy().getSource().getDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HierarchyLevelMap findOrCreateHierarchyLevelMap() {
        HierarchyLevelMap hierarchyLevelMap = null;
        String string = MdmHierarchyLevel.generateID(new String[]{this.getInternalID(), "MAP"});
        MetadataObject metadataObject = this.getMetadataProvider().fetchMetadataObject(string);
        if (null == metadataObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                metadataObject = this.getMetadataProvider().fetchMetadataObject(string);
                if (null == metadataObject) {
                    hierarchyLevelMap = new HierarchyLevelMap(MdmXMLTags.HIERARCHY_LEVEL_MAP, string, 0, this);
                    this.setHierarchyLevelMap(hierarchyLevelMap);
                    return hierarchyLevelMap;
                }
            }
        }
        if (metadataObject instanceof HierarchyLevelMap) {
            hierarchyLevelMap = (HierarchyLevelMap)metadataObject;
            this.setHierarchyLevelMap(hierarchyLevelMap);
        } else if (null != metadataObject) {
            throw new DuplicateMetadataIDException(metadataObject.getID());
        }
        return hierarchyLevelMap;
    }

    public void setHierarchyLevelMap(HierarchyLevelMap hierarchyLevelMap) {
        this.setPropertyObjectValue(MdmXMLTags.HIERARCHY_LEVEL_MAP, hierarchyLevelMap);
    }

    public static final boolean classHasPrivateName() {
        return true;
    }

    public static final XMLTag classGetObjRefIDAttribute() {
        return MdmXMLTags.DIMENSION_LEVEL_REF;
    }
}

