/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import oracle.olapi.data.source.ModelAssignmentManager;
import oracle.olapi.internal.CopyPolicy;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.Mdm10_1_0_3_ObjectVisitor;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmAttributeModel;
import oracle.olapi.metadata.mdm.MdmBaseAttribute;
import oracle.olapi.metadata.mdm.MdmBaseMeasure;
import oracle.olapi.metadata.mdm.MdmDimensionCalculationModel;
import oracle.olapi.metadata.mdm.MdmDimensionedObject;
import oracle.olapi.metadata.mdm.MdmDimensionedObjectModel;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMeasureDimension;
import oracle.olapi.metadata.mdm.MdmMeasureModel;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmModel;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmObjectFactory;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.metadata.mdm.MdmStandardDimension;
import oracle.olapi.metadata.mdm.MdmStandardMember;
import oracle.olapi.metadata.mdm.MdmSubDimension;
import oracle.olapi.metadata.mdm.MdmTimeDimension;
import oracle.olapi.metadata.mdm.MdmTimeMember;
import oracle.olapi.metadata.mdm.MdmValueHierarchy;
import oracle.olapi.metadata.mdm.MdmXMLTags;

class MdmCopyVisitor
implements Mdm10_1_0_3_ObjectVisitor {
    private static MdmCopyVisitor sInstance = new MdmCopyVisitor();

    private MdmCopyVisitor() {
    }

    private static MdmCopyVisitor getInstance() {
        return sInstance;
    }

    public static MdmObject createCopy(MdmObject mdmObject, CopyPolicy copyPolicy) {
        return (MdmObject)mdmObject.acceptVisitor(MdmCopyVisitor.getInstance(), copyPolicy);
    }

    private MdmObject copyMdmObject(MdmObject mdmObject, MdmObject mdmObject2, Object object) {
        if (mdmObject2 instanceof MdmSubDimension) {
            this.copyExternalProperty(mdmObject, mdmObject2, object, MdmXMLTags.TYPE);
        } else {
            this.copyExternalProperty(mdmObject, mdmObject2, object, MdmXMLTags.DATA_TYPE);
        }
        this.copyRemainingProperties(mdmObject, mdmObject2, object);
        return mdmObject;
    }

    private MdmDimensionedObject copyDimensionedObject(MdmDimensionedObject mdmDimensionedObject, MdmDimensionedObject mdmDimensionedObject2, Object object) {
        this.copyExternalProperty(mdmDimensionedObject, mdmDimensionedObject2, object, MdmXMLTags.DIMENSIONALITY);
        return (MdmDimensionedObject)this.copyMdmObject(mdmDimensionedObject, mdmDimensionedObject2, object);
    }

    public Object visitMdmAttribute(MdmAttribute mdmAttribute, Object object) {
        MdmBaseAttribute mdmBaseAttribute = new MdmBaseAttribute((MdmMetadataProvider)mdmAttribute.getBaseMetadataProvider());
        this.getMdmObjectFactory(mdmAttribute).registerObject(mdmBaseAttribute, this.generateCloneID(mdmAttribute));
        return this.copyDimensionedObject(mdmBaseAttribute, mdmAttribute, object);
    }

    public Object visitMdmMeasure(MdmMeasure mdmMeasure, Object object) {
        MdmBaseMeasure mdmBaseMeasure = new MdmBaseMeasure((MdmMetadataProvider)mdmMeasure.getBaseMetadataProvider());
        this.getMdmObjectFactory(mdmMeasure).registerObject(mdmBaseMeasure, this.generateCloneID(mdmMeasure));
        if (mdmMeasure.getSourceMap() == null) {
            mdmBaseMeasure.setSourceDefinition(mdmMeasure.getSourceDefinition());
        }
        return this.copyDimensionedObject(mdmBaseMeasure, mdmMeasure, object);
    }

    private MdmSubDimension copySubDimension(MdmSubDimension mdmSubDimension, MdmSubDimension mdmSubDimension2, Object object) {
        return (MdmSubDimension)this.copyMdmObject(mdmSubDimension, mdmSubDimension2, object);
    }

    private MdmHierarchy copyHierarchy(MdmHierarchy mdmHierarchy, MdmHierarchy mdmHierarchy2, Object object) {
        mdmHierarchy.setPrimaryDimension((MdmPrimaryDimension)((CopyPolicy)object).copyUpReference(mdmHierarchy2.getPrimaryDimension()));
        this.copySubDimension(mdmHierarchy, mdmHierarchy2, object);
        return mdmHierarchy;
    }

    public Object visitMdmLevel(MdmLevel mdmLevel, Object object) {
        MdmLevel mdmLevel2 = this.getMdmObjectFactory(mdmLevel).createLevel(this.generateCloneID(mdmLevel));
        this.copyUpProperty(mdmLevel2, mdmLevel, object, MdmXMLTags.HIERARCHY_ID);
        return this.copySubDimension(mdmLevel2, mdmLevel, object);
    }

    public Object visitMdmLevelHierarchy(MdmLevelHierarchy mdmLevelHierarchy, Object object) {
        MdmLevelHierarchy mdmLevelHierarchy2 = this.getMdmObjectFactory(mdmLevelHierarchy).createLevelHierarchy(this.generateCloneID(mdmLevelHierarchy));
        return this.copyHierarchy(mdmLevelHierarchy2, mdmLevelHierarchy, object);
    }

    public Object visitMdmValueHierarchy(MdmValueHierarchy mdmValueHierarchy, Object object) {
        MdmValueHierarchy mdmValueHierarchy2 = this.getMdmObjectFactory(mdmValueHierarchy).createValueHierarchy(this.generateCloneID(mdmValueHierarchy));
        return this.copyHierarchy(mdmValueHierarchy2, mdmValueHierarchy, object);
    }

    private MdmPrimaryDimension copyPrimaryDimension(MdmPrimaryDimension mdmPrimaryDimension, MdmPrimaryDimension mdmPrimaryDimension2, Object object) {
        return (MdmPrimaryDimension)this.copyMdmObject(mdmPrimaryDimension, mdmPrimaryDimension2, object);
    }

    public Object visitMdmMeasureDimension(MdmMeasureDimension mdmMeasureDimension, Object object) {
        MdmMeasureDimension mdmMeasureDimension2 = this.getMdmObjectFactory(mdmMeasureDimension).createMeasureDimension(this.generateCloneID(mdmMeasureDimension));
        return this.copyPrimaryDimension(mdmMeasureDimension2, mdmMeasureDimension, object);
    }

    public Object visitMdmStandardDimension(MdmStandardDimension mdmStandardDimension, Object object) {
        MdmStandardDimension mdmStandardDimension2 = this.getMdmObjectFactory(mdmStandardDimension).createStandardDimension(this.generateCloneID(mdmStandardDimension));
        return this.copyPrimaryDimension(mdmStandardDimension2, mdmStandardDimension, object);
    }

    public Object visitMdmTimeDimension(MdmTimeDimension mdmTimeDimension, Object object) {
        MdmTimeDimension mdmTimeDimension2 = this.getMdmObjectFactory(mdmTimeDimension).createTimeDimension(this.generateCloneID(mdmTimeDimension));
        return this.copyPrimaryDimension(mdmTimeDimension2, mdmTimeDimension, object);
    }

    public Object visitMdmSchema(MdmSchema mdmSchema, Object object) {
        MdmSchema mdmSchema2 = this.getMdmObjectFactory(mdmSchema).createSchema(this.generateCloneID(mdmSchema));
        return this.copyMdmObject(mdmSchema2, mdmSchema, object);
    }

    private MdmModel copyMdmModel(MdmModel mdmModel, MdmModel mdmModel2, Object object) {
        ModelAssignmentManager modelAssignmentManager = mdmModel2.getManager();
        ModelAssignmentManager modelAssignmentManager2 = mdmModel.getManager();
        modelAssignmentManager.copyTo(modelAssignmentManager2);
        return (MdmModel)this.copyMdmObject(mdmModel, mdmModel2, object);
    }

    public Object visitMdmDimensionCalculationModel(MdmDimensionCalculationModel mdmDimensionCalculationModel, Object object) {
        MdmDimensionCalculationModel mdmDimensionCalculationModel2 = this.getMdmObjectFactory(mdmDimensionCalculationModel).createDimensionCalculationModel(this.generateCloneID(mdmDimensionCalculationModel));
        this.copyUpProperty(mdmDimensionCalculationModel2, mdmDimensionCalculationModel, object, MdmXMLTags.CONTAINER_DIMENSION);
        return this.copyMdmModel(mdmDimensionCalculationModel2, mdmDimensionCalculationModel, object);
    }

    private MdmDimensionedObjectModel copyMdmDimensionedObjectModel(MdmDimensionedObjectModel mdmDimensionedObjectModel, MdmDimensionedObjectModel mdmDimensionedObjectModel2, Object object) {
        return (MdmDimensionedObjectModel)this.copyMdmModel(mdmDimensionedObjectModel, mdmDimensionedObjectModel2, object);
    }

    public Object visitMdmAttributeModel(MdmAttributeModel mdmAttributeModel, Object object) {
        MdmAttributeModel mdmAttributeModel2 = this.getMdmObjectFactory(mdmAttributeModel).createAttributeModel(this.generateCloneID(mdmAttributeModel));
        this.copyUpProperty(mdmAttributeModel2, mdmAttributeModel, object, MdmXMLTags.CONTAINER_ATTRIBUTE);
        return this.copyMdmDimensionedObjectModel(mdmAttributeModel2, mdmAttributeModel, object);
    }

    public Object visitMdmMeasureModel(MdmMeasureModel mdmMeasureModel, Object object) {
        MdmMeasureModel mdmMeasureModel2 = this.getMdmObjectFactory(mdmMeasureModel).createMeasureModel(this.generateCloneID(mdmMeasureModel));
        this.copyUpProperty(mdmMeasureModel2, mdmMeasureModel, object, MdmXMLTags.CONTAINER_MEASURE);
        return this.copyMdmDimensionedObjectModel(mdmMeasureModel2, mdmMeasureModel, object);
    }

    public Object visitMdmStandardMember(MdmStandardMember mdmStandardMember, Object object) {
        MdmStandardMember mdmStandardMember2 = this.getMdmObjectFactory(mdmStandardMember).createStandardMember(this.generateCloneID(mdmStandardMember));
        mdmStandardMember2.setSourceDefinition(mdmStandardMember.getSourceDefinition());
        this.copyExternalProperty(mdmStandardMember2, mdmStandardMember, object, MdmXMLTags.LEVEL_REF);
        this.copyExternalProperty(mdmStandardMember2, mdmStandardMember, object, MdmXMLTags.PARENT_LEVEL_REF);
        this.copyExternalProperty(mdmStandardMember2, mdmStandardMember, object, MdmXMLTags.VALUE_HIER_REF);
        return this.copyMdmObject(mdmStandardMember2, mdmStandardMember, object);
    }

    public Object visitMdmTimeMember(MdmTimeMember mdmTimeMember, Object object) {
        MdmTimeMember mdmTimeMember2 = this.getMdmObjectFactory(mdmTimeMember).createTimeMember(this.generateCloneID(mdmTimeMember));
        mdmTimeMember2.setSourceDefinition(mdmTimeMember.getSourceDefinition());
        this.copyExternalProperty(mdmTimeMember2, mdmTimeMember, object, MdmXMLTags.LEVEL_REF);
        this.copyExternalProperty(mdmTimeMember2, mdmTimeMember, object, MdmXMLTags.PARENT_LEVEL_REF);
        this.copyExternalProperty(mdmTimeMember2, mdmTimeMember, object, MdmXMLTags.VALUE_HIER_REF);
        return this.copyMdmObject(mdmTimeMember2, mdmTimeMember, object);
    }

    private void copyUpProperty(MdmObject mdmObject, MdmObject mdmObject2, Object object, XMLTag xMLTag) {
        CopyPolicy copyPolicy = (CopyPolicy)object;
        mdmObject2.copyPropertyTo(mdmObject, xMLTag, copyPolicy, CopyPolicy.UP_REFERENCE_TYPE);
    }

    private void copyExternalProperty(MdmObject mdmObject, MdmObject mdmObject2, Object object, XMLTag xMLTag) {
        CopyPolicy copyPolicy = (CopyPolicy)object;
        mdmObject2.copyPropertyTo(mdmObject, xMLTag, copyPolicy, CopyPolicy.EXTERNAL_REFERENCE_TYPE);
    }

    private void copyRemainingProperties(MdmObject mdmObject, MdmObject mdmObject2, Object object) {
        CopyPolicy copyPolicy = (CopyPolicy)object;
        copyPolicy.registerCopy(mdmObject2, mdmObject);
        mdmObject2.copyAllPropertiesTo(mdmObject, copyPolicy, CopyPolicy.DOWN_REFERENCE_TYPE);
    }

    private MdmObjectFactory getMdmObjectFactory(MdmObject mdmObject) {
        return ((MdmMetadataProvider)mdmObject.getBaseMetadataProvider()).getMdmObjectFactory();
    }

    private String generateCloneID(MdmObject mdmObject) {
        return ((MdmMetadataProvider)mdmObject.getBaseMetadataProvider()).getMdmNamingConvention().generateCloneID(mdmObject);
    }
}

