/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.olapi.metadata.mdm.CubeUpgradeInfoSelector;
import oracle.olapi.metadata.mdm.MdmAWXMLNamingConvention;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmAttributeModel;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDerivedAttribute;
import oracle.olapi.metadata.mdm.MdmDimensionCalculationModel;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmHierarchyLevel;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMeasureDimension;
import oracle.olapi.metadata.mdm.MdmMeasureModel;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmMultiValuedDerivedAttribute;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmOrganizationalSchema;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.syntax.parser.Identifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Mdm102IDToObjectConverter {
    private MdmMetadataProvider m_MdmMetadataProvider = null;

    Mdm102IDToObjectConverter(MdmMetadataProvider mdmMetadataProvider) {
        this.m_MdmMetadataProvider = mdmMetadataProvider;
    }

    List<MdmObject> convertIDs(String[] stringArray) {
        Iterator<String> iterator;
        ArrayList<String> arrayList;
        ArrayList<IDHolder> arrayList2 = new ArrayList<IDHolder>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            IDHolder iDHolder = new IDHolder(this, stringArray[i]);
            arrayList2.add(iDHolder);
            this.parse102ID(iDHolder);
            arrayList = iDHolder.getFetchIDs();
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                arrayList3.add(iterator.next());
            }
        }
        String[] stringArray2 = new String[arrayList3.size()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = (String)arrayList3.get(i);
        }
        List list = this.getMdmMetadataProvider().getMetadataObjects(stringArray2);
        arrayList = new ArrayList(stringArray.length);
        iterator = list.iterator();
        for (int i = 0; i < arrayList2.size(); ++i) {
            IDHolder iDHolder = (IDHolder)arrayList2.get(i);
            ArrayList<String> arrayList4 = iDHolder.getFetchIDs();
            MdmObject mdmObject = null;
            int n = 0;
            Iterator<String> iterator2 = arrayList4.iterator();
            while (iterator2.hasNext()) {
                MdmObject mdmObject2 = (MdmObject)((Object)iterator.next());
                if (null == mdmObject) {
                    ArrayList<Class> arrayList5 = iDHolder.getFetchIDClassTypes(n);
                    mdmObject = this.lookupObject(iDHolder, mdmObject2, arrayList5);
                }
                iterator2.next();
                ++n;
            }
            arrayList.add((String)((Object)mdmObject));
        }
        return arrayList;
    }

    private void parse102ID(IDHolder iDHolder) {
        int n = iDHolder.getNum102IDComponents();
        String string = iDHolder.get102IDComponent(0);
        if (1 == n && string.equals("RootSchema")) {
            iDHolder.addFetchIDComponent("RootSchema");
            iDHolder.addFetchClassType(MdmSchema.class);
        } else if (string.startsWith("MEASUREDIMENSION")) {
            this.parse102MeasureDimensionID(iDHolder);
        } else if (string.startsWith("D_")) {
            this.parse102DimensionID(iDHolder);
        } else if (string.startsWith("M_")) {
            this.parse102MeasureID(iDHolder);
        } else if (string.startsWith("C_")) {
            this.parse102SchemaID(iDHolder);
        }
    }

    private void parse102MeasureDimensionID(IDHolder iDHolder) {
        iDHolder.addFetchIDComponent("RootSchema");
        this.parse102DimensionID(iDHolder, 0);
    }

    private void parse102DimensionID(IDHolder iDHolder) {
        int n = iDHolder.getNum102IDComponents();
        if (n < 2) {
            return;
        }
        String string = iDHolder.get102IDComponent(0);
        String string2 = iDHolder.get102IDComponent(1);
        if (n == 2 && string2.startsWith("MEASUREDIMENSION")) {
            iDHolder.addFetchIDComponent("RootSchema");
        } else {
            iDHolder.addFetchIDComponent(string.substring(2));
            iDHolder.setNamespaceType(1);
        }
        this.parse102DimensionID(iDHolder, 1);
    }

    private void parse102DimensionID(IDHolder iDHolder, int n) {
        int n2 = iDHolder.getNum102IDComponents();
        String string = iDHolder.get102IDComponent(n);
        String string2 = null;
        if (string.endsWith("PARENT_ATTRIBUTE")) {
            string2 = "PARENT_ATTRIBUTE";
        } else if (string.endsWith("ANCESTORS_ATTRIBUTE")) {
            string2 = "ANCESTORS_ATTRIBUTE";
        } else if (string.endsWith("LEVEL_ATTRIBUTE")) {
            string2 = "LEVEL_ATTRIBUTE";
        } else if (string.endsWith("LEVELDEPTH_ATTRIBUTE")) {
            string2 = "LEVELDEPTH_ATTRIBUTE";
        } else if (string.endsWith("LOCAL_VALUE_ATTRIBUTE")) {
            string2 = "LOCAL_VALUE_ATTRIBUTE";
        } else if (string.endsWith("HIERARCHY_ATTRIBUTE")) {
            string2 = "HIERARCHY_ATTRIBUTE";
        } else if (string.endsWith("ISCUSTOMMEMBER_ATTRIBUTE")) {
            string2 = "ISCUSTOMMEMBER_ATTRIBUTE";
        } else if (string.endsWith("VALUE_LINEAGE_ATTRIBUTE")) {
            string2 = "VALUE_LINEAGE_ATTRIBUTE";
        }
        if (null != string2 && (n + 1 == n2 || n + 2 == n2 && iDHolder.get102IDComponent(n + 1).equals("MODEL"))) {
            string = string.substring(0, string.length() - string2.length());
        } else {
            string2 = null;
        }
        if (string.equals("MEASUREDIMENSION")) {
            iDHolder.addFetchIDComponent("MEASURE_DIMENSION");
            if (n + 1 == n2 && null == string2) {
                iDHolder.addFetchClassType(MdmMeasureDimension.class);
                return;
            }
        } else {
            iDHolder.addFetchIDComponent(string);
            if (n + 1 == n2 && null == string2) {
                iDHolder.addFetchClassType(MdmPrimaryDimension.class);
                return;
            }
        }
        if (n + 1 == n2) {
            if ("ANCESTORS_ATTRIBUTE" == string2) {
                iDHolder.set102ClassType(MdmMultiValuedDerivedAttribute.class);
            } else {
                iDHolder.set102ClassType(MdmDerivedAttribute.class);
            }
            iDHolder.addFetchClassType(MdmPrimaryDimension.class);
        } else if (n + 2 == n2) {
            if (null == string2) {
                iDHolder.addFetchIDComponent(iDHolder.get102IDComponent(n + 1));
                iDHolder.addFetchClassType(MdmHierarchy.class);
                iDHolder.addFetchClassType(MdmAttribute.class);
            } else {
                iDHolder.set102ClassType(MdmAttributeModel.class);
                iDHolder.addFetchClassType(MdmPrimaryDimension.class);
            }
        } else if (n + 3 == n2) {
            String string3 = iDHolder.get102IDComponent(n + 1);
            String string4 = iDHolder.get102IDComponent(n + 2);
            if (string3.equals("CALCMODEL")) {
                iDHolder.set102ClassType(MdmDimensionCalculationModel.class);
                iDHolder.addFetchClassType(MdmPrimaryDimension.class);
            } else if (string4.equals("MODEL")) {
                iDHolder.addFetchIDComponent(string3);
                iDHolder.set102ClassType(MdmAttributeModel.class);
                iDHolder.addFetchClassType(MdmAttribute.class);
            }
        } else if (n + 4 == n2) {
            String string5 = iDHolder.get102IDComponent(n + 1);
            String string6 = iDHolder.get102IDComponent(n + 2);
            String string7 = iDHolder.get102IDComponent(n + 3);
            if (string6.equals("L")) {
                iDHolder.addFetchIDComponent(string5);
                iDHolder.addFetchIDComponent(string7);
                iDHolder.addFetchClassType(MdmHierarchyLevel.class);
            }
        }
    }

    private void parse102MeasureID(IDHolder iDHolder) {
        int n = iDHolder.getNum102IDComponents();
        if (3 == n) {
            iDHolder.addFetchClassType(MdmMeasure.class);
        } else if (4 == n) {
            iDHolder.set102ClassType(MdmMeasureModel.class);
            iDHolder.addFetchClassType(MdmMeasure.class);
        } else {
            return;
        }
        iDHolder.setNamespaceType(2);
        iDHolder.addFetchIDComponent(iDHolder.get102IDComponent(0).substring(2));
        iDHolder.addFetchIDComponent(iDHolder.get102IDComponent(1));
        iDHolder.addFetchIDComponent(iDHolder.get102IDComponent(2));
    }

    private void parse102SchemaID(IDHolder iDHolder) {
        if (1 != iDHolder.getNum102IDComponents()) {
            return;
        }
        iDHolder.set102ClassType(MdmOrganizationalSchema.class);
        iDHolder.addFetchClassType(MdmSchema.class);
        iDHolder.addFetchIDComponent("RootSchema");
    }

    private MdmObject lookupObject(IDHolder iDHolder, MdmObject mdmObject, ArrayList<Class> arrayList) {
        if (null == mdmObject) {
            return null;
        }
        boolean bl = false;
        for (Class object2 : arrayList) {
            if (!object2.isInstance(mdmObject)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        int n = iDHolder.getNum102IDComponents();
        if (MdmMultiValuedDerivedAttribute.class == iDHolder.get102ClassType() || MdmDerivedAttribute.class == iDHolder.get102ClassType()) {
            MdmPrimaryDimension mdmPrimaryDimension = (MdmPrimaryDimension)mdmObject;
            return this.lookupDerivedAttribute(iDHolder, mdmPrimaryDimension);
        }
        if (MdmAttributeModel.class == iDHolder.get102ClassType()) {
            if (mdmObject instanceof MdmAttribute) {
                return ((MdmAttribute)mdmObject).getAttributeModel();
            }
            MdmPrimaryDimension mdmPrimaryDimension = (MdmPrimaryDimension)mdmObject;
            MdmAttribute mdmAttribute = this.lookupDerivedAttribute(iDHolder, mdmPrimaryDimension);
            if (null == mdmAttribute) {
                return null;
            }
            return mdmAttribute.getAttributeModel();
        }
        if (MdmDimensionCalculationModel.class == iDHolder.get102ClassType()) {
            MdmPrimaryDimension mdmPrimaryDimension = (MdmPrimaryDimension)mdmObject;
            String string = iDHolder.get102IDComponent(n - 1);
            if (string.equals("DataType!String")) {
                return mdmPrimaryDimension.getStringCalcModel();
            }
            if (string.equals("DataType!Boolean")) {
                return mdmPrimaryDimension.getBooleanCalcModel();
            }
            if (string.equals("DataType!Date")) {
                return mdmPrimaryDimension.getDateCalcModel();
            }
            if (string.equals("DataType!Number")) {
                return mdmPrimaryDimension.getNumberCalcModel();
            }
            if (string.equals("DataType!Value")) {
                return ((MdmMeasureDimension)mdmPrimaryDimension).getValueCalcModel();
            }
            return null;
        }
        if (MdmMeasureModel.class == iDHolder.get102ClassType()) {
            MdmMeasure mdmMeasure = (MdmMeasure)mdmObject;
            return mdmMeasure.getMeasureModel();
        }
        if (MdmOrganizationalSchema.class == iDHolder.get102ClassType()) {
            MdmSchema mdmSchema = (MdmSchema)mdmObject;
            String string = iDHolder.get102IDComponent(0).substring(2);
            List list = mdmSchema.getSubSchemas();
            for (MdmSchema mdmSchema2 : list) {
                if (!mdmSchema2.getName().equals(string)) continue;
                return mdmSchema2;
            }
            return null;
        }
        return mdmObject;
    }

    private MdmAttribute lookupDerivedAttribute(IDHolder iDHolder, MdmPrimaryDimension mdmPrimaryDimension) {
        String string = iDHolder.get102IDComponent(0);
        if (string.startsWith("D_")) {
            string = iDHolder.get102IDComponent(1);
        }
        if (string.endsWith("PARENT_ATTRIBUTE")) {
            return mdmPrimaryDimension.getParentAttribute();
        }
        if (string.endsWith("ANCESTORS_ATTRIBUTE")) {
            return mdmPrimaryDimension.getAncestorsAttribute();
        }
        if (string.endsWith("LEVEL_ATTRIBUTE")) {
            return mdmPrimaryDimension.getLevelAttribute();
        }
        if (string.endsWith("LEVELDEPTH_ATTRIBUTE")) {
            return mdmPrimaryDimension.getLevelDepthAttribute();
        }
        if (string.endsWith("LOCAL_VALUE_ATTRIBUTE")) {
            return mdmPrimaryDimension.getLocalValueAttribute();
        }
        if (string.endsWith("HIERARCHY_ATTRIBUTE")) {
            return mdmPrimaryDimension.getHierarchyAttribute();
        }
        if (string.endsWith("ISCUSTOMMEMBER_ATTRIBUTE")) {
            return mdmPrimaryDimension.getIsCustomMemberAttribute();
        }
        if (string.endsWith("VALUE_LINEAGE_ATTRIBUTE")) {
            return mdmPrimaryDimension.getValueLineageAttribute();
        }
        return null;
    }

    MdmMetadataProvider getMdmMetadataProvider() {
        return this.m_MdmMetadataProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IDHolder {
        static final int DEFAULT_NAMESPACE = 0;
        static final int DIMENSION_NAMESPACE = 1;
        static final int MEASURE_NAMESPACE = 2;
        static final int SCHEMA_NAMESPACE = 3;
        private Mdm102IDToObjectConverter m_IDConverter = null;
        private Identifier m_102ID = null;
        private Identifier m_FetchID = new Identifier();
        private Identifier[] m_RenamedFetchIDs = null;
        private ArrayList<Class> m_FetchClassTypes = new ArrayList();
        private Class m_102ClassType = null;
        private int m_NamespaceType = 0;
        private ArrayList<String> m_FetchIDs = null;
        private ArrayList<Class> m_FetchIDClassTypes = null;

        IDHolder(Mdm102IDToObjectConverter mdm102IDToObjectConverter2, String string) {
            this.m_IDConverter = mdm102IDToObjectConverter2;
            this.m_102ID = Identifier.parseID(string);
        }

        Mdm102IDToObjectConverter getIDConverter() {
            return this.m_IDConverter;
        }

        String get102IDComponent(int n) {
            return this.m_102ID.getComponent(n);
        }

        int getNum102IDComponents() {
            return this.m_102ID.getNumComponents();
        }

        void addFetchIDComponent(String string) {
            this.m_FetchID.addComponent(string);
        }

        void set102ClassType(Class clazz) {
            this.m_102ClassType = clazz;
        }

        Class get102ClassType() {
            return this.m_102ClassType;
        }

        void addFetchClassType(Class clazz) {
            this.getFetchClassTypes().add(clazz);
        }

        ArrayList<Class> getFetchClassTypes() {
            return this.m_FetchClassTypes;
        }

        Class getFetchClassType(int n) {
            return this.m_FetchClassTypes.get(n);
        }

        void setNamespaceType(int n) {
            this.m_NamespaceType = n;
        }

        private int getNamespaceType() {
            return this.m_NamespaceType;
        }

        private void addRenamedFetchID(Identifier identifier, int n) {
            if (null == this.m_RenamedFetchIDs) {
                this.m_RenamedFetchIDs = new Identifier[this.getFetchClassTypes().size()];
            }
            this.m_RenamedFetchIDs[n] = identifier;
        }

        private Identifier[] getRenamedFetchIDs() {
            return this.m_RenamedFetchIDs;
        }

        private Identifier getRenamedFetchID(int n) {
            if (null == this.m_RenamedFetchIDs) {
                return null;
            }
            return this.m_RenamedFetchIDs[n];
        }

        ArrayList<String> getFetchIDs() {
            if (null == this.m_FetchIDs) {
                this.generateFetchIDs();
            }
            if (null == this.m_FetchIDs) {
                return new ArrayList<String>();
            }
            return this.m_FetchIDs;
        }

        ArrayList<Class> getFetchIDClassTypes(int n) {
            Class clazz = this.m_FetchIDClassTypes.get(n);
            if (null == clazz) {
                return this.getFetchClassTypes();
            }
            ArrayList<Class> arrayList = new ArrayList<Class>();
            arrayList.add(clazz);
            return arrayList;
        }

        private void addFetchID(Identifier identifier, Class clazz) {
            this.addFetchID(null, identifier, clazz);
        }

        private void addFetchID(String string, Identifier identifier, Class clazz) {
            if (null == this.m_FetchIDs) {
                this.m_FetchIDs = new ArrayList();
                this.m_FetchIDClassTypes = new ArrayList();
            }
            if (null != string) {
                identifier.setNamespace(string);
            }
            this.m_FetchIDs.add(identifier.toString());
            if (null != string) {
                identifier.setNamespace(null);
            }
            this.m_FetchIDClassTypes.add(clazz);
        }

        private void generateFetchIDs() {
            int n;
            if (this.getFetchClassTypes().size() == 0) {
                return;
            }
            if (0 == this.getNamespaceType()) {
                this.addFetchID(this.m_FetchID, null);
                return;
            }
            String[] stringArray = null;
            if (1 == this.getNamespaceType()) {
                stringArray = new String[]{"AWXML_DIMENSION", "CWM_DIMENSION"};
            } else if (2 == this.getNamespaceType()) {
                stringArray = new String[]{"AWXML_CUBE", "CWM_CUBE"};
            }
            this.generateRenameFetchIDs();
            if (null != this.getRenamedFetchIDs()) {
                for (n = 0; n < this.getRenamedFetchIDs().length; ++n) {
                    if (null == this.getRenamedFetchID(n)) continue;
                    this.addFetchID(this.getRenamedFetchID(n), this.getFetchClassType(n));
                }
            }
            this.addFetchID(this.m_FetchID, null);
            for (n = 0; n < stringArray.length; ++n) {
                String string = stringArray[n];
                if (null != this.getRenamedFetchIDs() && ("AWXML_DIMENSION" == string || "AWXML_CUBE" == string)) {
                    for (int i = 0; i < this.getRenamedFetchIDs().length; ++i) {
                        Identifier identifier = this.getRenamedFetchID(i);
                        Class clazz = this.getFetchClassType(i);
                        if (null == identifier) {
                            identifier = this.m_FetchID;
                        }
                        this.addFetchID(string, identifier, clazz);
                    }
                    continue;
                }
                this.addFetchID(string, this.m_FetchID, null);
            }
        }

        private void generateRenameFetchIDs() {
            String string = this.m_FetchID.getOwner();
            MdmMetadataProvider mdmMetadataProvider = this.getIDConverter().getMdmMetadataProvider();
            CubeUpgradeInfoSelector cubeUpgradeInfoSelector = CubeUpgradeInfoSelector.getInstance(mdmMetadataProvider);
            MdmAWXMLNamingConvention mdmAWXMLNamingConvention = new MdmAWXMLNamingConvention(string, mdmMetadataProvider);
            for (int i = 0; i < this.getFetchClassTypes().size(); ++i) {
                Identifier identifier = new Identifier(this.m_FetchID);
                Identifier identifier2 = this.m_FetchID;
                Class clazz = this.getFetchClassTypes().get(i);
                boolean bl = false;
                int n = identifier.getNumComponents() - 1;
                while (identifier2.getNumComponents() > 1) {
                    String string2;
                    Identifier identifier3 = this.getAwxmlID(identifier2, clazz, mdmAWXMLNamingConvention);
                    if (null != identifier3 && null != (string2 = cubeUpgradeInfoSelector.getNewName(string, identifier3))) {
                        identifier.setComponent(n, string2);
                        bl = true;
                    }
                    identifier2 = identifier2.getParentID();
                    clazz = this.getParentClassType(clazz);
                    --n;
                }
                if (!bl) continue;
                this.addRenamedFetchID(identifier, i);
            }
        }

        private Identifier getAwxmlID(Identifier identifier, Class clazz, MdmAWXMLNamingConvention mdmAWXMLNamingConvention) {
            int n = 0;
            boolean bl = true;
            String string = null;
            if (MdmHierarchyLevel.class == clazz) {
                String string2 = identifier.getComponent(1);
                String string3 = identifier.getComponent(3);
                string = mdmAWXMLNamingConvention.generateLevelID(string2, string3);
                n = 4;
            } else if (MdmHierarchy.class == clazz) {
                String string4 = identifier.getComponent(1);
                String string5 = identifier.getComponent(2);
                string = mdmAWXMLNamingConvention.generateHierarchyID(string4, string5);
                n = 3;
            } else if (MdmAttribute.class == clazz) {
                String string6 = identifier.getComponent(1);
                String string7 = identifier.getComponent(2);
                string = mdmAWXMLNamingConvention.generateAttributeID(string6, string7);
                n = 3;
            } else if (MdmPrimaryDimension.class == clazz) {
                String string8 = identifier.getComponent(1);
                string = mdmAWXMLNamingConvention.generatePrimaryDimensionID(string8);
                n = 2;
            } else if (MdmMeasure.class == clazz) {
                String string9 = identifier.getComponent(1);
                String string10 = identifier.getComponent(2);
                string = mdmAWXMLNamingConvention.generateMeasureID(string9, string10);
                n = 3;
                bl = false;
            } else if (MdmCube.class == clazz) {
                String string11 = identifier.getComponent(1);
                string = mdmAWXMLNamingConvention.generateCubeID(string11);
                n = 2;
                bl = false;
            } else {
                return null;
            }
            if (bl && identifier.getComponent(1).equals("MEASURE_DIMENSION")) {
                return null;
            }
            if (n != identifier.getNumComponents()) {
                return null;
            }
            return Identifier.parseID(string);
        }

        private Class getParentClassType(Class clazz) {
            if (MdmHierarchyLevel.class == clazz) {
                return MdmHierarchy.class;
            }
            if (MdmHierarchy.class == clazz || MdmAttribute.class == clazz) {
                return MdmPrimaryDimension.class;
            }
            if (MdmMeasure.class == clazz) {
                return MdmCube.class;
            }
            return null;
        }
    }
}

