/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLParserCallback;
import oracle.olapi.metadata.XMLReaderPropertyAction;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.conversion.MetadataLegacyXMLParserCallback;
import oracle.olapi.metadata.conversion.MetadataLegacyXMLReader;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SyntaxObject;

abstract class LegacyXMLObject
extends BaseMetadataObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.ID};
    static final int DEFAULT_CONVERT_ORDER_NUM = 10;
    private BaseMetadataObject m_ConvertToObject = null;
    private Integer m_BaseConvertOrderNum = null;
    private Integer m_ConvertOrderNum = null;
    private Boolean m_IsValid = null;

    protected LegacyXMLObject(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
        this.setInitialPersistenceType((short)1);
    }

    final String getIdStr() {
        return this.getPropertyStringValue(LegacyXMLTags.ID);
    }

    final MdmMetadataProvider getMdmMetadataProvider() {
        return (MdmMetadataProvider)this.getBaseMetadataProvider();
    }

    public static final XMLTag classGetContainedByPropertyTag() {
        return LegacyXMLTags.CONTAINER_OBJECT;
    }

    protected final boolean initializeContainedByProperty(Object object, XMLReaderPropertyAction xMLReaderPropertyAction) {
        return super.initializeContainedByProperty(object, xMLReaderPropertyAction);
    }

    final void setConvertToObject(BaseMetadataObject baseMetadataObject) {
        this.m_ConvertToObject = baseMetadataObject;
    }

    final BaseMetadataObject getConvertToObject() {
        return this.m_ConvertToObject;
    }

    final int getConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        return this.getConvertOrderNumber(legacyXMLConverter, true);
    }

    final int getConvertOrderNumber(LegacyXMLConverter legacyXMLConverter, boolean bl) {
        int n;
        if (null != this.m_ConvertOrderNum) {
            return this.m_ConvertOrderNum;
        }
        if (null == this.m_BaseConvertOrderNum) {
            n = this.getBaseConvertOrderNumber(legacyXMLConverter);
            this.m_BaseConvertOrderNum = new Integer(n);
        }
        n = this.m_BaseConvertOrderNum;
        LegacyXMLObject legacyXMLObject = (LegacyXMLObject)this.getContainedByObject();
        if (bl && null != legacyXMLObject) {
            int n2 = legacyXMLObject.getConvertOrderNumber(legacyXMLConverter);
            if (n2 > n) {
                n = n2;
            }
            this.m_ConvertOrderNum = new Integer(n);
        }
        return n;
    }

    final boolean validate(LegacyXMLConverter legacyXMLConverter) {
        return this.validate(legacyXMLConverter, true);
    }

    final boolean validate(LegacyXMLConverter legacyXMLConverter, boolean bl) {
        LegacyXMLObject legacyXMLObject = (LegacyXMLObject)this.getContainedByObject();
        if (bl && null != legacyXMLObject && !legacyXMLObject.isValid()) {
            this.setIsValid(false);
            return false;
        }
        if (null != this.internalIsValid()) {
            return this.isValid();
        }
        this.setIsValid(false);
        this.setIsValid(this.validateState(legacyXMLConverter));
        return this.isValid();
    }

    public final boolean isValid() {
        Boolean bl = this.internalIsValid();
        if (null == bl) {
            return false;
        }
        return bl;
    }

    final Expression toSyntaxExpression(String string, String string2) {
        return this.toSyntaxExpression(string, string2, new MetadataLegacyXMLParserCallback());
    }

    final Expression toSyntaxExpression(String string, String string2, MetadataLegacyXMLParserCallback metadataLegacyXMLParserCallback) {
        SyntaxObject syntaxObject = SyntaxObject.fromSyntax(string, this.getMdmMetadataProvider(), string2, false, null, (XMLParserCallback)metadataLegacyXMLParserCallback);
        return (Expression)syntaxObject;
    }

    final Query toSyntaxQuery(String string, String string2) {
        SyntaxObject syntaxObject = SyntaxObject.fromSyntax(string, this.getMdmMetadataProvider(), string2, true, null, (XMLParserCallback)new MetadataLegacyXMLParserCallback());
        return (Query)syntaxObject;
    }

    final void finishObjectCreation(MetadataLegacyXMLReader metadataLegacyXMLReader) {
        String string = this.getIdStr();
        if (null == string || string.length() == 0) {
            metadataLegacyXMLReader.reportError("InvalidXMLObjectID");
        }
        this.setInternalID(string);
    }

    public final String getID() {
        return this.getIdStr();
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        return this.findXMLTag(string, string2, LOCAL_TAGS);
    }

    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        return true;
    }

    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
    }

    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        return 10;
    }

    private void setIsValid(boolean bl) {
        this.m_IsValid = new Boolean(bl);
    }

    private Boolean internalIsValid() {
        return this.m_IsValid;
    }
}

