/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAWObject;
import oracle.olapi.metadata.conversion.LegacyXMLBaseObject;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLCube;
import oracle.olapi.metadata.conversion.LegacyXMLDimension;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDimensionality;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

final class LegacyXMLCubeDimRef
extends LegacyXMLBaseObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.SPARSE, LegacyXMLTags.DIMENSION_REF};

    protected LegacyXMLCubeDimRef(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    boolean getSparse() {
        return this.getPropertyBooleanValue(LegacyXMLTags.SPARSE);
    }

    LegacyXMLDimension getDimension() {
        return (LegacyXMLDimension)this.getPropertyObjectValue(LegacyXMLTags.DIMENSION_REF);
    }

    LegacyXMLAWObject getAWObject() {
        return (LegacyXMLAWObject)this.getContainedByObject();
    }

    LegacyXMLCube getCube() {
        return (LegacyXMLCube)this.getAWObject();
    }

    MdmDimensionality getMdmDimensionality() {
        return (MdmDimensionality)this.getConvertToObject();
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    protected XMLTag getXMLTag() {
        return LegacyXMLTags.CUBE_DIM_REF_TAG;
    }

    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        legacyXMLConverter.validateRequiredProperty(LegacyXMLTags.DIMENSION_REF, this.getDimension(), this);
        return this.getDimension().isValid();
    }

    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        MdmCube mdmCube = this.getCube().getMdmCube();
        MdmPrimaryDimension mdmPrimaryDimension = this.getDimension().getMdmPrimaryDimension();
        MdmDimensionality mdmDimensionality = mdmCube.addDimension(mdmPrimaryDimension);
        if (this.getSparse()) {
            mdmCube.getOrganization().addSparseDimension(mdmDimensionality);
        }
        this.setMdmDimensionality(mdmDimensionality);
        super.convertToMdm(legacyXMLConverter);
    }

    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        if (null == this.getDimension()) {
            return super.getBaseConvertOrderNumber(legacyXMLConverter);
        }
        return this.getDimension().getConvertOrderNumber(legacyXMLConverter) + 1;
    }

    private void setMdmDimensionality(MdmDimensionality mdmDimensionality) {
        this.setConvertToObject(mdmDimensionality);
    }
}

