/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLObject;
import oracle.olapi.metadata.conversion.MetadataLegacyXMLReader;
import oracle.olapi.metadata.conversion.XMLUpgradeException;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.SQLDataType;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LegacyXMLConverter
implements Comparator {
    MetadataLegacyXMLReader m_Reader = null;
    private static String LEGACY_XML_DEFAULT_VALUE = "AW$DEFAULT";

    public LegacyXMLConverter(BaseMetadataProvider baseMetadataProvider, MdmDatabaseSchema mdmDatabaseSchema) {
        this.m_Reader = new MetadataLegacyXMLReader(baseMetadataProvider);
        this.m_Reader.setContextSchema(mdmDatabaseSchema);
    }

    public void importXML(Reader reader) throws IOException, SAXException {
        throw new XMLUpgradeException("UpgradeNotSupportedException");
    }

    public List<Exception> getWarnings() {
        if (this.getMetadataReader().hasWarnings()) {
            return this.getMetadataReader().getRootException().getWarnings();
        }
        return null;
    }

    public MdmDatabaseSchema getDefaultSchema() {
        return this.getMetadataReader().getContextSchema();
    }

    public List<BaseMetadataObject> getConvertedObjects() {
        ArrayList<BaseMetadataObject> arrayList = new ArrayList<BaseMetadataObject>();
        List list = this.getMetadataReader().getParsedObjects();
        for (LegacyXMLObject legacyXMLObject : list) {
            BaseMetadataObject baseMetadataObject;
            if (!legacyXMLObject.isValid() || null == (baseMetadataObject = legacyXMLObject.getConvertToObject()) || !baseMetadataObject.isTopLevelObject() || arrayList.contains(baseMetadataObject)) continue;
            arrayList.add(baseMetadataObject);
        }
        return arrayList;
    }

    static SQLDataType getSQLDataType(String string) {
        DataType dataType = null;
        String string2 = null;
        if ("BOOLEAN" == string) {
            string2 = "VARCHAR2(5)";
        }
        if ("DATE" == string) {
            dataType = DataType.DATE;
        } else if ("DATETIME" == string) {
            dataType = DataType.DATE;
        } else if ("DECIMAL" == string) {
            dataType = DataType.DECIMAL;
        } else if ("ID" == string) {
            string2 = "VARCHAR2(8)";
        } else if ("INTEGER" == string) {
            dataType = DataType.INTEGER;
        } else if ("LONGINTEGER" == string) {
            dataType = DataType.INTEGER;
        } else if ("NTEXT" == string) {
            dataType = DataType.NVARCHAR2;
        } else if ("NUMBER" == string) {
            dataType = DataType.NUMBER;
        } else if ("TEXT" == string) {
            dataType = DataType.VARCHAR2;
        } else if ("SHORTDECIMAL" == string) {
            dataType = DataType.DECIMAL;
        } else if ("SHORTINTEGER" == string) {
            dataType = DataType.INTEGER;
        } else {
            return null;
        }
        if (null == dataType) {
            return new SQLDataType(string2);
        }
        return dataType.toSQLDataType();
    }

    public int compare(Object object, Object object2) {
        int n;
        if (!(object instanceof LegacyXMLObject) || !(object2 instanceof LegacyXMLObject)) {
            return 0;
        }
        int n2 = ((LegacyXMLObject)object).getConvertOrderNumber(this);
        if (n2 == (n = ((LegacyXMLObject)object2).getConvertOrderNumber(this))) {
            return 0;
        }
        if (n2 < n) {
            return -1;
        }
        return 1;
    }

    void reportError(String string, String string2) {
        this.reportError(string, new String[]{string2});
    }

    void reportError(String string, String[] stringArray) {
        XMLUpgradeException xMLUpgradeException = new XMLUpgradeException(string, stringArray);
        this.reportException(xMLUpgradeException, false);
        throw this.getMetadataReader().getRootException();
    }

    void reportWarning(String string, String string2) {
        this.reportWarning(string, new String[]{string2});
    }

    void reportWarning(String string, String[] stringArray) {
        XMLUpgradeException xMLUpgradeException = new XMLUpgradeException(string, stringArray);
        this.reportException(xMLUpgradeException, true);
    }

    void validateRequiredProperty(XMLTag xMLTag, Object object, LegacyXMLObject legacyXMLObject) {
        this.getMetadataReader().validateRequiredProperty(xMLTag, object, legacyXMLObject);
    }

    void reportIgnoredProperty(XMLTag xMLTag, Object object, LegacyXMLObject legacyXMLObject) {
        this.reportIgnoredProperty(xMLTag, object, legacyXMLObject, true);
    }

    void reportIgnoredProperty(XMLTag xMLTag, Object object, LegacyXMLObject legacyXMLObject, boolean bl) {
        this.getMetadataReader().reportIgnoredProperty("UnsupportedPropConversion", xMLTag, object, legacyXMLObject, bl);
    }

    String getLegacyXMLDefaultValue() {
        return LEGACY_XML_DEFAULT_VALUE;
    }

    MetadataLegacyXMLReader getMetadataReader() {
        return this.m_Reader;
    }

    private void convertLegacyObjects() {
        block7: {
            List list = this.getMetadataReader().getParsedObjects();
            Collections.sort(list, this);
            for (LegacyXMLObject legacyXMLObject : list) {
                try {
                    legacyXMLObject.validate(this);
                }
                catch (Exception exception) {
                    if (this.getMetadataReader().getRootException() == exception) continue;
                    this.reportException(exception, false);
                }
            }
            try {
                for (LegacyXMLObject legacyXMLObject : list) {
                    if (!legacyXMLObject.isValid()) continue;
                    legacyXMLObject.convertToMdm(this);
                }
            }
            catch (Exception exception) {
                if (this.getMetadataReader().getRootException() == exception) break block7;
                this.reportException(exception, false);
            }
        }
        if (this.getMetadataReader().hasErrors()) {
            throw this.getMetadataReader().getRootException();
        }
    }

    private void reportException(Exception exception, boolean bl) {
        this.getMetadataReader().getRootException(true).addException(exception, bl);
    }
}

