/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAggregationArgument;
import oracle.olapi.metadata.conversion.LegacyXMLAggregationOperator;
import oracle.olapi.metadata.conversion.LegacyXMLCalculationSpecification;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.syntax.AggregationCommand;
import oracle.olapi.syntax.ConsistentSolveCommand;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.FunctionDescriptor;
import oracle.olapi.syntax.FunctionDescriptorCatalog;

abstract class LegacyXMLAggregation
extends LegacyXMLCalculationSpecification {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.AGGREGATION_OPERATOR, LegacyXMLTags.AGGREGATION_ARGUMENT};

    protected LegacyXMLAggregation(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    LegacyXMLAggregationOperator getAggregationOperator() {
        return (LegacyXMLAggregationOperator)this.getPropertyObjectValue(LegacyXMLTags.AGGREGATION_OPERATOR);
    }

    LegacyXMLAggregationArgument getAggregationArgument() {
        return (LegacyXMLAggregationArgument)this.getPropertyObjectValue(LegacyXMLTags.AGGREGATION_ARGUMENT);
    }

    AggregationCommand createAggregationCommand(String string, FunctionArgument[] functionArgumentArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return new AggregationCommand(string, functionArgumentArray, null, null, null, bl, bl2, bl3, bl4);
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        if (null != this.getAggregationOperator() && !this.getAggregationOperator().validate(legacyXMLConverter, false)) {
            return false;
        }
        return null == this.getAggregationArgument() || this.getAggregationArgument().validate(legacyXMLConverter, false);
    }

    ConsistentSolveCommand createConsistentSolveCommand() {
        boolean bl;
        FunctionDescriptor functionDescriptor = FunctionDescriptorCatalog.AGGREGATION_SUM;
        if (null != this.getAggregationOperator() && null == (functionDescriptor = this.getAggregationOperator().getFunctionDescriptor())) {
            return null;
        }
        boolean bl2 = AggregationCommand.IGNORE_NULLS_DEFAULT;
        boolean bl3 = AggregationCommand.ALLOW_OVERFLOW_DEFAULT;
        boolean bl4 = AggregationCommand.ALLOW_DIVISION_BY_ZERO_DEFAULT;
        boolean bl5 = bl = functionDescriptor == FunctionDescriptorCatalog.AGGREGATION_AVG;
        if (null != this.getAggregationArgument()) {
            bl2 = this.getAggregationArgument().getIgnoreNullsValue();
            bl3 = this.getAggregationArgument().getAllowOverflowValue();
            bl4 = this.getAggregationArgument().getAllowDivisionByZeroValue();
        }
        return this.createAggregationCommand(functionDescriptor.getFunctionName(), null, bl2, bl3, bl4, bl);
    }
}

