/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataXMLReader;
import oracle.olapi.metadata.MetadataObjectClass;
import oracle.olapi.metadata.XML11_2_ParserCallback;
import oracle.olapi.metadata.XMLParserCallback;
import oracle.olapi.metadata.mapping.ObjectMap;
import oracle.olapi.syntax.parser.Identifier;

public final class MetadataXMLParserCallback
implements XMLParserCallback {
    private XMLParserCallback m_UserCallback = null;
    private int[] m_ValidActions = null;
    private int m_DefaultAction = 0;
    private BaseMetadataObject m_CurrObject = null;
    private String m_CurrAttribute = null;
    private boolean m_IsForServer = false;
    private BaseMetadataXMLReader m_XMLReader = null;

    public MetadataXMLParserCallback(BaseMetadataXMLReader baseMetadataXMLReader) {
        this.m_XMLReader = baseMetadataXMLReader;
        short s = this.getXMLReader().getPersistenceType();
        if (1 == s || 3 == s) {
            this.m_ValidActions = new int[]{2, 3};
            this.m_DefaultAction = this.m_ValidActions[0];
            this.m_IsForServer = true;
        } else {
            this.m_ValidActions = null;
            this.m_DefaultAction = 0;
        }
    }

    XMLParserCallback getUserCallback() {
        return this.m_UserCallback;
    }

    XML11_2_ParserCallback get11_2_UserCallback() {
        if (null != this.getUserCallback() && this.getUserCallback() instanceof XML11_2_ParserCallback) {
            return (XML11_2_ParserCallback)this.getUserCallback();
        }
        return null;
    }

    public void setUserCallback(XMLParserCallback xMLParserCallback) {
        this.m_UserCallback = xMLParserCallback;
    }

    void setCurrentObject(BaseMetadataObject baseMetadataObject) {
        this.m_CurrObject = baseMetadataObject;
    }

    void setCurrentAttribute(String string) {
        this.m_CurrAttribute = string;
    }

    public int processError(String string, String string2, String string3) {
        int n = this.getDefaultAction();
        if (null != this.getUserCallback()) {
            n = this.getUserCallback().processError(string, string2, string3);
            n = this.getValidAction(n);
        }
        return n;
    }

    public int processSyntaxIdentifiersError(String string, String string2, String string3, String[] stringArray) {
        int n = this.getDefaultAction();
        if (null != this.getUserCallback()) {
            n = this.getUserCallback().processSyntaxIdentifiersError(string, string2, string3, stringArray);
            n = this.getValidAction(n);
        }
        return n;
    }

    public int processSyntaxIdentifiersError(String string, String[] stringArray) {
        return this.processSyntaxIdentifiersError(this.getCurrentObjectID(), this.getCurrentAttribute(), string, stringArray);
    }

    boolean suppressXMLAttribute(String string, Class clazz, String string2, String string3) {
        if (!this.isForServer() && null != this.get11_2_UserCallback()) {
            return this.get11_2_UserCallback().suppressXMLAttribute(string, clazz, string2, string3);
        }
        return false;
    }

    String renameObject(Identifier identifier, Class clazz) {
        String string;
        String string2 = null;
        if (!this.isForServer() && null != this.get11_2_UserCallback() && (string = identifier.getName()).equals(string2 = this.get11_2_UserCallback().renameObject(identifier.toString(), string, clazz))) {
            string2 = null;
        }
        return string2;
    }

    public Identifier applyRenameForSyntaxID(Identifier identifier, Identifier identifier2, Class clazz) {
        if (!this.isForServer() && !(this.getCurrentObject() instanceof ObjectMap)) {
            MetadataObjectClass metadataObjectClass = MetadataObjectClass.getMetadataObjectClass(clazz);
            boolean bl = true;
            identifier = this.getXMLReader().applyRenameForID(identifier, identifier2, metadataObjectClass, bl);
        }
        return identifier;
    }

    private String getCurrentObjectID() {
        return this.getCurrentObject().getID();
    }

    private BaseMetadataObject getCurrentObject() {
        return this.m_CurrObject;
    }

    private String getCurrentAttribute() {
        return this.m_CurrAttribute;
    }

    private int[] getValidActions() {
        return this.m_ValidActions;
    }

    private int getDefaultAction() {
        return this.m_DefaultAction;
    }

    private int getValidAction(int n) {
        int n2 = n;
        if (null != this.getValidActions()) {
            boolean bl = false;
            for (int i = 0; i < this.getValidActions().length; ++i) {
                if (this.getValidActions()[i] != n2) continue;
                bl = true;
                break;
            }
            if (!bl) {
                n2 = this.getDefaultAction();
            }
        }
        if (0 == n2) {
            n2 = this.getDefaultAction();
        }
        return n2;
    }

    private boolean isForServer() {
        return this.m_IsForServer;
    }

    private BaseMetadataXMLReader getXMLReader() {
        return this.m_XMLReader;
    }
}

