/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import oracle.olapi.OLAPIRuntimeException;
import oracle.olapi.metadata.InvalidMetadataObjectInfo;
import oracle.olapi.metadata.MetadataObject;

public class InvalidMetadataException
extends OLAPIRuntimeException {
    private HashMap _idToErrorInfoList = new HashMap();
    private boolean _hasMoreErrors = false;

    public InvalidMetadataException() {
        super("MetadataErrorHeader");
    }

    public InvalidMetadataException(String string) {
        super("MetadataErrorHeader");
        this._idToErrorInfoList.put(string, new ArrayList());
    }

    public InvalidMetadataException(oracle.express.idl.ExpressModule.InvalidMetadataException invalidMetadataException) {
        super("MetadataErrorHeader");
        this._hasMoreErrors = invalidMetadataException.hasMoreErrors;
        for (int i = 0; i < invalidMetadataException.errorObjects.length; ++i) {
            String string = invalidMetadataException.errorMessages[i];
            String string2 = null;
            int n = -1;
            if (string.charAt(3) == '-' && string.charAt(9) == ':') {
                string2 = string.substring(0, 2);
                n = Integer.parseInt(string.substring(4, 8));
            }
            this.add(invalidMetadataException.errorObjects[i], string2, n, string, null);
        }
    }

    public void add(String string, String string2, int n, String string3, String string4) {
        if (!this._idToErrorInfoList.containsKey(string)) {
            this._idToErrorInfoList.put(string, new ArrayList());
        }
        List list = (List)this._idToErrorInfoList.get(string);
        InvalidMetadataObjectInfo invalidMetadataObjectInfo = new InvalidMetadataObjectInfo(string, string2, n, string3, string4);
        list.add(invalidMetadataObjectInfo);
    }

    public Set getInvalidObjectIds() {
        return this._idToErrorInfoList.keySet();
    }

    public List getErrorInfoList(String string) {
        ArrayList arrayList = (ArrayList)this._idToErrorInfoList.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public List getErrorInfoList(MetadataObject metadataObject) {
        return this.getErrorInfoList(metadataObject.getID());
    }

    public List getErrorMessages(String string) {
        List list = this.getErrorInfoList(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (InvalidMetadataObjectInfo invalidMetadataObjectInfo : list) {
            arrayList.add(invalidMetadataObjectInfo.getMessage());
        }
        return arrayList;
    }

    public List getErrorMessages(MetadataObject metadataObject) {
        return this.getErrorMessages(metadataObject.getID());
    }

    public boolean hasMoreErrors() {
        return this._hasMoreErrors;
    }

    public String getLocalizedMessage(Locale locale) {
        String string = super.getLocalizedMessage(locale);
        Object[] objectArray = this._idToErrorInfoList.keySet().toArray();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            List list = (List)this._idToErrorInfoList.get(string2);
            Iterator iterator = list.iterator();
            if (list.isEmpty()) {
                string = string + InvalidMetadataException.getMessage("MetadataError_2", new Object[]{string2, ""}, locale);
                continue;
            }
            while (iterator.hasNext()) {
                InvalidMetadataObjectInfo invalidMetadataObjectInfo = (InvalidMetadataObjectInfo)iterator.next();
                String string3 = invalidMetadataObjectInfo.getDDL() != null && invalidMetadataObjectInfo.getDDL().length() > 0 ? invalidMetadataObjectInfo.getDDL() + "\n" + invalidMetadataObjectInfo.getMessage() : invalidMetadataObjectInfo.getMessage();
                string = string + InvalidMetadataException.getMessage("MetadataError_2", new Object[]{string2, string3}, locale);
            }
        }
        if (this.hasMoreErrors()) {
            string = string + InvalidMetadataException.getMessage("MetadataHasMoreErrors", new Object[0], locale);
        }
        return string;
    }
}

