/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.internal.CopyException;
import oracle.olapi.internal.CopyPolicy;
import oracle.olapi.internal.ObjectHolder;
import oracle.olapi.metadata.BaseMetadataObjectState;
import oracle.olapi.metadata.BaseMetadataObjectStateProvider;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.DuplicateMetadataIDException;
import oracle.olapi.metadata.InvalidMetadataException;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataObjectClass;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.MetadataUpdateNotSupportedException;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.XMLReaderPropertyAction;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmRootSchema;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.syntax.parser.Identifier;
import oracle.olapi.transaction.BaseTransaction;
import oracle.olapi.transaction.Branch;
import oracle.olapi.transaction.MetadataContext;
import oracle.olapi.transaction.PersistentMetadataContext;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionalObject;
import oracle.olapi.transaction.TransactionalObjectInvalidException;
import oracle.olapi.transaction.WriteLockException;
import oracle.olapi.transaction.metadataStateManager.IncrementalMetadataState;
import oracle.olapi.transaction.metadataStateManager.MetadataStateManager;
import oracle.olapi.transaction.metadataStateManager.MetadataStateOwner;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMetadataObject
implements MetadataObject,
TransactionalObject,
MetadataStateOwner {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{BaseMetadataXMLTags.ID_NAME};
    private BaseMetadataObjectState m_PersistentState = null;
    private MetadataStateManager m_MetadataStateManager = null;
    private BaseMetadataProvider m_MetadataProvider = null;
    private String m_102ID = null;
    private String m_InternalID = null;
    private boolean m_Deleted = false;
    private MetadataObjectHolder m_Holder = null;
    private short m_PersistenceType = (short)-1;

    protected BaseMetadataObject(BaseMetadataProvider baseMetadataProvider) {
        this.setMetadataProvider(baseMetadataProvider);
    }

    protected BaseMetadataObject(BaseMetadataProvider baseMetadataProvider, String string, short s, BaseMetadataObject baseMetadataObject) {
        this(baseMetadataProvider, string, s, baseMetadataObject, null, null);
    }

    protected BaseMetadataObject(BaseMetadataProvider baseMetadataProvider, String string, short s, BaseMetadataObject baseMetadataObject, XMLTag[] xMLTagArray, String[] stringArray) {
        this(baseMetadataProvider);
        this.setInitialPersistenceType(s);
        this.setInternalID(string);
        if (baseMetadataObject != null) {
            XMLTag xMLTag = this.getContainedByPropertyTag();
            this.internalSetObjectProperty(xMLTag, baseMetadataObject.getHolder(), s);
            this.verifyIsolationState();
        }
        baseMetadataProvider.registerMetadataObject(string, this);
        if (null != xMLTagArray) {
            for (int i = 0; i < xMLTagArray.length; ++i) {
                xMLTagArray[i].initializeProperty(this, (Object)stringArray[i], s);
            }
        }
        this.finishObjectCreation();
    }

    protected void finishObjectCreation() {
    }

    final boolean addAllChildrenToXMLWriter(MetadataToXMLConverter metadataToXMLConverter, List list) {
        BaseMetadataObjectState baseMetadataObjectState = (BaseMetadataObjectState)this.getCurrentStateForRead(metadataToXMLConverter.getTransaction());
        return baseMetadataObjectState.addAllChildrenToXMLWriter(metadataToXMLConverter, list);
    }

    final boolean addContainedChildrenToXMLWriter(MetadataToXMLConverter metadataToXMLConverter, List list) {
        BaseMetadataObjectState baseMetadataObjectState = (BaseMetadataObjectState)this.getCurrentStateForRead(metadataToXMLConverter.getTransaction());
        return baseMetadataObjectState.addContainedChildrenToXMLWriter(metadataToXMLConverter, list);
    }

    protected final void addToListProperty(XMLTag xMLTag, Object object) {
        this.addToListProperty(xMLTag, object, -1);
    }

    protected final void addToListProperty(XMLTag xMLTag, Object object, int n) {
        Object object2 = object;
        if (object instanceof BaseMetadataObject) {
            if (((BaseMetadataObject)object).isDeleted()) {
                throw new TransactionalObjectInvalidException();
            }
            object2 = ((BaseMetadataObject)object).getHolder();
        }
        if (!this.getCurrentStateForRead().listPropertyContainsValue(xMLTag, object2)) {
            BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
            baseMetadataObjectState.addToListProperty(xMLTag, object2, n, this);
        }
    }

    protected final void removeFromListProperty(XMLTag xMLTag, Object object) {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        if (object instanceof BaseMetadataObject) {
            baseMetadataObjectState.removeFromListProperty(xMLTag, ((BaseMetadataObject)object).getHolder(), this);
        } else {
            baseMetadataObjectState.removeFromListProperty(xMLTag, object, this);
        }
    }

    protected final void clearListProperty(XMLTag xMLTag) {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        baseMetadataObjectState.clearListProperty(xMLTag, this);
    }

    public final void getDeletedChildren(Object object, Set set) {
        if (null == object) {
            return;
        }
        BaseMetadataObjectState baseMetadataObjectState = (BaseMetadataObjectState)object;
        baseMetadataObjectState.getDeletedChildren(set);
    }

    public final void getNestedSubObjects(List list, boolean bl) {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForRead();
        baseMetadataObjectState.getNestedSubObjects(list, bl);
    }

    public final void acquireLock(long l) throws WriteLockException {
        if (null == this.getMetadataStateManager()) {
            this.createMetadataStateManager();
        }
        this.getMetadataStateManager().acquireLock(this.getCurrentSystemTransaction(), l);
    }

    public final void releaseLock() throws WriteLockException {
        if (null == this.getMetadataStateManager()) {
            return;
        }
        this.getMetadataStateManager().releaseLock(this.getCurrentSystemTransaction());
    }

    public static String generateIDFromXML(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, String string, String string2, String string3, MetadataXMLReader metadataXMLReader) throws SAXException {
        return BaseMetadataObject.generateIDFromXML(baseMetadataObject, xMLTag, string, string2, string3, metadataXMLReader, null);
    }

    protected static String generateIDFromXML(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, String string, String string2, String string3, MetadataXMLReader metadataXMLReader, List<String> list) throws SAXException {
        String string4 = null;
        boolean bl = true;
        int n = xMLTag.getXMLType();
        bl = 5 == n ? false : (n == 4 ? true : null != baseMetadataObject);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!bl) {
            arrayList.add(string2);
        }
        if (null == string && null == list) {
            return null;
        }
        if (null != string) {
            arrayList.add(string);
        }
        if (null != list) {
            arrayList.addAll(list);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
            if (null != stringArray[i] && stringArray[i].length() != 0) continue;
            return null;
        }
        string4 = bl ? BaseMetadataObject.generateID(baseMetadataObject, stringArray) : BaseMetadataObject.generateNamespaceID(string3, stringArray);
        return string4;
    }

    protected void appendXMLString(MetadataToXMLConverter metadataToXMLConverter, XMLTag xMLTag) {
        if (xMLTag == null) {
            xMLTag = this.getXMLTag();
        }
        metadataToXMLConverter.beginElement(xMLTag);
        if (metadataToXMLConverter.getXMLFormat().is10gMode()) {
            metadataToXMLConverter.appendAttribute(BaseMetadataXMLTags.ID_NAME, this.getID(), this);
        }
        this.appendAdditionalXMLAttributes(metadataToXMLConverter);
        BaseMetadataObjectState baseMetadataObjectState = null;
        baseMetadataObjectState = metadataToXMLConverter.getXMLFormat().is11gPartialXMLMode() ? metadataToXMLConverter.getIncrementalSendState(this) : this.getCurrentStateForRead();
        baseMetadataObjectState.appendXMLString(metadataToXMLConverter, this);
        this.appendAdditionalXMLSubobjects(metadataToXMLConverter);
        metadataToXMLConverter.endElement(xMLTag);
    }

    public final void appendObjectRefXMLString(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, MetadataToXMLConverter metadataToXMLConverter) {
        if (null == xMLTag) {
            xMLTag = this.getXMLTag();
        }
        if (!metadataToXMLConverter.isInAttributes()) {
            metadataToXMLConverter.beginElement(xMLTag);
        }
        if (metadataToXMLConverter.getXMLFormat().is10gMode()) {
            metadataToXMLConverter.appendAttribute(BaseMetadataXMLTags.REF_ID, this.getID(), this);
        } else {
            this.appendObjectRefXMLAttributes(baseMetadataObject, xMLTag, metadataToXMLConverter);
        }
        if (!metadataToXMLConverter.isInAttributes()) {
            metadataToXMLConverter.endElement();
        }
    }

    protected final void appendObjectRefXMLAttributes(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, MetadataToXMLConverter metadataToXMLConverter) {
        XMLTag xMLTag2 = null;
        xMLTag2 = null != xMLTag && metadataToXMLConverter.isInAttributes() ? xMLTag : (xMLTag.isXMLContainedObject() && null != this.getObjRefIDAttribute() ? this.getObjRefIDAttribute() : BaseMetadataXMLTags.NAME);
        this.appendIDAttrsForXMLObjectRef(baseMetadataObject, xMLTag2, metadataToXMLConverter);
        BaseMetadataObject baseMetadataObject2 = this.getTopLevelObject();
        if (!(metadataToXMLConverter.isInAttributes() || null != baseMetadataObject && baseMetadataObject.getTopLevelObject() == baseMetadataObject2)) {
            String string;
            MdmSchema mdmSchema = baseMetadataObject2.getOwner();
            if (mdmSchema != this && (null == baseMetadataObject || baseMetadataObject.getOwner() != mdmSchema)) {
                metadataToXMLConverter.appendIDAttribute(BaseMetadataXMLTags.OWNER, mdmSchema.getName(), (BaseMetadataObject)mdmSchema);
            }
            if (null != (string = baseMetadataObject2.getPropertyStringValue(BaseMetadataXMLTags.NAMESPACE)) && string.length() > 0 && metadataToXMLConverter.supportsNamespaces()) {
                metadataToXMLConverter.appendAttribute(BaseMetadataXMLTags.NAMESPACE, string, this);
            }
        }
    }

    protected void appendIDAttrsForXMLObjectRef(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, MetadataToXMLConverter metadataToXMLConverter) {
        if (null == baseMetadataObject || baseMetadataObject.getTopLevelObject() == this.getTopLevelObject()) {
            this.appendNameForXMLObjectRef(baseMetadataObject, xMLTag, metadataToXMLConverter);
        } else {
            String string;
            Object object;
            LinkedList<String> linkedList = new LinkedList<String>();
            for (object = this; object != null; object = object.getContainedByObject()) {
                string = metadataToXMLConverter.getIDValue(object.getName(), (BaseMetadataObject)object);
                if (null == string || string.length() == 0) {
                    return;
                }
                linkedList.addFirst(string);
                if (object.isTopLevelObject()) break;
            }
            object = new String[linkedList.size()];
            linkedList.toArray((T[])object);
            string = BaseMetadataObject.generateID(object);
            metadataToXMLConverter.appendAttribute(xMLTag, string, baseMetadataObject, false);
        }
    }

    protected final void appendNameForXMLObjectRef(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, MetadataToXMLConverter metadataToXMLConverter) {
        if (!(null == this.getName() || this.getName().length() <= 0 || this.hasPrivateName() && BaseMetadataXMLTags.NAME == xMLTag)) {
            metadataToXMLConverter.appendIDAttribute(xMLTag, this.getName(), this);
        }
    }

    protected void appendAdditionalXMLSubobjects(MetadataToXMLConverter metadataToXMLConverter) {
    }

    protected void appendAdditionalXMLAttributes(MetadataToXMLConverter metadataToXMLConverter) {
    }

    final void internalSetStringProperty(XMLTag xMLTag, String string, int n) {
        this.internalSetStringProperty(xMLTag, string, n, false);
    }

    final void internalSetStringProperty(XMLTag xMLTag, String string, int n, boolean bl) {
        ObjectHolder objectHolder = new ObjectHolder(string);
        if (this.verifySetProperty(xMLTag, objectHolder)) {
            BaseMetadataObjectState baseMetadataObjectState = this.getTransientOrPersistentStateForWrite(n);
            baseMetadataObjectState.setPropertyStringValue(xMLTag, (String)objectHolder.getObject(), this.getBaseMetadataProvider(), this, bl);
        }
    }

    protected boolean verifySetProperty(XMLTag xMLTag, ObjectHolder objectHolder) {
        return true;
    }

    final void internalMapProperty(XMLTag xMLTag, Object object, Object object2, short s) {
        MetadataObjectHolder metadataObjectHolder = (MetadataObjectHolder)object;
        BaseTransaction baseTransaction = (BaseTransaction)this.getCurrentSystemTransaction();
        BaseMetadataObjectState baseMetadataObjectState = this.getTransientOrPersistentStateForWrite(s);
        baseMetadataObjectState.mapObject(xMLTag, metadataObjectHolder, object2, this);
    }

    final void internalAddToListProperty(XMLTag xMLTag, Object object, int n, short s) {
        BaseMetadataObjectState baseMetadataObjectState = this.getTransientOrPersistentStateForRead(s);
        if (!baseMetadataObjectState.listPropertyContainsValue(xMLTag, object)) {
            BaseMetadataObjectState baseMetadataObjectState2 = this.getTransientOrPersistentStateForWrite(s);
            baseMetadataObjectState2.addToListProperty(xMLTag, object, n, this);
        }
    }

    final void internalRemoveFromListProperty(XMLTag xMLTag, Object object, short s) {
        BaseMetadataObjectState baseMetadataObjectState = this.getTransientOrPersistentStateForWrite(s);
        baseMetadataObjectState.removeFromListProperty(xMLTag, object, this);
    }

    final void internalClearListProperty(XMLTag xMLTag, short s) {
        BaseMetadataObjectState baseMetadataObjectState = this.getTransientOrPersistentStateForWrite(s);
        baseMetadataObjectState.clearListProperty(xMLTag, this);
    }

    final void internalSetObjectProperty(XMLTag xMLTag, Object object, short s) {
        this.internalSetObjectProperty(xMLTag, object, s, false);
    }

    final void internalSetObjectProperty(XMLTag xMLTag, Object object, short s, boolean bl) {
        ObjectHolder objectHolder = new ObjectHolder(object);
        if (this.verifySetProperty(xMLTag, objectHolder)) {
            BaseMetadataObjectState baseMetadataObjectState = this.getTransientOrPersistentStateForWrite(s);
            baseMetadataObjectState.setPropertyObjectValue(xMLTag, objectHolder.getObject(), this.getBaseMetadataProvider(), this, bl);
        }
    }

    private final Transaction getIncrementalTransaction() {
        return this.getBaseMetadataProvider().getDataProvider().getBaseTransactionProvider().getIncrementalTransaction();
    }

    private final Transaction getCurrentSystemTransaction() {
        return this.getBaseMetadataProvider().getDataProvider().getBaseTransactionProvider().getCurrentSystemTransaction();
    }

    private final void createMetadataStateManager() {
        BaseMetadataObjectStateProvider baseMetadataObjectStateProvider = BaseMetadataObjectStateProvider.INSTANCE;
        BaseMetadataObjectState baseMetadataObjectState = this.getPersistentState();
        if (null != baseMetadataObjectState) {
            this.setMetadataStateManager(new MetadataStateManager(baseMetadataObjectStateProvider, baseMetadataObjectState, null, this));
            return;
        }
        IncrementalMetadataState incrementalMetadataState = baseMetadataObjectStateProvider.getInitialState(null);
        this.setMetadataStateManager(new MetadataStateManager(baseMetadataObjectStateProvider, incrementalMetadataState, this.getCurrentSystemTransaction(), this));
    }

    public final BaseMetadataProvider getBaseMetadataProvider() {
        return this.m_MetadataProvider;
    }

    final BaseMetadataObjectState getIncrementalChangesSinceState(MetadataContext metadataContext, MetadataContext metadataContext2) {
        IncrementalMetadataState incrementalMetadataState;
        this.checkRefetchPersistentState();
        if (null != this.getPersistentState() && null == this.getMetadataStateManager()) {
            return this.getPersistentState();
        }
        if (null == this.getMetadataStateManager()) {
            this.createMetadataStateManager();
        }
        if (null == (incrementalMetadataState = this.getMetadataStateManager().getIncrementalStateSince(metadataContext, metadataContext2))) {
            incrementalMetadataState = this.getPersistentState();
        }
        if (null == incrementalMetadataState) {
            throw new TransactionalObjectInvalidException();
        }
        return (BaseMetadataObjectState)incrementalMetadataState;
    }

    final Object getCurrentStateForRead(Transaction transaction) {
        return this.getCurrentStateForRead(transaction, true);
    }

    private final Object getCurrentStateForRead(Transaction transaction, boolean bl) {
        IncrementalMetadataState incrementalMetadataState;
        this.checkRefetchPersistentState();
        if (null != this.getPersistentState() && null == this.getMetadataStateManager()) {
            return this.getPersistentState();
        }
        if (null == this.getMetadataStateManager()) {
            this.createMetadataStateManager();
        }
        if (null == (incrementalMetadataState = this.getMetadataStateManager().getIncrementalStateForRead(transaction))) {
            incrementalMetadataState = this.getPersistentState();
        }
        if (null == incrementalMetadataState && bl) {
            throw new TransactionalObjectInvalidException();
        }
        return incrementalMetadataState;
    }

    private final BaseMetadataObjectState getCurrentStateForRead() {
        Transaction transaction = this.getCurrentSystemTransaction();
        return (BaseMetadataObjectState)this.getCurrentStateForRead(transaction, true);
    }

    private final BaseMetadataObjectState getCurrentStateForWrite() {
        return this.getStateForWrite(this.getIncrementalTransaction(), false);
    }

    private final void verifyIsolationState() {
        BaseMetadataObject baseMetadataObject = this.getContainedByObject();
        if (null == baseMetadataObject) {
            return;
        }
        Branch branch = this.getBaseMetadataProvider().getDataProvider().getCurrentSession().getBranch();
        if (null == branch || !branch.containsObject(this.getContainedByObject())) {
            return;
        }
        this.createIsolationState(branch);
    }

    public final void createIsolationState(MetadataContext metadataContext) {
        this.getStateForWrite(metadataContext, true);
    }

    private final BaseMetadataObjectState getStateForWrite(MetadataContext metadataContext, boolean bl) {
        if (!this.getBaseMetadataProvider().supportsMetadataUpdate()) {
            throw new MetadataUpdateNotSupportedException("UpdateNotSupported");
        }
        this.checkRefetchPersistentState();
        if (null == this.getMetadataStateManager()) {
            this.createMetadataStateManager();
        }
        if (this.isDeleted()) {
            throw new TransactionalObjectInvalidException();
        }
        BaseMetadataObjectState baseMetadataObjectState = (BaseMetadataObjectState)this.getMetadataStateManager().findOrCreateIncrementalStateForWrite(metadataContext, bl);
        if (null == baseMetadataObjectState) {
            throw new TransactionalObjectInvalidException();
        }
        return baseMetadataObjectState;
    }

    final MetadataObjectHolder getHolder() {
        return this.m_Holder;
    }

    @Override
    public String getID() {
        return this.getInternalID();
    }

    public final String getInternalID() {
        return this.m_InternalID;
    }

    public String getName() throws MetadataNotFoundException {
        return "";
    }

    public String getNewName() {
        return null;
    }

    private final MetadataStateManager getMetadataStateManager() {
        return this.m_MetadataStateManager;
    }

    public void updatePersistentState(short s) {
        if (this.isDeleted()) {
            return;
        }
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForRead();
        baseMetadataObjectState.updatePersistentState(s);
        this.changePersistenceType(s, true);
    }

    @Override
    public Transaction getActiveTransaction() {
        if (null == this.getMetadataStateManager()) {
            return null;
        }
        Transaction transaction = this.getCurrentSystemTransaction();
        return this.getMetadataStateManager().getActiveTransaction(transaction);
    }

    public Transaction getActiveTransaction(Transaction transaction) {
        if (null == this.getMetadataStateManager()) {
            return null;
        }
        return this.getMetadataStateManager().getActiveTransaction(transaction);
    }

    final BaseMetadataObjectState getPersistentState() {
        return this.m_PersistentState;
    }

    private final BaseMetadataObjectState getPersistentStateForWrite() {
        if (null == this.getMetadataStateManager()) {
            return this.getPersistentState();
        }
        return (BaseMetadataObjectState)this.getMetadataStateManager().findOrCreateIncrementalStateForWrite(PersistentMetadataContext.INSTANCE);
    }

    protected final synchronized boolean hasProperty(XMLTag xMLTag) {
        return this.getCurrentStateForRead().hasProperty(xMLTag);
    }

    public final synchronized boolean hasState() {
        Transaction transaction = this.getCurrentSystemTransaction();
        return this.getCurrentStateForRead(transaction, false) != null;
    }

    protected final synchronized List getPropertyListValues(XMLTag xMLTag) {
        return this.getCurrentStateForRead().getPropertyListValues(xMLTag, this.getBaseMetadataProvider());
    }

    protected final synchronized Object getPropertyObjectValue(XMLTag xMLTag) {
        return this.getCurrentStateForRead().getPropertyObjectValue(xMLTag, this.getBaseMetadataProvider());
    }

    protected final synchronized Object getPropertyObjectValue(XMLTag xMLTag, short s) {
        if (s == 0 || s == 3) {
            return this.getCurrentStateForRead().getPropertyObjectValue(xMLTag, this.getBaseMetadataProvider());
        }
        return this.getPersistentState().getPropertyObjectValue(xMLTag, this.getBaseMetadataProvider());
    }

    private final synchronized MetadataObjectHolder getPropertyObjectHolder(XMLTag xMLTag, short s) {
        if (s == 0 || s == 3) {
            return this.getCurrentStateForRead().getPropertyObjectHolder(xMLTag);
        }
        return this.getPersistentState().getPropertyObjectHolder(xMLTag);
    }

    protected final synchronized String getPropertyStringValue(XMLTag xMLTag) {
        return this.getCurrentStateForRead().getPropertyStringValue(xMLTag);
    }

    protected final synchronized String getPropertyStringValue(XMLTag xMLTag, short s) {
        if (s == 0 || s == 3) {
            return this.getCurrentStateForRead().getPropertyStringValue(xMLTag);
        }
        return this.getPersistentState().getPropertyStringValue(xMLTag);
    }

    protected final synchronized int getPropertyIntegerValue(XMLTag xMLTag, int n) {
        return this.getCurrentStateForRead().getPropertyIntegerValue(xMLTag, n);
    }

    protected final synchronized boolean getPropertyBooleanValue(XMLTag xMLTag) {
        String string = this.getPropertyStringValue(xMLTag);
        return "True".equals(string);
    }

    protected abstract XMLTag getXMLTag();

    protected boolean initializeContainedByProperty(Object object, XMLReaderPropertyAction xMLReaderPropertyAction) {
        XMLTag xMLTag = this.getContainedByPropertyTag();
        xMLTag.initializeProperty(this, object, xMLReaderPropertyAction);
        this.verifyIsolationState();
        return true;
    }

    public final XMLTag getContainedByPropertyTag() {
        return this.getMetadataObjectClass().getContainedByPropertyTag();
    }

    public static XMLTag classGetContainedByPropertyTag() {
        return BaseMetadataXMLTags.CONTAINER_OBJECT;
    }

    protected XMLTag getPropertyXMLTag(String string, String string2) {
        return this.findXMLTag(string, string2, LOCAL_TAGS);
    }

    protected final XMLTag findXMLTag(String string, String string2, XMLTag[] xMLTagArray) {
        for (int i = 0; i < xMLTagArray.length; ++i) {
            if (!xMLTagArray[i].matches(string, string2)) continue;
            return xMLTagArray[i];
        }
        return null;
    }

    public final BaseMetadataObject getContainedByObject() {
        return (BaseMetadataObject)this.getPropertyObjectValue(this.getContainedByPropertyTag());
    }

    public final BaseMetadataObject getContainedByObject(short s) {
        return (BaseMetadataObject)this.getPropertyObjectValue(this.getContainedByPropertyTag(), s);
    }

    protected final void setContainedByObject(BaseMetadataObject baseMetadataObject) {
        this.setPropertyObjectValue(this.getContainedByPropertyTag(), baseMetadataObject);
    }

    public final boolean isDeleted() {
        return this.m_Deleted;
    }

    protected boolean isModified(Object object, Object object2, Transaction transaction) {
        return object != this.getPersistentState() && object != object2;
    }

    protected boolean isModified(long l, long l2, Transaction transaction) {
        if (2 == this.getPersistenceType() && 0L == l2) {
            return true;
        }
        if (null != this.getPersistentState() && null == this.getMetadataStateManager()) {
            return false;
        }
        return l != l2;
    }

    final boolean isModifiedBetween(Transaction transaction, Transaction transaction2) {
        if (null == this.getMetadataStateManager()) {
            return false;
        }
        Transaction transaction3 = this.getMetadataStateManager().getActiveTransaction(transaction);
        if (transaction3 == null) {
            return false;
        }
        return !transaction3.isAncestorOf(transaction2);
    }

    public final boolean isPersistent() {
        return this.isPersistent(true);
    }

    private boolean isPersistent(boolean bl) {
        if (bl) {
            this.checkRefetchPersistentState();
        }
        return this.getPersistenceType() != 0 && this.getPersistenceType() != -1;
    }

    private final void setPersistenceType(short s) {
        this.m_PersistenceType = s;
    }

    protected final short getPersistenceType() {
        return this.m_PersistenceType;
    }

    final boolean isPersistent(Transaction transaction) {
        if (null == this.getPersistentState()) {
            return false;
        }
        return this.getCurrentStateForRead() == this.getPersistentState();
    }

    protected final synchronized void mapObject(XMLTag xMLTag, MetadataObject metadataObject, MetadataObject metadataObject2) {
        if (null == metadataObject) {
            return;
        }
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        MetadataObjectHolder metadataObjectHolder = null;
        MetadataObjectHolder metadataObjectHolder2 = this.getBaseMetadataProvider().getObjectHolder(metadataObject.getID());
        if (null != metadataObject2) {
            metadataObjectHolder = this.getBaseMetadataProvider().getObjectHolder(metadataObject2.getID());
        }
        baseMetadataObjectState.mapObject(xMLTag, metadataObjectHolder2, metadataObjectHolder, this);
    }

    protected final synchronized void mapValue(XMLTag xMLTag, MetadataObject metadataObject, String string) {
        if (null == metadataObject) {
            return;
        }
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        MetadataObjectHolder metadataObjectHolder = this.getBaseMetadataProvider().getObjectHolder(metadataObject.getID());
        baseMetadataObjectState.mapObject(xMLTag, metadataObjectHolder, string, this);
    }

    protected final MetadataObject getMappedObject(XMLTag xMLTag, MetadataObject metadataObject) {
        if (null == metadataObject) {
            return null;
        }
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForRead();
        return baseMetadataObjectState.getMappedObject(xMLTag, metadataObject, this.getBaseMetadataProvider());
    }

    protected final String getMappedValue(XMLTag xMLTag, MetadataObject metadataObject) {
        if (null == metadataObject) {
            return null;
        }
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForRead();
        return baseMetadataObjectState.getMappedValue(xMLTag, metadataObject, this.getBaseMetadataProvider());
    }

    protected boolean isServerVersionLaterThan(int[] nArray) {
        return this.getBaseMetadataProvider().getDataProvider().isServerVersionLaterThan(nArray);
    }

    protected final void setInitialPersistenceType(short s) {
        switch (s) {
            case 2: {
                if (0 == this.getPersistenceType()) {
                    this.setPersistentState(this.getCurrentStateForRead());
                    break;
                }
                if (-1 != this.getPersistenceType()) break;
                this.setPersistentState(new BaseMetadataObjectState());
                break;
            }
            case 1: 
            case 3: {
                this.setPersistentState(new BaseMetadataObjectState());
                break;
            }
            case 0: {
                this.getCurrentStateForWrite();
            }
        }
        if (s == 3) {
            s = 1;
        }
        this.setPersistenceType(s);
    }

    private final void setDeleted(boolean bl) {
        this.m_Deleted = bl;
    }

    final void setHolder(MetadataObjectHolder metadataObjectHolder) {
        this.m_Holder = metadataObjectHolder;
    }

    protected final void setInternalID(String string) {
        this.m_InternalID = string;
    }

    protected String generateInternalID() {
        String string;
        if (this.getName().length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(this.getInternalID().length());
        if (this.isTopLevelObject()) {
            string = this.getOwnerName();
            if (null != string && string.length() > 0) {
                stringBuffer.append(string);
                stringBuffer.append(".");
            }
        } else if (null != this.getContainedByObject()) {
            stringBuffer.append(this.getContainedByObject().getID());
            stringBuffer.append(".");
        }
        stringBuffer.append(this.getName());
        string = stringBuffer.toString();
        if (string.equals(this.getInternalID())) {
            return null;
        }
        return string;
    }

    private final void setMetadataProvider(BaseMetadataProvider baseMetadataProvider) {
        this.m_MetadataProvider = baseMetadataProvider;
    }

    private final void setMetadataStateManager(MetadataStateManager metadataStateManager) {
        this.m_MetadataStateManager = metadataStateManager;
    }

    private final void setPersistentState(BaseMetadataObjectState baseMetadataObjectState) {
        this.m_PersistentState = baseMetadataObjectState;
    }

    protected final synchronized void setPropertyObjectValue(XMLTag xMLTag, Object object) {
        if (object instanceof BaseMetadataObject && ((BaseMetadataObject)object).isDeleted()) {
            throw new TransactionalObjectInvalidException();
        }
        ObjectHolder objectHolder = new ObjectHolder(object);
        if (!this.verifySetProperty(xMLTag, objectHolder)) {
            return;
        }
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        if (objectHolder.getObject() instanceof MetadataObject) {
            MetadataObject metadataObject = (MetadataObject)objectHolder.getObject();
            MetadataObjectHolder metadataObjectHolder = this.getBaseMetadataProvider().getObjectHolder(metadataObject.getID());
            baseMetadataObjectState.setPropertyObjectValue(xMLTag, metadataObjectHolder, this.getBaseMetadataProvider(), this);
        } else {
            baseMetadataObjectState.setPropertyObjectValue(xMLTag, objectHolder.getObject(), this.getBaseMetadataProvider(), this);
        }
    }

    protected final synchronized void setPropertyStringValue(XMLTag xMLTag, String string, boolean bl) {
        ObjectHolder objectHolder = new ObjectHolder(string);
        if (this.verifySetProperty(xMLTag, objectHolder)) {
            BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
            baseMetadataObjectState.setPropertyStringValue(xMLTag, (String)objectHolder.getObject(), this.getBaseMetadataProvider(), this, bl);
        }
    }

    protected final synchronized void setPropertyStringValue(XMLTag xMLTag, String string) {
        this.setPropertyStringValue(xMLTag, string, false);
    }

    protected final synchronized void setPropertyIntegerValue(XMLTag xMLTag, int n) {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        baseMetadataObjectState.setPropertyIntegerValue(xMLTag, n, this.getBaseMetadataProvider(), this);
    }

    protected final synchronized void setPropertyBooleanValue(XMLTag xMLTag, boolean bl) {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        if (bl) {
            baseMetadataObjectState.setPropertyStringValue(xMLTag, "True", this.getBaseMetadataProvider(), this);
        } else {
            baseMetadataObjectState.setPropertyStringValue(xMLTag, "False", this.getBaseMetadataProvider(), this);
        }
    }

    public void copyPropertyTo(BaseMetadataObject baseMetadataObject, XMLTag xMLTag, CopyPolicy copyPolicy, CopyPolicy.CopyReferenceType copyReferenceType) throws CopyException {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForRead();
        BaseMetadataObjectState baseMetadataObjectState2 = baseMetadataObject.getCurrentStateForWrite();
        baseMetadataObjectState.copyPropertyTo(baseMetadataObjectState2, xMLTag, this.getBaseMetadataProvider(), copyPolicy, copyReferenceType);
    }

    public void copyAllPropertiesTo(BaseMetadataObject baseMetadataObject, CopyPolicy copyPolicy, CopyPolicy.CopyReferenceType copyReferenceType) throws CopyException {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForRead();
        BaseMetadataObjectState baseMetadataObjectState2 = baseMetadataObject.getCurrentStateForWrite();
        baseMetadataObjectState.copyAllPropertiesTo(baseMetadataObjectState2, this.getBaseMetadataProvider(), copyPolicy, copyReferenceType);
    }

    public void gatherReferencedSources(List list, Transaction transaction) {
        ((BaseMetadataObjectState)this.getCurrentStateForRead(transaction)).gatherReferencedSources(list);
    }

    public void gatherReferencedSources(List list) {
        this.gatherReferencedSources(list, this.getActiveTransaction());
    }

    @Override
    public Object getTransactionalState(Transaction transaction) {
        return this.getCurrentStateForRead(transaction);
    }

    final long getStateGenerationNumber(Transaction transaction) {
        this.checkRefetchPersistentState();
        if (null != this.getPersistentState() && null == this.getMetadataStateManager()) {
            return 0L;
        }
        if (null == this.getMetadataStateManager()) {
            return 1L;
        }
        long l = this.getMetadataStateManager().getIncrementalStateGenerationNumber(transaction);
        return l;
    }

    private final long getCurrentStateGenerationNumber() {
        return this.getStateGenerationNumber(this.getCurrentSystemTransaction());
    }

    protected static String generateID(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
            if (i != 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    protected static String generateID(BaseMetadataObject baseMetadataObject, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(baseMetadataObject.getInternalID());
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected static String generateID(BaseMetadataObject baseMetadataObject, String[] stringArray) {
        return BaseMetadataObject.generateID(baseMetadataObject, BaseMetadataObject.generateID(stringArray));
    }

    protected static String generateNamespaceID(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != string && string.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append("..");
        }
        for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
            if (i != 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public MdmSchema getOwner() {
        BaseMetadataObject baseMetadataObject = this.getContainedByObject();
        if (baseMetadataObject == null) {
            if (this.getBaseMetadataProvider() instanceof MdmMetadataProvider) {
                return ((MdmMetadataProvider)this.getBaseMetadataProvider()).getRootSchema();
            }
            return null;
        }
        return baseMetadataObject.getOwner();
    }

    public final boolean isTopLevelObject() {
        return null == this.getContainedByPropertyTag();
    }

    public final BaseMetadataObject getTopLevelObject() {
        return this.getTopLevelObject((short)0);
    }

    public final BaseMetadataObject getTopLevelObject(short s) {
        for (BaseMetadataObject baseMetadataObject = this; baseMetadataObject != null; baseMetadataObject = baseMetadataObject.getContainedByObject(s)) {
            if (!baseMetadataObject.isTopLevelObject()) continue;
            return baseMetadataObject;
        }
        throw new InvalidMetadataException(this.getID());
    }

    public final BaseMetadataObject getTopContainedByObject() {
        BaseMetadataObject baseMetadataObject = null;
        for (BaseMetadataObject baseMetadataObject2 = this; baseMetadataObject2 != null; baseMetadataObject2 = baseMetadataObject2.getContainedByObject()) {
            baseMetadataObject = baseMetadataObject2;
        }
        return baseMetadataObject;
    }

    public final String getOwnerName() {
        return this.getOwnerName((short)0);
    }

    public final String getOwnerName(short s) {
        BaseMetadataObject baseMetadataObject = null;
        BaseMetadataObject baseMetadataObject2 = this;
        while (baseMetadataObject2 != null) {
            baseMetadataObject = baseMetadataObject2.getContainedByObject(s);
            if (baseMetadataObject == null) {
                MetadataObjectHolder metadataObjectHolder = baseMetadataObject2.getPropertyObjectHolder(BaseMetadataXMLTags.OWNER, s);
                if (metadataObjectHolder == null) {
                    if (baseMetadataObject2 instanceof MdmRootSchema) {
                        return baseMetadataObject2.getInternalID();
                    }
                    throw new InvalidMetadataException(baseMetadataObject2.getID());
                }
                if (baseMetadataObject2 instanceof MdmDatabaseSchema) {
                    return baseMetadataObject2.getInternalID();
                }
                return metadataObjectHolder.getObjectID();
            }
            baseMetadataObject2 = baseMetadataObject;
        }
        return null;
    }

    @Override
    public final void update(Transaction transaction) {
    }

    @Override
    public final void rollbackPersistentState() {
        if (this.isPersistent(false)) {
            return;
        }
        this.getBaseMetadataProvider().unregisterMetadataObject(this);
    }

    public final void revertPersistentState() {
        if (!this.isPersistent(false)) {
            return;
        }
        this.getPersistentState().revertPersistentState();
        if (null == this.getMetadataStateManager()) {
            this.setPersistentState(new BaseMetadataObjectState());
        } else {
            this.getMetadataStateManager().revert(PersistentMetadataContext.INSTANCE);
            this.setPersistentState(this.getPersistentStateForWrite());
        }
    }

    public final void revertIsolationState(MetadataContext metadataContext) {
        this.getMetadataStateManager().revert(metadataContext);
    }

    private void checkRefetchPersistentState() {
        if (null != this.getHolder() && 2 == this.getHolder().getFetchStatus()) {
            this.getBaseMetadataProvider().fetchMetadataObject(this.getHolder());
        }
    }

    final void changePersistenceType(short s, boolean bl) {
        if (s == 3) {
            s = 1;
        }
        if (s == this.getPersistenceType()) {
            return;
        }
        this.setPersistenceType(s);
        if (s == 1) {
            if (bl) {
                this.setPersistentState(this.getCurrentStateForRead());
            } else if (null != this.getMetadataStateManager()) {
                this.setPersistentState(this.getPersistentStateForWrite());
            } else {
                this.setPersistentState(new BaseMetadataObjectState());
            }
        } else if (s == 0) {
            this.setPersistentState(null);
            if (null != this.getMetadataStateManager()) {
                this.getMetadataStateManager().clearPersistentState();
            }
        } else if (s == -1) {
            this.setPersistentState(null);
            this.setDeleted(true);
            if (null != this.getMetadataStateManager()) {
                this.getMetadataStateManager().clearStates();
            } else {
                this.rollbackPersistentState();
            }
        }
    }

    protected final BaseMetadataObject findOrCreateContainedObject(String string, String string2, short s, XMLTag xMLTag, Class clazz) {
        return this.findOrCreateContainedObject(string, string2, s, xMLTag, clazz, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final BaseMetadataObject findOrCreateContainedObject(String string, String string2, short s, XMLTag xMLTag, Class clazz, XMLTag[] xMLTagArray, String[] stringArray) {
        if (null == clazz) {
            clazz = xMLTag.getObjectClass();
        }
        BaseMetadataObject baseMetadataObject = null;
        BaseMetadataObject baseMetadataObject2 = this.getTopLevelObject();
        BaseMetadataObject baseMetadataObject3 = this.getBaseMetadataProvider().fetchClientMetadataObject(string, s, baseMetadataObject2);
        if (null == baseMetadataObject3) {
            BaseMetadataProvider baseMetadataProvider = this.getBaseMetadataProvider();
            synchronized (baseMetadataProvider) {
                baseMetadataObject3 = this.getBaseMetadataProvider().fetchClientMetadataObject(string, s, baseMetadataObject2);
                if (null == baseMetadataObject3) {
                    try {
                        baseMetadataObject = xMLTag.getFactory().createMetadataObject(clazz, string, string2, s, this, xMLTagArray, stringArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new RuntimeException(clazz.getName(), noSuchMethodException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new RuntimeException(clazz.getName(), instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException(clazz.getName(), illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new RuntimeException(clazz.getName(), (Exception)invocationTargetException.getCause());
                    }
                    xMLTag.initializeProperty(this, (Object)baseMetadataObject.getInternalID(), s);
                    return baseMetadataObject;
                }
            }
        }
        if (clazz.isInstance(baseMetadataObject3)) {
            baseMetadataObject = baseMetadataObject3;
            xMLTag.initializeProperty(this, (Object)baseMetadataObject.getInternalID(), s);
        } else if (null != baseMetadataObject3) {
            throw new DuplicateMetadataIDException(baseMetadataObject3.getID());
        }
        return baseMetadataObject;
    }

    private BaseMetadataObjectState getTransientOrPersistentStateForWrite(int n) {
        boolean bl = true;
        return this.getTransientOrPersistentState(n, bl);
    }

    private BaseMetadataObjectState getTransientOrPersistentStateForRead(int n) {
        boolean bl = false;
        return this.getTransientOrPersistentState(n, bl);
    }

    private BaseMetadataObjectState getTransientOrPersistentState(int n, boolean bl) {
        BaseTransaction baseTransaction = (BaseTransaction)this.getCurrentSystemTransaction();
        if (baseTransaction.isCommitting() && null == baseTransaction.getParent() && 3 == n) {
            if (bl) {
                return this.getStateForWrite(baseTransaction, false);
            }
            return (BaseMetadataObjectState)this.getCurrentStateForRead(baseTransaction);
        }
        if (this.isPersistent(false) && 0 != n) {
            return this.getPersistentState();
        }
        if (bl) {
            return this.getCurrentStateForWrite();
        }
        return this.getCurrentStateForRead();
    }

    protected List<MetadataObjectHolder> getContainedChildren() {
        ArrayList<MetadataObjectHolder> arrayList = new ArrayList<MetadataObjectHolder>();
        this.gatherContainedChildren(arrayList);
        return arrayList;
    }

    protected void gatherContainedChildren(List<MetadataObjectHolder> list) {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForRead();
        baseMetadataObjectState.gatherContainedChildren(list);
    }

    protected void updateName() {
        String string = this.getCurrentStateForRead().getPropertyStringValue(MdmXMLTags.NEW_NAME);
        if (null != string && string.length() > 0) {
            String string2 = this.getCurrentStateForRead().getPropertyStringValue(MdmXMLTags.NAME);
            if (null != string2 && string2.length() > 0) {
                this.internalSetStringProperty(MdmXMLTags.NAME, string, 3, true);
            }
            this.internalSetStringProperty(MdmXMLTags.NEW_NAME, null, 3, true);
        }
    }

    protected void updateID(String string) {
        String string2 = this.getInternalID();
        this.setInternalID(string);
        this.set102ID(null);
        this.getHolder().updateID();
        this.getBaseMetadataProvider().reregisterMetadataObject(this, string2);
    }

    public final void updateIDsOfSelfAndChildren() {
        String string = this.generateInternalID();
        if (null != string) {
            this.updateID(string);
        }
        List<MetadataObjectHolder> list = this.getContainedChildren();
        for (MetadataObjectHolder metadataObjectHolder : list) {
            MetadataObject metadataObject = metadataObjectHolder.getMetadataObject();
            if (null == metadataObject || !(metadataObject instanceof BaseMetadataObject)) continue;
            ((BaseMetadataObject)metadataObject).updateIDsOfSelfAndChildren();
        }
    }

    public final String get102ID() {
        if (null == this.m_102ID) {
            this.set102ID(this.generate102ID());
        }
        return this.m_102ID;
    }

    private final void set102ID(String string) {
        this.m_102ID = string;
    }

    protected String generate102ID() {
        return null;
    }

    protected final boolean hasPrivateName() {
        return this.getMetadataObjectClass().hasPrivateName();
    }

    public static boolean classHasPrivateName() {
        return false;
    }

    protected final XMLTag getObjRefIDAttribute() {
        return this.getMetadataObjectClass().getObjRefIDAttribute();
    }

    public static XMLTag classGetObjRefIDAttribute() {
        return null;
    }

    public static Class getSubClassForID(Identifier identifier) {
        return null;
    }

    protected final MetadataObjectClass getMetadataObjectClass() {
        return MetadataObjectClass.getMetadataObjectClass(this.getClass());
    }
}

