/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.log;

import java.util.Properties;
import java.util.StringTokenizer;
import oracle.olapi.log.LogHandler;
import oracle.olapi.log.LogHandlerFactory;

public class LogHandlerCreator {
    public static final String CLASS_KEY = "class";

    private LogHandlerCreator() {
    }

    public static LogHandler createHandlerFromString(String string, Properties properties) {
        try {
            Properties properties2 = LogHandlerCreator.makeProperties(string, properties);
            String string2 = properties2.getProperty(CLASS_KEY);
            return LogHandlerCreator.createLogHandler(string2, properties2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static LogHandler createLogHandler(String string, Properties properties) throws Exception {
        if (string == null) {
            return null;
        }
        LogHandlerFactory logHandlerFactory = (LogHandlerFactory)Class.forName(string).newInstance();
        return logHandlerFactory.createLogHandler(properties);
    }

    private static Properties makeProperties(String string, Properties properties) {
        Properties properties2 = (Properties)properties.clone();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=, ", false);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreElements()) continue;
            properties2.put(string2, stringTokenizer.nextToken());
        }
        return properties2;
    }
}

