/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.HiddenDefinition;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.Source;
import oracle.olapi.metadata.MetadataProvider;
import oracle.olapi.metadata.mdm.MdmSourceDefinition;
import oracle.olapi.transaction.BaseTransaction;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionalObject;
import oracle.olapi.transaction.TransactionalObjectInvalidException;

public abstract class SourceDefinition
implements TransactionalObject {
    private String m_ID = null;
    private String m_PersistentID = null;
    private Source m_LocalSource = null;
    private DataProvider m_DataProvider = null;
    private MetadataProvider m_MetadataProvider = null;

    SourceDefinition(String string, DataProvider dataProvider) {
        this.setID(string);
        this.setDataProvider(dataProvider);
    }

    public abstract Object acceptVisitor(DataDescriptorDefinitionVisitor var1, Object var2);

    abstract void accumulateInputs(Set var1, Transaction var2, boolean var3, boolean var4);

    abstract void accumulateOutputs(List var1, Transaction var2);

    void accumulateElementOutputs(List list, Transaction transaction) {
        this.accumulateOutputs(list, transaction);
    }

    abstract void checkValidity(Transaction var1) throws TransactionalObjectInvalidException;

    final Source createSource(Transaction transaction) {
        TransactionalObject transactionalObject;
        SourceDefinition sourceDefinition = this.getType(transaction);
        if (null == sourceDefinition) {
            transactionalObject = (MdmSourceDefinition)this;
            System.out.println("type = null for " + ((MdmSourceDefinition)transactionalObject).getMdmSource());
        }
        if (null == (transactionalObject = sourceDefinition.findOrCreateSource(transaction))) {
            System.out.println("type = null for " + this);
        }
        return ((Source)transactionalObject).createInstance(this);
    }

    final SourceDefinition findMatchFor(SourceDefinition sourceDefinition, Transaction transaction) {
        if (this.isSubtypeOf(sourceDefinition, transaction)) {
            return this;
        }
        ArrayList arrayList = new ArrayList();
        this.accumulateOutputs(arrayList, transaction);
        for (Source source : arrayList) {
            SourceDefinition sourceDefinition2 = source.getDefinition().findMatchFor(sourceDefinition, transaction);
            if (sourceDefinition2 == null) continue;
            return sourceDefinition2;
        }
        return null;
    }

    final Source findMatchSourceFor(SourceDefinition sourceDefinition) {
        Transaction transaction = this.getCurrentSystemTransaction();
        SourceDefinition sourceDefinition2 = this.findMatchFor(sourceDefinition, transaction);
        if (null == sourceDefinition2) {
            return null;
        }
        return sourceDefinition2.findOrCreateSource(transaction);
    }

    public Model findOrCreateExtractModel(Source source, Transaction transaction) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source findOrCreateSource(Transaction transaction) {
        if (null == this.getLocalSource()) {
            SourceDefinition sourceDefinition = this;
            synchronized (sourceDefinition) {
                if (null == this.getLocalSource()) {
                    Source source = this.createSource(transaction);
                }
            }
        }
        return this.getLocalSource();
    }

    public final SourceDefinition getCommonType(SourceDefinition sourceDefinition, Transaction transaction) {
        SourceDefinition sourceDefinition2 = null;
        if (this.isSubtypeOf(sourceDefinition, transaction)) {
            sourceDefinition2 = sourceDefinition;
        } else if (sourceDefinition.isSubtypeOf(this, transaction)) {
            sourceDefinition2 = this;
        } else {
            SourceDefinition sourceDefinition3 = sourceDefinition.getType(transaction);
            while (sourceDefinition2 == null && sourceDefinition3 != null) {
                if (this.isSubtypeOf(sourceDefinition3, transaction)) {
                    sourceDefinition2 = sourceDefinition3;
                    continue;
                }
                sourceDefinition3 = sourceDefinition3.getType(transaction);
            }
        }
        return sourceDefinition2;
    }

    public abstract Transaction getActiveTransaction();

    final Transaction getCurrentSystemTransaction() {
        BaseTransaction baseTransaction = this.getDataProvider().getBaseTransactionProvider().getCurrentSystemTransaction();
        this.checkValidity(baseTransaction);
        return baseTransaction;
    }

    public final DataProvider getDataProvider() {
        return this.m_DataProvider;
    }

    final Set getExtractionInputs() {
        HashSet hashSet = new HashSet();
        this.accumulateInputs(hashSet, this.getCurrentSystemTransaction(), false, true);
        return hashSet;
    }

    HiddenDefinition getHiddenType(Transaction transaction) {
        return this.getType(transaction).getHiddenType(transaction);
    }

    public final String getID() {
        return this.m_ID;
    }

    final Set getInputs() {
        HashSet hashSet = new HashSet();
        this.accumulateInputs(hashSet, this.getCurrentSystemTransaction(), true, true);
        return hashSet;
    }

    final Source getLocalSource() {
        return this.m_LocalSource;
    }

    final MetadataProvider getMetadataProvider() {
        return this.m_MetadataProvider;
    }

    public Model getModel() {
        return null;
    }

    final List getOutputs() {
        ArrayList arrayList = new ArrayList();
        this.accumulateOutputs(arrayList, this.getCurrentSystemTransaction());
        return arrayList;
    }

    final String getPersistentID() {
        return this.m_PersistentID;
    }

    final Set getRegularInputs() {
        HashSet hashSet = new HashSet();
        this.accumulateInputs(hashSet, this.getCurrentSystemTransaction(), true, false);
        return hashSet;
    }

    public final Source getSource() {
        return this.findOrCreateSource(this.getCurrentSystemTransaction());
    }

    abstract SourceDefinition getType(Transaction var1);

    abstract SourceDefinition getElementType(Transaction var1);

    Source getTypeSource() {
        Transaction transaction = this.getCurrentSystemTransaction();
        SourceDefinition sourceDefinition = this.getType(transaction);
        return sourceDefinition.findOrCreateSource(transaction);
    }

    final Transaction getIncrementalTransaction() {
        BaseTransaction baseTransaction = this.getDataProvider().getBaseTransactionProvider().getIncrementalTransaction();
        this.checkValidity(baseTransaction);
        return baseTransaction;
    }

    final boolean isSubtypeOf(SourceDefinition sourceDefinition) {
        Transaction transaction = this.getCurrentSystemTransaction();
        return this.isSubtypeOf(sourceDefinition, transaction);
    }

    private final boolean isSubtypeOf(SourceDefinition sourceDefinition, Transaction transaction) {
        for (SourceDefinition sourceDefinition2 = this; sourceDefinition2 != null; sourceDefinition2 = sourceDefinition2.getType(transaction)) {
            if (!sourceDefinition2.equals(sourceDefinition)) continue;
            return true;
        }
        return false;
    }

    private final void setDataProvider(DataProvider dataProvider) {
        this.m_DataProvider = dataProvider;
    }

    protected final void setID(String string) {
        this.m_ID = string;
    }

    final void setLocalSource(Source source) {
        this.m_LocalSource = source;
    }

    protected final void setMetadataProvider(MetadataProvider metadataProvider) {
        this.m_MetadataProvider = metadataProvider;
    }

    protected final void setPersistentID(String string) {
        this.m_PersistentID = string;
    }

    public void updatePersistentID() {
    }

    public abstract Object getTransactionalState(Transaction var1);
}

