/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.olapi.data.source.CompoundCursorInfoSpecification;
import oracle.olapi.data.source.CursorSpecification;
import oracle.olapi.data.source.CursorSpecificationVisitor;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.ValueCursorInfoSpecification;
import oracle.olapi.data.source.ValueCursorSpecification;
import oracle.olapi.transaction.Transaction;

public final class CompoundCursorSpecification
extends CursorSpecification
implements CompoundCursorInfoSpecification {
    private ValueCursorSpecification _valueCursorSpecification;
    private List _outputs;

    CompoundCursorSpecification(SourceDefinition sourceDefinition, List list) {
        super(sourceDefinition);
        this._outputs = Collections.unmodifiableList(list);
        this._valueCursorSpecification = new ValueCursorSpecification(sourceDefinition);
    }

    public final Object acceptVisitor(CursorSpecificationVisitor cursorSpecificationVisitor, Object object) {
        return cursorSpecificationVisitor.visitCompoundCursorSpecification(this, object);
    }

    public final List getOutputs() {
        return this._outputs;
    }

    public final ValueCursorSpecification getValueCursorSpecification() {
        return this._valueCursorSpecification;
    }

    public final ValueCursorInfoSpecification getValue() {
        return this.getValueCursorSpecification();
    }

    final boolean isExpired(SourceDefinition sourceDefinition, Transaction transaction) {
        if (this._getSourceDefinition() != sourceDefinition) {
            return true;
        }
        ArrayList arrayList = new ArrayList();
        this._getSourceDefinition().accumulateOutputs(arrayList, transaction);
        if (arrayList.size() != this.getOutputs().size()) {
            return true;
        }
        Iterator iterator = arrayList.iterator();
        for (CursorSpecification cursorSpecification : this.getOutputs()) {
            Source source;
            if (!cursorSpecification.isExpired((source = (Source)iterator.next()).getDefinition(), transaction)) continue;
            return true;
        }
        return false;
    }

    public final void specifyDefaultFetchSizeOnChildren() {
        this.specifyDefaultFetchSizeOnChildren(this.getDefaultFetchSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void specifyDefaultFetchSizeOnChildren(int n) {
        Object object = this;
        synchronized (object) {
            if (this.getDefaultFetchSize() == -1) {
                throw new IllegalStateException();
            }
            this._setDefaultFetchSize(-1);
        }
        object = this._outputs.iterator();
        while (object.hasNext()) {
            ((CursorSpecification)object.next())._setDefaultFetchSize(n);
        }
    }
}

