/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.olapi.HasLocalizedMessage;

public abstract class OLAPIRuntimeException
extends RuntimeException
implements HasLocalizedMessage {
    private String m_MessageID;
    private Object[] m_Params;

    public OLAPIRuntimeException(String string) {
        super(string);
        this.m_MessageID = string;
    }

    public OLAPIRuntimeException(String string, String string2) {
        super(string);
        this.m_MessageID = string;
        this.m_Params = new Object[]{string2};
    }

    public OLAPIRuntimeException(String string, String string2, String string3) {
        super(string);
        this.m_MessageID = string;
        this.m_Params = new Object[]{string2, string3};
    }

    public OLAPIRuntimeException(String string, String string2, String string3, String string4) {
        super(string);
        this.m_MessageID = string;
        this.m_Params = new Object[]{string2, string3, string4};
    }

    public OLAPIRuntimeException(String string, String[] stringArray) {
        super(string);
        this.m_MessageID = string;
        if (null != stringArray) {
            this.m_Params = new Object[stringArray.length];
            for (int i = 0; i < this.m_Params.length; ++i) {
                this.m_Params[i] = stringArray[i];
            }
        }
    }

    public String getLocalizedMessage(Locale locale) {
        return OLAPIRuntimeException.getMessage(this.m_MessageID, this.m_Params, locale);
    }

    public static String getMessage(String string, Object[] objectArray, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.olapi.resource.ExceptionBundle", locale);
        String string2 = resourceBundle.getString(string);
        return MessageFormat.format(string2, objectArray);
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String toString() {
        try {
            return this.getLocalizedMessage();
        }
        catch (MissingResourceException missingResourceException) {
            return super.toString();
        }
    }
}

