/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.replay;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.StringTokenizer;
import oracle.express.mdm.MdmBaseObjectVisitor;
import oracle.express.mdm.MdmHierarchy;
import oracle.express.mdm.MdmLevel;
import oracle.express.mdm.MdmListDimension;
import oracle.express.mdm.MdmMetadataProvider;
import oracle.express.mdm.MdmObject;
import oracle.express.olapi.replay.DefinitionWriterParameters;
import oracle.express.olapi.replay.OutputHandler;
import oracle.express.olapi.replay.WriterContext;
import oracle.express.olapi.replay.XMLDocumentFactory;
import oracle.express.olapi.replay.XMLFactory;
import oracle.olapi.data.source.AliasDefinition;
import oracle.olapi.data.source.ConstantListDefinition;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.DistinctDefinition;
import oracle.olapi.data.source.DynamicDefinition;
import oracle.olapi.data.source.ExtractDefinition;
import oracle.olapi.data.source.HiddenDefinition;
import oracle.olapi.data.source.JoinDefinition;
import oracle.olapi.data.source.PositionDefinition;
import oracle.olapi.data.source.RangeDefinition;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.Template;
import oracle.olapi.data.source.ValueDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefinitionWriter {
    public static final String FILEVERSION = "1.0";
    public static final String OLAPHEADERCOMMENT = "OLAP API SourceDefinition Output created on {0,date} at {0,time}";
    public static final String TOPELEMENT = "Datadescriptors";
    private VisitedSourceDumper visitor = new VisitedSourceDumper();
    private MessageFormat _format = new MessageFormat("OLAP API SourceDefinition Output created on {0,date} at {0,time}");
    private DefinitionWriterParameters parameters;

    public DefinitionWriter() {
        this(null);
    }

    public DefinitionWriter(DefinitionWriterParameters definitionWriterParameters) throws NullPointerException {
        this.setParameters(definitionWriterParameters);
    }

    public synchronized void setParameters(DefinitionWriterParameters definitionWriterParameters) throws NullPointerException {
        this.parameters = definitionWriterParameters != null ? (DefinitionWriterParameters)definitionWriterParameters.clone() : DefinitionWriterParameters.getDefaults();
    }

    public synchronized DefinitionWriterParameters getParameters() {
        return this.parameters;
    }

    public static Collection toCollection(Source source) {
        return Arrays.asList(source);
    }

    public static Collection toCollection(Source[] sourceArray) {
        return Arrays.asList(sourceArray);
    }

    public void write(Source source, OutputHandler outputHandler) {
        outputHandler.write(this.write(source));
    }

    public void write(Source[] sourceArray, OutputHandler outputHandler) {
        outputHandler.write(this.write(sourceArray));
    }

    public void write(Collection collection, OutputHandler outputHandler) {
        outputHandler.write(this.write(collection));
    }

    public void write(Source source, Writer writer) throws IOException {
        this.write(DefinitionWriter.toCollection(source), writer);
    }

    public void write(Source[] sourceArray, Writer writer) throws IOException {
        this.write(DefinitionWriter.toCollection(sourceArray), writer);
    }

    public void write(Collection collection, Writer writer) throws IOException {
        PrintWriter printWriter = new PrintWriter(writer);
        Document document = this.createDocument(collection);
        this.getFactory().print(document, printWriter);
        printWriter.flush();
    }

    public Document createDocument(Collection collection) {
        Document document = this.getFactory().createDocument();
        XMLFactory xMLFactory = new XMLFactory(document);
        this.fillDocument(xMLFactory);
        Element element = this.visitor.visit(collection, xMLFactory, this.getParameters());
        xMLFactory.getRootElement().appendChild(element);
        return document;
    }

    public String write(Collection collection) {
        try {
            StringWriter stringWriter = new StringWriter();
            this.write(collection, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public String write(Source source) {
        return this.write(DefinitionWriter.toCollection(source));
    }

    public String write(Source[] sourceArray) {
        return this.write(DefinitionWriter.toCollection(sourceArray));
    }

    protected void fillDocument(XMLFactory xMLFactory) {
        boolean bl = this.getParameters().getIncludeXMLHeader();
        if (bl) {
            xMLFactory.addToDoc(xMLFactory.createComment(this.getComment()));
        }
        Element element = xMLFactory.createElement(TOPELEMENT);
        element.setAttributeNode(xMLFactory.createAttribute("version", FILEVERSION));
        xMLFactory.addToDoc(element);
    }

    protected String getComment() {
        return this._format.format(new Object[]{new Date()});
    }

    protected XMLDocumentFactory getFactory() {
        return this.parameters.getXMLDocumentFactory();
    }

    class VisitedSourceDumper
    extends DataDescriptorDefinitionVisitor {
        public static final String LISTTAG = "List";
        public static final String EMPTYSOURCE = "Emptysource";
        public static final String VOIDSOURCE = "Voidsource";

        public Element visit(Collection collection, XMLFactory xMLFactory, DefinitionWriterParameters definitionWriterParameters) {
            WriterContext writerContext = new WriterContext(xMLFactory, definitionWriterParameters);
            return this.visit(collection, writerContext);
        }

        private Node visit(SourceDefinition sourceDefinition, WriterContext writerContext) {
            Node node;
            block3: {
                node = null;
                try {
                    node = this.dispatch(sourceDefinition, writerContext);
                }
                catch (Exception exception) {
                    if (!writerContext.getParameters().getShowEmptyNodeComment()) break block3;
                    node = writerContext.getFactory().createComment("Exception " + exception + " occured at " + sourceDefinition.toString());
                }
            }
            if (node == null && writerContext.getParameters().getShowEmptyNodeComment()) {
                node = writerContext.getFactory().createComment("Null Node encountered at " + sourceDefinition.toString());
            }
            return node;
        }

        private Element dispatch(SourceDefinition sourceDefinition, WriterContext writerContext) {
            if (sourceDefinition == null) {
                return null;
            }
            Element element = null;
            if (writerContext.isEmptySource(sourceDefinition)) {
                element = this.getEmptySourceElement(writerContext.getFactory());
            } else if (writerContext.isVoidSource(sourceDefinition)) {
                element = this.getVoidSourceElement(writerContext.getFactory());
            } else if (writerContext.isFundamental(sourceDefinition)) {
                element = this.getFundamentalElement(sourceDefinition, writerContext.getFactory());
            } else if (writerContext.isVisited(sourceDefinition)) {
                element = writerContext.getVisitedElement(sourceDefinition);
            } else {
                Element element2;
                XMLFactory xMLFactory = writerContext.getFactory();
                element = xMLFactory.createElement("Definition");
                element.setAttributeNode(xMLFactory.createAttribute("id", writerContext.makeName(sourceDefinition)));
                Element element3 = (Element)sourceDefinition.acceptVisitor(this, writerContext);
                if (element3 != null) {
                    element.appendChild(element3);
                }
                if (writerContext.getParameters().getShowStructure() && (element2 = this.getStructure(sourceDefinition, writerContext)) != null) {
                    element.appendChild(element2);
                }
            }
            return element;
        }

        private Element visit(SourceDefinition sourceDefinition, String string, WriterContext writerContext) {
            Element element = writerContext.getFactory().createElement(string);
            Node node = this.visit(sourceDefinition, writerContext);
            if (node != null) {
                element.appendChild(node);
            }
            if (sourceDefinition != null && writerContext.getParameters().getShowObjectHashValue()) {
                element.setAttribute("objectID", sourceDefinition.toString());
            }
            return element;
        }

        private Element visit(Collection collection, WriterContext writerContext) {
            Element element = null;
            try {
                XMLFactory xMLFactory = writerContext.getFactory();
                element = xMLFactory.createElement(LISTTAG);
                element.setAttributeNode(xMLFactory.createAttribute("count", collection.size()));
                for (Object e : collection) {
                    Node node;
                    try {
                        SourceDefinition sourceDefinition = e instanceof SourceDefinition ? (SourceDefinition)e : ((Source)e).getDefinition();
                        node = this.visit(sourceDefinition, writerContext);
                        element.appendChild(node);
                    }
                    catch (ClassCastException classCastException) {
                        node = xMLFactory.createTextElement("Data", e.toString());
                        node.setAttributeNode(xMLFactory.createAttribute("class", e.getClass().getName()));
                        element.appendChild(node);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return element;
        }

        public Element visit(Collection collection, Element element, WriterContext writerContext) {
            if (collection != null) {
                Element element2 = this.visit(collection, writerContext);
                element.appendChild(element2);
            }
            return element;
        }

        protected Node filterEmptyNode(Node node, Node node2) {
            return node.getFirstChild() != null ? node : node2;
        }

        protected Element getStructure(SourceDefinition sourceDefinition, WriterContext writerContext) {
            Collection collection;
            Object object;
            XMLFactory xMLFactory = writerContext.getFactory();
            Element element = xMLFactory.createElement("Structure");
            Source source = sourceDefinition.getSource();
            try {
                object = source.getType().getDefinition();
                element.appendChild(this.visit((SourceDefinition)object, "Type", writerContext));
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = xMLFactory.createElement("Inputs");
            try {
                collection = source.getRegularInputs();
                object.appendChild(this.visit(collection, xMLFactory.createElement("RegularInputs"), writerContext));
            }
            catch (Exception exception) {
                element.setAttributeNode(xMLFactory.createAttribute("regularinputs", "unknown"));
            }
            try {
                collection = source.getExtractionInputs();
                object.appendChild(this.visit(collection, xMLFactory.createElement("ExtractInputs"), writerContext));
            }
            catch (Exception exception) {
                element.setAttributeNode(xMLFactory.createAttribute("extractinputs", "unknown"));
            }
            element.appendChild((Node)object);
            try {
                collection = source.getOutputs();
                element.appendChild(this.visit(collection, xMLFactory.createElement("Outputs"), writerContext));
            }
            catch (Exception exception) {
                element.setAttributeNode(xMLFactory.createAttribute("outputs", "unknown"));
            }
            return (Element)this.filterEmptyNode(element, null);
        }

        protected boolean isEmptyCollection(Collection collection) {
            return collection == null || collection.isEmpty();
        }

        protected Object visitSourceDefinitionWithBase(String string, SourceDefinition sourceDefinition, Object object) {
            Element element = null;
            try {
                Class<?> clazz = sourceDefinition.getClass();
                Method method = clazz.getMethod("getBase", new Class[0]);
                SourceDefinition sourceDefinition2 = (SourceDefinition)method.invoke((Object)sourceDefinition, (Object[])null);
                WriterContext writerContext = (WriterContext)object;
                XMLFactory xMLFactory = writerContext.getFactory();
                element = xMLFactory.createElement(string);
                element.appendChild(this.visit(sourceDefinition2, "Base", writerContext));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Element commonDefinition(String string, SourceDefinition sourceDefinition, Object object) {
            WriterContext writerContext = (WriterContext)object;
            XMLFactory xMLFactory = writerContext.getFactory();
            Element element = xMLFactory.createElement(string);
            Source source = sourceDefinition.getSource();
            Class clazz = this.getVisibleClass(source);
            element.appendChild(xMLFactory.createTextElement("Class", clazz.getName()));
            Class<?> clazz2 = source.getClass();
            if (clazz2 != clazz) {
                element.appendChild(xMLFactory.createTextElement("InstantiatedClass", clazz2.getName()));
            }
            try {
                block5: {
                    try {
                        element.appendChild(xMLFactory.createTextElement("MetadataProvider", source.getMetadataProvider().getID()));
                        element.appendChild(xMLFactory.createTextElement("PersistentID", source.getPersistentID()));
                        if (!writerContext.getParameters().getShowMdmObject()) break block5;
                        element.appendChild(this.addProviderInfo(source, xMLFactory));
                    }
                    catch (NullPointerException nullPointerException) {
                        Object var12_11 = null;
                        return element;
                    }
                }
                Object var12_10 = null;
                return element;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                return element;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Element addProviderInfo(Source source, XMLFactory xMLFactory) {
            Element element = null;
            try {
                try {
                    MdmMetadataProvider mdmMetadataProvider = (MdmMetadataProvider)source.getMetadataProvider();
                    MdmObject mdmObject = mdmMetadataProvider.getMetadataObject(source.getPersistentID());
                    MdmObjectInformation mdmObjectInformation = new MdmObjectInformation(xMLFactory);
                    element = (Element)mdmObject.acceptVisitor(mdmObjectInformation, null);
                }
                catch (ClassCastException classCastException) {
                    Object var8_10 = null;
                    return element;
                }
                catch (NullPointerException nullPointerException) {
                    Object var8_11 = null;
                    return element;
                }
                Object var8_9 = null;
                return element;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                return element;
            }
        }

        public Object visitSourceDefinition(SourceDefinition sourceDefinition, Object object) {
            return this.commonDefinition("Source", sourceDefinition, object);
        }

        public Object visitDynamicDefinition(DynamicDefinition dynamicDefinition, Object object) {
            WriterContext writerContext = (WriterContext)object;
            XMLFactory xMLFactory = writerContext.getFactory();
            Element element = xMLFactory.createElement("Dynamic");
            element.appendChild(this.visit(dynamicDefinition.getCurrent(), "Current", writerContext));
            Template template = dynamicDefinition.getTemplate();
            element.appendChild(xMLFactory.createTextElement("Template", template.toString()));
            element.appendChild(xMLFactory.createTextElement("SourceGenerator", dynamicDefinition.getSourceGenerator().toString()));
            return element;
        }

        protected String getJoinComparisonRuleString(JoinDefinition joinDefinition) {
            String string;
            switch (joinDefinition.getComparisonRule()) {
                case 1: {
                    string = "ascending";
                    break;
                }
                case 2: {
                    string = "descending";
                    break;
                }
                case 3: {
                    string = "remove";
                    break;
                }
                case 0: {
                    string = "select";
                    break;
                }
                default: {
                    string = "undefined";
                }
            }
            return string;
        }

        public Object visitJoinDefinition(JoinDefinition joinDefinition, Object object) {
            WriterContext writerContext = (WriterContext)object;
            XMLFactory xMLFactory = writerContext.getFactory();
            boolean bl = joinDefinition.isVisible();
            String string = this.getJoinComparisonRuleString(joinDefinition);
            SourceDefinition sourceDefinition = joinDefinition.getBase();
            SourceDefinition sourceDefinition2 = joinDefinition.getJoined();
            SourceDefinition sourceDefinition3 = joinDefinition.getComparison();
            Element element = xMLFactory.createElement("Join");
            element.setAttributeNode(xMLFactory.createAttribute("visible", bl));
            element.setAttributeNode(xMLFactory.createAttribute("comparisonrule", string));
            Element element2 = this.visit(sourceDefinition, "Base", writerContext);
            element.appendChild(element2);
            element2 = this.visit(sourceDefinition2, "Joined", writerContext);
            element.appendChild(element2);
            element2 = this.visit(sourceDefinition3, "Comparison", writerContext);
            element.appendChild(element2);
            return element;
        }

        public Object visitRangeDefinition(RangeDefinition rangeDefinition, Object object) {
            WriterContext writerContext = (WriterContext)object;
            Element element = writerContext.getFactory().createElement("Range");
            element.appendChild(this.visit(rangeDefinition.getBottom(), "Bottom", writerContext));
            element.appendChild(this.visit(rangeDefinition.getTop(), "Top", writerContext));
            return element;
        }

        public Object visitConstantListDefinition(ConstantListDefinition constantListDefinition, Object object) {
            WriterContext writerContext = (WriterContext)object;
            XMLFactory xMLFactory = writerContext.getFactory();
            Element element = xMLFactory.createElement("ConstantList");
            element.appendChild(this.visit((Collection)constantListDefinition.getElements(), xMLFactory.createElement("Elements"), writerContext));
            return element;
        }

        public Object visitValueDefinition(ValueDefinition valueDefinition, Object object) {
            WriterContext writerContext = (WriterContext)object;
            Element element = writerContext.getFactory().createElement("Value");
            Element element2 = this.visit(valueDefinition.getBase(), "Base", writerContext);
            if (element2 != null) {
                element.appendChild(element2);
            }
            element2 = this.visit(valueDefinition.getInput(), "Input", writerContext);
            element.appendChild(element2);
            return element;
        }

        public Object visitAliasDefinition(AliasDefinition aliasDefinition, Object object) {
            return this.visitSourceDefinitionWithBase("Alias", aliasDefinition, object);
        }

        public Object visitDistinctDefinition(DistinctDefinition distinctDefinition, Object object) {
            return this.visitSourceDefinitionWithBase("Distinct", distinctDefinition, object);
        }

        public Object visitExtractDefinition(ExtractDefinition extractDefinition, Object object) {
            return this.visitSourceDefinitionWithBase("Extract", extractDefinition, object);
        }

        public Object visitPositionDefinition(PositionDefinition positionDefinition, Object object) {
            return this.visitSourceDefinitionWithBase("Position", positionDefinition, object);
        }

        public Object visitHiddenDefinition(HiddenDefinition hiddenDefinition, Object object) {
            WriterContext writerContext = (WriterContext)object;
            if (writerContext.isEmptySource(hiddenDefinition)) {
                return this.getEmptySourceElement(writerContext.getFactory());
            }
            if (writerContext.isFundamental(hiddenDefinition)) {
                return this.getFundamentalElement(hiddenDefinition, writerContext.getFactory());
            }
            return super.visitHiddenDefinition(hiddenDefinition, object);
        }

        protected Class getVisibleClass(Object object) {
            Class<?> clazz;
            for (clazz = object.getClass(); clazz != Object.class && !Modifier.isPublic(clazz.getModifiers()); clazz = clazz.getSuperclass()) {
            }
            return clazz;
        }

        public Element getEmptySourceElement(XMLFactory xMLFactory) {
            return xMLFactory.createElement(EMPTYSOURCE);
        }

        public Element getVoidSourceElement(XMLFactory xMLFactory) {
            return xMLFactory.createElement(VOIDSOURCE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Element getFundamentalElement(SourceDefinition sourceDefinition, XMLFactory xMLFactory) {
            Source source = sourceDefinition.getSource();
            String string = source.getID();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "!_.", false);
            Element element = xMLFactory.createElement("Fundamental");
            try {
                try {
                    Object object = stringTokenizer.nextElement();
                    object = stringTokenizer.nextElement();
                    String string2 = (String)stringTokenizer.nextElement();
                    String string3 = (String)stringTokenizer.nextElement();
                    element.appendChild(xMLFactory.createTextElement("FundamentalType", string2));
                    element.appendChild(xMLFactory.createTextElement("FundamentalName", string3));
                }
                catch (Exception exception) {
                    element.appendChild(xMLFactory.createTextElement("FundamentalText", string));
                    Object var11_12 = null;
                    return element;
                }
                Object var11_11 = null;
                return element;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                return element;
            }
        }

        private class MdmObjectInformation
        extends MdmBaseObjectVisitor {
            private XMLFactory factory = null;

            public MdmObjectInformation(XMLFactory xMLFactory) {
                this.factory = xMLFactory;
            }

            private Element visit(MdmObject mdmObject) {
                return (Element)mdmObject.acceptVisitor(this, null);
            }

            protected String _createTag(Object object, String string) {
                return object == null ? string : (String)object;
            }

            public Object visitMdmObject(MdmObject mdmObject, Object object) {
                Element element = this.factory.createElement(this._createTag(object, "MdmObject"));
                element.setAttributeNode(this.factory.createAttribute("name", mdmObject.getName()));
                element.setAttributeNode(this.factory.createAttribute("deleted", mdmObject.isDeleted()));
                return element;
            }

            public Object visitMdmListDimension(MdmListDimension mdmListDimension, Object object) {
                return super.visitMdmListDimension(mdmListDimension, "MdmListDimension");
            }

            public Object visitMdmHierarchy(MdmHierarchy mdmHierarchy, Object object) {
                Element element = (Element)super.visitMdmHierarchy(mdmHierarchy, this._createTag(object, "MdmHierarchy"));
                int n = mdmHierarchy.getHierarchyType();
                String string = null;
                switch (n) {
                    case 2: {
                        string = "level_hierarchy";
                        break;
                    }
                    case 1: {
                        string = "union_hierarchy";
                        break;
                    }
                    case 3: {
                        string = "value_hierarchy";
                        break;
                    }
                    default: {
                        string = "unknown";
                    }
                }
                element.setAttributeNode(this.factory.createAttribute("type", string));
                return element;
            }

            public Object visitMdmLevel(MdmLevel mdmLevel, Object object) {
                Element element = (Element)super.visitMdmLevel(mdmLevel, this._createTag(object, "MdmLevel"));
                return element;
            }
        }
    }
}

