/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.WeakHashMap;
import oracle.express.idl.util.InterfaceStub;
import oracle.express.idl.util.XMLWriter;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.express.olapi.data.full.SourceConverter;
import oracle.express.olapi.data.full.SourceToXMLConverter;
import oracle.olapi.data.source.ExpressionDefinition;
import oracle.olapi.data.source.Parameter;
import oracle.olapi.data.source.ParameterizedSourceDefinition;
import oracle.olapi.metadata.MetadataToServerXMLConverter;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.transaction.BaseTransaction;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionalObject;

public final class SourceToXMLConverterSince10105
extends SourceToXMLConverter {
    private MetadataToServerXMLConverter m_MetadataToXMLConverter = null;
    private SourceToXMLConverterSince10105 m_Parent = null;
    private List m_DefinitionQueue = new ArrayList(100);
    private WeakHashMap m_SentMap = new WeakHashMap(200);
    private WeakHashMap m_AboutToSendMap = new WeakHashMap(50);
    private boolean m_SentDefinitionManagerLineage = false;

    public SourceToXMLConverterSince10105(DefinitionManager definitionManager) {
        super(definitionManager);
        DefinitionManager definitionManager2 = this.getParentDefinitionManager(definitionManager);
        if (null != definitionManager2) {
            this.m_Parent = (SourceToXMLConverterSince10105)definitionManager2.getSourceConverter();
        }
        MetadataToServerXMLConverter metadataToServerXMLConverter = null;
        if (null != this.getParent()) {
            metadataToServerXMLConverter = (MetadataToServerXMLConverter)this.getParent().getMetadataToXMLConverter();
        }
        this.m_MetadataToXMLConverter = new MetadataToServerXMLConverter(definitionManager.getDataProvider(), metadataToServerXMLConverter);
    }

    private final SourceToXMLConverterSince10105 getParent() {
        return this.m_Parent;
    }

    public final MetadataToXMLConverter getMetadataToXMLConverter() {
        return this.m_MetadataToXMLConverter;
    }

    private DefinitionManager getParentDefinitionManager(DefinitionManager definitionManager) {
        BaseTransaction baseTransaction = (BaseTransaction)definitionManager.getTransaction().getParent();
        if (null == baseTransaction) {
            return null;
        }
        return baseTransaction.findOrCreateDefinitionManager(this.getDefinitionManager().getDataProvider());
    }

    private final Object getLastSentState(TransactionalObject transactionalObject) {
        Object object = this.m_AboutToSendMap.get(transactionalObject);
        if (null == object) {
            object = this.m_SentMap.get(transactionalObject);
        }
        if (null == object && null != this.getParent()) {
            object = this.getParent().getLastSentState(transactionalObject);
        }
        return object;
    }

    protected final boolean needToSend(TransactionalObject transactionalObject) {
        Object object = this.getLastSentState(transactionalObject);
        if (null == object) {
            return true;
        }
        return !object.equals(transactionalObject.getTransactionalState(this.getTransaction()));
    }

    private SourceToXMLConverterSince10105 getConverterForTransaction(Transaction transaction) {
        BaseTransaction baseTransaction = (BaseTransaction)transaction;
        if (null != baseTransaction) {
            baseTransaction = baseTransaction.getUserTransaction();
        }
        if (baseTransaction == this.getDefinitionManager().getTransaction()) {
            return this;
        }
        if (null != this.getParent()) {
            return this.getParent().getConverterForTransaction(baseTransaction);
        }
        return this;
    }

    private void localAddToQueue(TransactionalObject transactionalObject) {
        this.m_DefinitionQueue.add(transactionalObject);
        this.m_AboutToSendMap.put(transactionalObject, transactionalObject.getTransactionalState(this.getTransaction()));
    }

    protected final void queueForSending(TransactionalObject transactionalObject) {
        if (transactionalObject instanceof ParameterizedSourceDefinition) {
            ParameterizedSourceDefinition parameterizedSourceDefinition = (ParameterizedSourceDefinition)transactionalObject;
            SourceToXMLConverterSince10105 sourceToXMLConverterSince10105 = this.getConverterForTransaction(parameterizedSourceDefinition.getActiveTransaction());
            sourceToXMLConverterSince10105.localAddToQueue(parameterizedSourceDefinition);
            sourceToXMLConverterSince10105.localAddToQueue(parameterizedSourceDefinition.getParameter());
        } else if (!(transactionalObject instanceof Parameter)) {
            SourceToXMLConverterSince10105 sourceToXMLConverterSince10105 = this.getConverterForTransaction(transactionalObject.getActiveTransaction());
            sourceToXMLConverterSince10105.localAddToQueue(transactionalObject);
        }
    }

    protected void localReset() {
        super.localReset();
        this.m_DefinitionQueue.clear();
        this.m_AboutToSendMap.clear();
        this.getMetadataToXMLConverter().resetState();
        if (null != this.getParent()) {
            this.getParent().localReset();
        }
    }

    protected final void recover() {
        this.m_AboutToSendMap.clear();
        this.m_SentDefinitionManagerLineage = false;
        if (null != this.getParent()) {
            this.getParent().recover();
        }
    }

    protected final void success() {
        this.m_SentMap.putAll(this.m_AboutToSendMap);
        this.m_AboutToSendMap.clear();
        if (null != this.getParent()) {
            this.getParent().success();
        }
    }

    protected void mergeChildTransactionOnCommit(SourceConverter sourceConverter) {
        SourceToXMLConverterSince10105 sourceToXMLConverterSince10105 = (SourceToXMLConverterSince10105)sourceConverter;
        this.m_SentMap.putAll(sourceToXMLConverterSince10105.m_SentMap);
        this.setNeedToRespecifyCursorManagers(true);
    }

    public final XMLWriter finishup(InterfaceStub interfaceStub, Properties properties) {
        XMLWriter xMLWriter = new XMLWriter(interfaceStub, "<?xml version=\"1.0\" encoding=\"UTF-16\"?>");
        XMLWriter xMLWriter2 = this.getWriter();
        this.setWriter(xMLWriter);
        xMLWriter.beginElement("ClientData");
        if (null != properties) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                xMLWriter.appendAttribute(string, string2);
            }
        }
        xMLWriter.closeTag();
        this.generateXMLForSelfAndParents(xMLWriter, this);
        if (null != this.getMethodArguments()) {
            this.getMethodArguments().writeXML(xMLWriter);
        }
        xMLWriter.endElement("ClientData");
        this.setNeedToRespecifyCursorManagers(false);
        this.setWriter(xMLWriter2);
        return xMLWriter;
    }

    private void generateXMLForSourceDefinitions(SourceToXMLConverterSince10105 sourceToXMLConverterSince10105) {
        if (this.m_DefinitionQueue.isEmpty() && this != sourceToXMLConverterSince10105) {
            return;
        }
        this.beginElement("SourceDefinitions");
        this.closeTag();
        for (Object object : this.m_DefinitionQueue) {
            this.writeXML(object);
        }
        this.m_DefinitionQueue.clear();
        if (this == sourceToXMLConverterSince10105) {
            for (SourceToXMLConverter.CursorManagerInfo cursorManagerInfo : this.getCursorManagerInfoList()) {
                this.beginElement("RootSource");
                this.appendAttribute("ID", cursorManagerInfo.m_RootDefinition);
                this.endElement("RootSource", true);
                if (!this.needToSendDefinitions()) continue;
                for (int i = 0; i < cursorManagerInfo.m_InputSources.length; ++i) {
                    this.beginElement("InputSource");
                    this.appendAttribute("ID", cursorManagerInfo.m_InputSources[i].getDefinition());
                    this.endElement("InputSource", true);
                }
            }
        }
        this.endElement("SourceDefinitions", false);
    }

    private void generateXMLForCursorManagers(DefinitionManager definitionManager) {
        if (definitionManager.getTransaction() != this.getTransaction()) {
            return;
        }
        for (SourceToXMLConverter.CursorManagerInfo cursorManagerInfo : this.getCursorManagerInfoList()) {
            this.beginElement("RootSource");
            this.appendAttribute("ID", cursorManagerInfo.m_RootDefinition);
            this.endElement("RootSource", true);
            if (!this.needToSendDefinitions()) continue;
            for (int i = 0; i < cursorManagerInfo.m_InputSources.length; ++i) {
                this.beginElement("InputSource");
                this.appendAttribute("ID", cursorManagerInfo.m_InputSources[i].getDefinition());
                this.endElement("InputSource", true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateXMLForSelfAndParents(XMLWriter xMLWriter, SourceToXMLConverterSince10105 sourceToXMLConverterSince10105) {
        if (null != this.getParent()) {
            this.getParent().generateXMLForSelfAndParents(xMLWriter, sourceToXMLConverterSince10105);
        }
        if (this != sourceToXMLConverterSince10105 && (null == this.m_DefinitionQueue || this.m_DefinitionQueue.isEmpty()) && this.m_SentDefinitionManagerLineage) {
            return;
        }
        XMLWriter xMLWriter2 = this.getWriter();
        this.setWriter(xMLWriter);
        try {
            xMLWriter.beginElement("DefinitionManager");
            xMLWriter.appendAttribute("ID", String.valueOf(this.getDefinitionManager().getDefinitionManagerID()));
            if (null != this.getParent()) {
                xMLWriter.appendAttribute("ParentID", String.valueOf(this.getParent().getDefinitionManager().getDefinitionManagerID()));
            }
            xMLWriter.closeTag();
            this.m_SentDefinitionManagerLineage = true;
            this.getMetadataToXMLConverter().generateXML(xMLWriter);
            this.generateXMLForSourceDefinitions(sourceToXMLConverterSince10105);
            xMLWriter.endElement("DefinitionManager");
            xMLWriter.newLine();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setWriter(xMLWriter2);
            throw throwable;
        }
        this.setWriter(xMLWriter2);
    }

    final void handleCommitRoot() {
        if (this.getServerVersion().flushesSourceDefinitionsOnRootCommit()) {
            this.m_SentMap.clear();
            this.m_AboutToSendMap.clear();
            this.m_SentDefinitionManagerLineage = false;
        }
    }

    public Object visitExpressionDefinition(ExpressionDefinition expressionDefinition, Object object) {
        this.beginElement("ExpressionDef");
        this.appendAttribute("ID", expressionDefinition);
        this.appendAttribute("Expression", expressionDefinition.getExpression().toSyntax());
        this.endElement("ExpressionDef", true);
        return null;
    }
}

