/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import oracle.express.idl.util.OlapiExceptionHelper;
import oracle.express.idl.util.OlapiTracer;
import oracle.express.olapi.transaction.ExpressTransactionProvider;
import oracle.jdbc.OracleConnection;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.session.UserSession;
import oracle.olapi.transaction.BaseTransactionProvider;
import oracle.olapi.transaction.TransactionProvider;

public class ExpressDataProvider
extends DataProvider {
    private OracleConnection _init_connection = null;

    public ExpressDataProvider(OracleConnection oracleConnection, TransactionProvider transactionProvider, Locale locale, Properties properties) {
        super((BaseTransactionProvider)transactionProvider, locale, properties);
        this.setInitialConnection(oracleConnection);
        OlapiTracer.init();
    }

    public ExpressDataProvider(OracleConnection oracleConnection, TransactionProvider transactionProvider) {
        this(oracleConnection, transactionProvider, (Locale)null);
    }

    public ExpressDataProvider(OracleConnection oracleConnection, TransactionProvider transactionProvider, Locale locale) {
        this(oracleConnection, transactionProvider, locale, new Properties());
    }

    public ExpressDataProvider(OracleConnection oracleConnection, TransactionProvider transactionProvider, Properties properties) {
        this(oracleConnection, transactionProvider, null, properties);
    }

    private void setInitialConnection(OracleConnection oracleConnection) {
        this._init_connection = oracleConnection;
    }

    private OracleConnection getInitialConnection() {
        return this._init_connection;
    }

    public void initialize() throws SQLException {
        if (null == this.getInitialConnection()) {
            return;
        }
        UserSession userSession = this.initializeSession(this.getInitialConnection(), this.getDefaultProperties(), this.getDefaultLocale());
        this.setInitialConnection(null);
        if (!this.isServerVersionLaterThan(new int[]{9, 2, 0, 7, 0})) {
            userSession.closeSession();
            throw OlapiExceptionHelper.newInstance("UNSUPPORTED_SERVER", this.getDefaultLocale(), null);
        }
        ((ExpressTransactionProvider)this.getTransactionProvider()).initializeFirstSession(userSession);
    }

    public void _close() {
        super.close();
        this.setInitialConnection(null);
    }
}

