/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data.full;

import java.util.List;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorManagerInterface;
import oracle.express.idl.ExpressOlapiDataCursorModule.CursorSpecifierStruct;
import oracle.express.olapi.data.CursorFactory;
import oracle.express.olapi.data.full.DataCursorManager;
import oracle.express.olapi.data.full.DefinitionManager;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.cursor.Cursor;
import oracle.olapi.data.cursor.CursorInput;
import oracle.olapi.data.cursor.SpecificationUpdateNeededException;
import oracle.olapi.data.source.CursorInfoSpecification;
import oracle.olapi.data.source.CursorSpecification;
import oracle.olapi.data.source.Parameter;
import oracle.olapi.data.source.Source;

public class ExpressDataCursorManager
extends DataCursorManager {
    private int m_FetchSize = -1;
    private CursorInfoSpecification m_CursorInfoSpec = null;

    ExpressDataCursorManager(Source source, int n, CursorInfoSpecification cursorInfoSpecification, CursorManagerInterface cursorManagerInterface, long l, DefinitionManager definitionManager, List list) {
        super(source, cursorManagerInterface, l, definitionManager, list);
        this.setNeedsSpecificationUpdate(false);
        this.setCursorInfoSpecification(cursorInfoSpecification);
        this.setFetchSize(n);
    }

    private void setCursorInfoSpecification(CursorInfoSpecification cursorInfoSpecification) {
        this.m_CursorInfoSpec = cursorInfoSpecification;
    }

    CursorInfoSpecification getCursorInfoSpecification() {
        return this.m_CursorInfoSpec;
    }

    public final synchronized Cursor createCursor() throws SpecificationUpdateNeededException {
        Parameter[] parameterArray;
        this.commitIncrementalTransaction();
        if (this.isSpecificationUpdateNeeded()) {
            if (null != this.getCursorInfoSpecification()) {
                this.updateSpecification(this.getCursorInfoSpecification());
            } else {
                throw new SpecificationUpdateNeededException();
            }
        }
        if (!this.isPreparedForOpenCursor()) {
            parameterArray = null;
            try {
                parameterArray = (CursorSpecification)this.getCursorInfoSpecification();
            }
            catch (ClassCastException classCastException) {
                throw new UnsupportedOperationException();
            }
            this.prepareForOpenCursor((CursorSpecification)parameterArray, null);
        }
        parameterArray = new Parameter[this.getParameters().size()];
        this.getParameters().toArray(parameterArray);
        return CursorFactory.createCursor(this.getRootCursorStructure(), this.getNumCursorStructures(), this.getCursorBlockManager(), parameterArray);
    }

    public final void updateSpecification(CursorInfoSpecification cursorInfoSpecification) throws IllegalArgumentException {
        this.setCursorInfoSpecification(cursorInfoSpecification);
        CursorSpecifierStruct[] cursorSpecifierStructArray = DefinitionManager.convertCursorInfoSpecification(this.getFetchSize(), cursorInfoSpecification);
        this.updateSpecification(cursorSpecifierStructArray);
    }

    public final int getFetchSize() {
        return this.m_FetchSize;
    }

    public final void setFetchSize(int n) {
        this.m_FetchSize = n;
    }

    public final Cursor createCursor(CursorInput[] cursorInputArray) {
        throw new UnsupportedOperationException();
    }
}

