/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.aw;

import java.util.Date;
import oracle.express.aw.AWExpressionGenerator;
import oracle.express.aw.AWMetadataLookup;
import oracle.express.aw.AWSourceExpressionFactory;
import oracle.olapi.data.source.AliasDefinition;
import oracle.olapi.data.source.ConstantListDefinition;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.DynamicDefinition;
import oracle.olapi.data.source.HiddenDefinition;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.ValueDefinition;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmSourceDefinition;
import oracle.olapi.metadata.mtm.MtmAWColumnExpression;
import oracle.olapi.metadata.mtm.MtmAWView;
import oracle.olapi.metadata.mtm.MtmAttributeMap;
import oracle.olapi.metadata.mtm.MtmBaseCube;
import oracle.olapi.metadata.mtm.MtmColumnExpression;
import oracle.olapi.metadata.mtm.MtmCube;
import oracle.olapi.metadata.mtm.MtmMeasureMap;
import oracle.olapi.metadata.mtm.MtmObject;
import oracle.olapi.metadata.mtm.MtmPartitionedCube;
import oracle.olapi.metadata.mtm.MtmSolvedCube;
import oracle.olapi.metadata.mtm.MtmTabularSource;
import oracle.olapi.metadata.mtm.MtmValueExpression;

final class AWExpressionInfo
extends DataDescriptorDefinitionVisitor {
    private MtmObject m_MtmObject = null;
    private boolean m_InvalidSource = false;
    private boolean m_Dynamic = false;
    private String m_RowToCellColumnName = null;
    private String[] m_Expressions = null;
    private int m_CurrentArg = 0;
    private AWSourceExpressionFactory m_Factory = null;

    public AWExpressionInfo(int n, AWSourceExpressionFactory aWSourceExpressionFactory) {
        this.m_Expressions = new String[n];
        this.m_Factory = aWSourceExpressionFactory;
    }

    public MtmObject getMtmObject() {
        return this.m_MtmObject;
    }

    public String getExpression(int n) {
        return this.m_Expressions[n];
    }

    public String getRowToCellColumnName() {
        return this.m_RowToCellColumnName;
    }

    public boolean isDynamic() {
        return this.m_Dynamic;
    }

    public boolean isValid() {
        if (this.isInvalidSource()) {
            return false;
        }
        return null != this.getRowToCellColumnName();
    }

    public AWSourceExpressionFactory getFactory() {
        return this.m_Factory;
    }

    public void addExpressionForSource(Source source) {
        if (this.isInvalidSource()) {
            return;
        }
        this.setInvalidSource(true);
        source.getDefinition().acceptVisitor(this, null);
    }

    private void setMtmObject(MtmObject mtmObject) {
        this.m_MtmObject = mtmObject;
    }

    private void setCurrentExpression(String string) {
        this.m_Expressions[this.m_CurrentArg] = string;
        ++this.m_CurrentArg;
    }

    private void setRowToCellColumnName(String string) {
        this.m_RowToCellColumnName = string;
    }

    private void setDynamic(boolean bl) {
        this.m_Dynamic = bl;
    }

    private boolean isInvalidSource() {
        return this.m_InvalidSource;
    }

    private void setInvalidSource(boolean bl) {
        this.m_InvalidSource = bl;
    }

    public Object visitConstantListDefinition(ConstantListDefinition constantListDefinition, Object object) {
        if (constantListDefinition.getElements().size() != 1) {
            return null;
        }
        Object e = constantListDefinition.getElements().get(0);
        if (e instanceof Source) {
            return null;
        }
        AWExpressionGenerator aWExpressionGenerator = this.getFactory().getExpressionGenerator();
        String string = null;
        if (e instanceof String) {
            string = aWExpressionGenerator.generateConstantExpression((String)e);
        }
        if (e instanceof Double) {
            string = aWExpressionGenerator.generateConstantExpression((Double)e);
        }
        if (e instanceof Float) {
            string = aWExpressionGenerator.generateConstantExpression(((Float)e).floatValue());
        }
        if (e instanceof Integer) {
            string = aWExpressionGenerator.generateConstantExpression((Integer)e);
        }
        if (e instanceof Short) {
            string = aWExpressionGenerator.generateConstantExpression((Short)e);
        }
        if (e instanceof Long) {
            string = aWExpressionGenerator.generateConstantExpression((Long)e);
        }
        if (e instanceof Long) {
            string = aWExpressionGenerator.generateConstantExpression((Long)e);
        }
        if (e instanceof Date) {
            string = aWExpressionGenerator.generateConstantExpression((Date)e);
        }
        this.setCurrentExpression(string);
        this.setInvalidSource(false);
        return null;
    }

    public Object visitHiddenDefinition(HiddenDefinition hiddenDefinition, Object object) {
        AWMetadataLookup aWMetadataLookup = this.getFactory().getAWMetadataLookup();
        MdmSourceDefinition mdmSourceDefinition = (MdmSourceDefinition)hiddenDefinition;
        if (mdmSourceDefinition.getMdmSource() instanceof MdmMeasure) {
            MdmMeasure mdmMeasure = (MdmMeasure)mdmSourceDefinition.getMdmSource();
            MtmMeasureMap mtmMeasureMap = mdmMeasure.getMeasureMap();
            MtmCube mtmCube = mtmMeasureMap.getCube();
            if (!(mtmCube instanceof MtmPartitionedCube)) {
                return null;
            }
            MtmPartitionedCube mtmPartitionedCube = (MtmPartitionedCube)mtmCube;
            if (null != this.getMtmObject() && mtmCube != this.getMtmObject()) {
                return null;
            }
            this.setMtmObject(mtmCube);
            String string = null;
            String string2 = null;
            for (MtmBaseCube mtmBaseCube : mtmPartitionedCube.getBaseCubes()) {
                if (!(mtmBaseCube instanceof MtmSolvedCube)) {
                    return null;
                }
                MtmSolvedCube mtmSolvedCube = (MtmSolvedCube)mtmBaseCube;
                MtmTabularSource mtmTabularSource = mtmSolvedCube.getTable();
                if (!(mtmTabularSource instanceof MtmAWView)) {
                    return null;
                }
                MtmAWView mtmAWView = (MtmAWView)mtmTabularSource;
                MtmColumnExpression mtmColumnExpression = mtmAWView.getRowToCellExpression();
                if (null == mtmColumnExpression) {
                    return null;
                }
                MtmValueExpression mtmValueExpression = mtmMeasureMap.getMappedExpression(mtmBaseCube);
                if (!(mtmValueExpression instanceof MtmColumnExpression)) {
                    return null;
                }
                MtmColumnExpression mtmColumnExpression2 = (MtmColumnExpression)mtmValueExpression;
                if (null == mtmColumnExpression2) {
                    return null;
                }
                MtmAWColumnExpression mtmAWColumnExpression = (MtmAWColumnExpression)mtmColumnExpression2;
                if (null == mtmAWColumnExpression) {
                    return null;
                }
                String string3 = mtmColumnExpression2.getColumnName();
                String string4 = mtmAWView.getName();
                String string5 = mtmAWColumnExpression.getAWObjectName();
                if (null == string5) {
                    string5 = aWMetadataLookup.getAWObjectName(string4, string3);
                }
                if (null == string5) {
                    return null;
                }
                if (null == string) {
                    string = string5;
                    string2 = mtmColumnExpression.getColumnName();
                    if (null == this.getRowToCellColumnName() || string2 == this.getRowToCellColumnName()) continue;
                    return null;
                }
                if (!string.equals(string5)) {
                    return null;
                }
                if (string2.equals(mtmColumnExpression.getColumnName())) continue;
                return null;
            }
            this.setCurrentExpression(string);
            this.setRowToCellColumnName(string2);
            this.setInvalidSource(false);
            return null;
        }
        if (mdmSourceDefinition.getMdmSource() instanceof MdmAttribute) {
            MdmAttribute mdmAttribute = (MdmAttribute)mdmSourceDefinition.getMdmSource();
            MtmAttributeMap mtmAttributeMap = mdmAttribute.getAttributeMap();
            return null;
        }
        return null;
    }

    public Object visitDynamicDefinition(DynamicDefinition dynamicDefinition, Object object) {
        this.setDynamic(true);
        return dynamicDefinition.getCurrent().acceptVisitor(this, object);
    }

    public Object visitAliasDefinition(AliasDefinition aliasDefinition, Object object) {
        return aliasDefinition.getBase().acceptVisitor(this, object);
    }

    public Object visitValueDefinition(ValueDefinition valueDefinition, Object object) {
        return null;
    }

    public Object visitSourceDefinition(SourceDefinition sourceDefinition, Object object) {
        return null;
    }
}

