/*
 * Decompiled with CFR 0.152.
 */
package oracle.express;

import java.io.Serializable;
import java.util.Locale;
import oracle.express.idl.ExpressModule.DomainEnum;
import oracle.express.idl.ExpressModule.ErrorDescriptionStruct;
import oracle.express.idl.ExpressModule.ErrorTypeEnum;
import oracle.olapi.HasLocalizedMessage;
import oracle.olapi.OLAPIRuntimeException;

public class ErrorDescription
implements HasLocalizedMessage,
Serializable {
    private static final int _DOMAIN_FIRST = 0;
    public static final int DOMAIN_ENG = 0;
    public static final int DOMAIN_MDP = 1;
    public static final int DOMAIN_OES = 2;
    public static final int DOMAIN_ECM = 3;
    public static final int DOMAIN_DPR = 4;
    public static final int DOMAIN_TRN = 5;
    public static final int DOMAIN_DEF = 6;
    public static final int DOMAIN_CUR = 7;
    public static final int DOMAIN_SPL = 8;
    public static final int DOMAIN_CTL = 9;
    public static final int DOMAIN_INI = 10;
    public static final int DOMAIN_SCO = 11;
    public static final int DOMAIN_INT = 12;
    public static final int DOMAIN_SEL = 13;
    public static final int DOMAIN_EXP = 14;
    private static final int _DOMAIN_LAST = 14;
    private static final int _ERROR_TYPE_FIRST = 0;
    public static final int ERROR_TYPE_GENERIC = 0;
    public static final int ERROR_TYPE_NULL_STATUS = 1;
    private static final int _ERROR_TYPE_LAST = 1;
    ErrorDescriptionStruct _errorDescriptionStruct;

    ErrorDescription(ErrorDescriptionStruct errorDescriptionStruct) {
        this._errorDescriptionStruct = errorDescriptionStruct;
    }

    public final String getMessage() {
        return this._errorDescriptionStruct.message;
    }

    public final String getSource() {
        return this._errorDescriptionStruct.source;
    }

    public final int getDomain() {
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.ENG)) {
            return 0;
        }
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.MDP)) {
            return 1;
        }
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.OES)) {
            return 2;
        }
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.ECM)) {
            return 3;
        }
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.DPR)) {
            return 4;
        }
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.TRN)) {
            return 5;
        }
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.DEF)) {
            return 6;
        }
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.CUR)) {
            return 7;
        }
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.SPL)) {
            return 8;
        }
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.CTL)) {
            return 9;
        }
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.INI)) {
            return 10;
        }
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.SCO)) {
            return 11;
        }
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.ITR)) {
            return 12;
        }
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.SEL)) {
            return 13;
        }
        if (this._errorDescriptionStruct.domain.equals(DomainEnum.EXP)) {
            return 14;
        }
        return -1;
    }

    public final int getErrorType() {
        if (this._errorDescriptionStruct.errorType.equals(ErrorTypeEnum.GENERIC)) {
            return 0;
        }
        if (this._errorDescriptionStruct.errorType.equals(ErrorTypeEnum.NULL_STATUS)) {
            return 1;
        }
        return -1;
    }

    public String getLocalizedMessage(Locale locale) {
        Object[] objectArray = new Object[]{ErrorDescription._domainToString(this.getDomain(), locale), this.getMessage(), ErrorDescription._errorTypeToString(this.getErrorType(), locale), this.getSource()};
        return ErrorDescription.getMessage("ErrorDescription", objectArray, locale);
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public final String toString() {
        return this.getLocalizedMessage();
    }

    private static final String _domainToString(int n, Locale locale) {
        switch (n) {
            case 0: {
                return ErrorDescription.getMessage("ENG", locale);
            }
            case 1: {
                return ErrorDescription.getMessage("MDP", locale);
            }
            case 2: {
                return ErrorDescription.getMessage("OES", locale);
            }
            case 3: {
                return ErrorDescription.getMessage("ECM", locale);
            }
            case 4: {
                return ErrorDescription.getMessage("DPR", locale);
            }
            case 5: {
                return ErrorDescription.getMessage("TRN", locale);
            }
            case 6: {
                return ErrorDescription.getMessage("DEF", locale);
            }
            case 7: {
                return ErrorDescription.getMessage("CUR", locale);
            }
            case 8: {
                return ErrorDescription.getMessage("SPL", locale);
            }
            case 9: {
                return ErrorDescription.getMessage("CTL", locale);
            }
            case 10: {
                return ErrorDescription.getMessage("INI", locale);
            }
            case 11: {
                return ErrorDescription.getMessage("SCO", locale);
            }
            case 12: {
                return ErrorDescription.getMessage("INT", locale);
            }
            case 13: {
                return ErrorDescription.getMessage("SEL", locale);
            }
            case 14: {
                return ErrorDescription.getMessage("EXP", locale);
            }
        }
        return null;
    }

    private static final String _errorTypeToString(int n, Locale locale) {
        switch (n) {
            case 0: {
                return ErrorDescription.getMessage("Generic", locale);
            }
            case 1: {
                return ErrorDescription.getMessage("NullStatus", locale);
            }
        }
        return null;
    }

    private static final String getMessage(String string, Locale locale) {
        return ErrorDescription.getMessage(string, new Object[0], locale);
    }

    private static final String getMessage(String string, Object[] objectArray, Locale locale) {
        return OLAPIRuntimeException.getMessage(string, objectArray, locale);
    }
}

