/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.io;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;

public class CompositeReader
extends Reader {
    private Vector _readers = new Vector();
    private int _currentReader = -1;

    public CompositeReader() {
    }

    public CompositeReader(Reader reader) {
        this.appendReader(reader);
    }

    public void appendReader(Reader reader) {
        if (reader != null) {
            this._readers.addElement(reader);
            if (this._currentReader == -1) {
                this._currentReader = 0;
            }
        } else {
            throw new IllegalArgumentException("Cannot append a null Reader");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this._currentReader > -1) {
                Reader reader = (Reader)this._readers.elementAt(this._currentReader);
                return reader.ready();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllReaders() {
        Object object = this.lock;
        synchronized (object) {
            this._readers.removeAllElements();
            this._currentReader = -1;
        }
    }

    public int read() throws IOException {
        return super.read();
    }

    public int read(char[] cArray) throws IOException {
        return super.read(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3 = 0;
            int n4 = n;
            int n5 = 0;
            boolean bl = false;
            if (this._currentReader == -1) {
                return -1;
            }
            while (n5 < n2 && !bl) {
                Reader reader = (Reader)this._readers.elementAt(this._currentReader);
                n3 = reader.read(cArray, n4, n2 - n5);
                if (n3 == -1) {
                    ++this._currentReader;
                    if (this._currentReader != this._readers.size()) continue;
                    --this._currentReader;
                    bl = true;
                    continue;
                }
                n4 += n3;
                n5 += n3;
            }
            if (n5 == 0) {
                return -1;
            }
            return n5;
        }
    }

    public long skip(long l) throws IOException {
        return super.skip(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Exception exception = null;
            if (this._currentReader != -1) {
                this._currentReader = 0;
            }
            for (int i = 0; i < this._readers.size(); ++i) {
                Reader reader = (Reader)this._readers.elementAt(i);
                try {
                    reader.reset();
                    continue;
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
            }
            if (exception != null) {
                throw new IOException("CompositeReader unable to reset all readers: " + exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Exception exception = null;
            for (int i = 0; i < this._readers.size(); ++i) {
                Reader reader = (Reader)this._readers.elementAt(i);
                try {
                    reader.close();
                    continue;
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
            }
            if (exception != null) {
                throw new IOException("CompositeReader unable to close all readers: " + exception.toString());
            }
        }
    }
}

