/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.identitymanagement;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Hashtable;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.identitymanagement.AttributeFilter;
import oracle.adf.share.security.identitymanagement.Role;
import oracle.adf.share.security.identitymanagement.spi.IdentityManagement;

public class RoleManager {
    private IdentityManagement identityManagementProvider = null;

    public RoleManager() {
        this((String)null);
    }

    public RoleManager(String providerClassName) {
        if (providerClassName != null) {
            IdentityManagement provider = (IdentityManagement)RoleManager.createObject(providerClassName);
            this.setIdentityManagementProvider(provider);
        } else {
            String clzName = ADFSecurityUtil.getIdentityManagementProviderClassName();
            if (clzName != null) {
                IdentityManagement provider = (IdentityManagement)RoleManager.createObject(clzName);
                this.setIdentityManagementProvider(provider);
            } else {
                throw new ADFSecurityRuntimeException(ADFSecurityUtil.getMessage("EXC_FAILED_ID_STORE"));
            }
        }
    }

    public RoleManager(Hashtable env) {
        IdentityManagement provider = null;
        if (env != null) {
            String providerClassName;
            String namedContext = (String)env.get("named.adf.context");
            if (namedContext == null) {
                namedContext = "default";
            }
            if ((providerClassName = (String)env.get("oracle.adf.security.identity.provider")) == null) {
                providerClassName = "oracle.adf.share.security.providers.jps.IgfIdentityManagementProvider";
            }
            try {
                Class cls = ClassUtils.forName((String)providerClassName, RoleManager.class);
                Constructor ctor = cls.getConstructor(String.class);
                provider = (IdentityManagement)ctor.newInstance(namedContext);
            }
            catch (Exception ex) {
                throw new ADFSecurityRuntimeException(ADFSecurityUtil.getMessage("EXC_FAILED_ID_STORE"));
            }
        } else {
            provider = (IdentityManagement)RoleManager.createObject("oracle.adf.share.security.providers.jps.IgfIdentityManagementProvider");
        }
        this.setIdentityManagementProvider(provider);
    }

    private void setIdentityManagementProvider(IdentityManagement provider) {
        this.identityManagementProvider = provider;
    }

    private static Object createObject(String className) {
        Object object = null;
        try {
            Class classDefinition = ClassUtils.forName((String)className, RoleManager.class);
            object = classDefinition.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public Role createRole() {
        return this.identityManagementProvider.createRole();
    }

    public Principal addRole(Role role) {
        if (!this.identityManagementProvider.isAddRoleSupported()) {
            throw new ADFSecurityRuntimeException(ADFSecurityUtil.getMessage("EXC_UNSUPPORTED_ID_STORE_OPERATION"));
        }
        return this.identityManagementProvider.addRole(role);
    }

    public void modifyRole(Principal roleRef, Role roleDef) {
        throw new ADFSecurityRuntimeException(ADFSecurityUtil.getMessage("EXC_UNSUPPORTED_ID_STORE_OPERATION"));
    }

    public void deleteRole(Principal rolePrincipal) {
        if (!this.identityManagementProvider.isDeleteRoleSupported()) {
            throw new ADFSecurityRuntimeException(ADFSecurityUtil.getMessage("EXC_UNSUPPORTED_ID_STORE_OPERATION"));
        }
        this.identityManagementProvider.deleteRole(rolePrincipal);
    }

    public Role getRole(Principal rolePrincipal) {
        return this.identityManagementProvider.getRole(rolePrincipal);
    }

    public Principal getPrincipal(String roleName) {
        return this.identityManagementProvider.getRolePrincipal(roleName);
    }

    public void deleteFromRole(Principal role, Principal member) {
        this.identityManagementProvider.deleteFromRole(role, member);
    }

    public void addToRole(Principal role, Principal member) {
        this.identityManagementProvider.addToRole(role, member);
    }

    public ArrayList getRoleList(int sizeLimit, AttributeFilter[] filter) {
        return this.identityManagementProvider.getRoleList(sizeLimit, filter);
    }

    public String getAnonymousRoleName() {
        return this.identityManagementProvider.getAnonymousRoleName();
    }

    public Principal getAnonymousRole() {
        return this.identityManagementProvider.getAnonymousRole();
    }

    public boolean isAddRoleSupported() {
        return this.identityManagementProvider.isAddRoleSupported();
    }

    public boolean isModifyRoleSupported() {
        return false;
    }

    public boolean isDeleteRoleSupported() {
        return this.identityManagementProvider.isDeleteRoleSupported();
    }
}

