/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.credentialstore;

import java.io.Serializable;
import java.security.Principal;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.CredentialNotFoundException;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.credentialstore.CredentialStoreContext;
import oracle.adf.share.security.credentialstore.spi.CredentialProvisioning;
import oracle.adf.share.security.credentialstore.spi.CredentialProvisioning2;

public class CredentialProvisioner {
    CredentialStoreContext _credentialStoreCtx = CredentialStoreContext.getInstance();
    CredentialProvisioning _provisioning = null;
    static final ADFLogger sLogger = ADFSecurityUtil.getADFLogger();
    static final String CLASS_NAME = CredentialProvisioner.class.getName();

    public CredentialProvisioner() {
        this._provisioning = this._credentialStoreCtx.getDefaultCredentialProvisioner();
    }

    public CredentialProvisioner(String contextName) {
        this._provisioning = this._credentialStoreCtx.getCredentialProvisioner(contextName);
    }

    public void storeCredential(Credential cred, String credKey, Principal principal) {
        this.storeCredential(cred, null, null, credKey, principal);
    }

    public void storeCredential(Credential cred, String mapName, String adfCredKey, String credKey, Principal principal) {
        String METHOD_NAME = "storeCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeCredential", "Credential", cred);
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeCredential", "Credential Key", adfCredKey == null ? credKey : adfCredKey);
        CredentialStoreContext.checkSerializable(CLASS_NAME, "storeCredential", cred, adfCredKey == null ? credKey : adfCredKey);
        if (mapName != null && adfCredKey != null && this._provisioning instanceof CredentialProvisioning2) {
            CredentialProvisioning2 _provisioning2 = (CredentialProvisioning2)this._provisioning;
            _provisioning2.storeCredential(cred, mapName, adfCredKey, credKey, principal);
            return;
        }
        this._provisioning.storeCredential(cred, credKey, principal);
    }

    public void storeSerializableCredential(Serializable cred, String credKey, Principal principal) {
        this.storeSerializableCredential(cred, null, null, credKey, principal);
    }

    public void storeSerializableCredential(Serializable cred, String mapName, String adfCredKey, String credKey, Principal principal) {
        String METHOD_NAME = "storeSerializableCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeSerializableCredential", "Credential", cred);
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeSerializableCredential", "Credential Key", adfCredKey == null ? credKey : adfCredKey);
        if (mapName != null && adfCredKey != null && this._provisioning instanceof CredentialProvisioning2) {
            CredentialProvisioning2 _provisioning2 = (CredentialProvisioning2)this._provisioning;
            _provisioning2.storeSerializableCredential(cred, mapName, adfCredKey, credKey, principal);
            return;
        }
        this._provisioning.storeSerializableCredential(cred, credKey, principal);
    }

    public void removeCredential(String credKey, Principal principal) throws CredentialNotFoundException {
        this.removeCredential(null, null, credKey, principal);
    }

    public void removeCredential(String mapName, String adfCredKey, String credKey, Principal principal) throws CredentialNotFoundException {
        String METHOD_NAME = "removeCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "removeCredential", "Credential Key", adfCredKey == null ? credKey : adfCredKey);
        if (mapName != null && adfCredKey != null && this._provisioning instanceof CredentialProvisioning2) {
            CredentialProvisioning2 _provisioning2 = (CredentialProvisioning2)this._provisioning;
            _provisioning2.removeCredential(credKey, mapName, adfCredKey, principal);
            return;
        }
        this._provisioning.removeCredential(credKey, principal);
    }
}

