/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.beans.Beans;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.security.ADFSecurityConfig;

public class JAASInitialContextFactory
implements InitialContextFactory {
    public static final String ENV_JAAS_CONTEXT = "oracle.adf.security.context";
    public static final String JAAS_CONTEXT = "oracle.adf.share.security.providers.jazn.JAZNSecurityContext";
    public static final String DEFAULT_CONTEXT = "oracle.adf.share.security.SecurityContextImpl";
    public static final String XS_CONTEXT = "oracle.adf.share.security.providers.jps.xds.XsSecurityContext";
    static final String JAZN_LOGINMODULE = "oracle.security.jazn.realm.RealmLoginModule";

    public Context getInitialContext(Map env) throws NamingException {
        Context ctx;
        block8: {
            String contextName;
            ADFSecurityConfig.resetSecurityEnvForNonJps(env);
            ctx = null;
            String string = contextName = env != null ? (String)env.get(ENV_JAAS_CONTEXT) : null;
            if (contextName == null) {
                contextName = Beans.isDesignTime() ? DEFAULT_CONTEXT : "oracle.adf.share.security.providers.jps.JpsSecurityContext";
            }
            try {
                Class cls = ClassUtils.forName((String)contextName, JAASInitialContextFactory.class);
                try {
                    ctx = (Context)cls.getConstructor(Map.class).newInstance(env);
                }
                catch (NoSuchMethodException e) {
                    if (env instanceof Hashtable) {
                        ctx = (Context)cls.getConstructor(Hashtable.class).newInstance((Hashtable)env);
                        break block8;
                    }
                    ctx = (Context)cls.getConstructor(Hashtable.class).newInstance(new Hashtable(env));
                }
            }
            catch (Exception e) {
                if (contextName.equals(DEFAULT_CONTEXT)) break block8;
                try {
                    Class cls = ClassUtils.forName((String)DEFAULT_CONTEXT, JAASInitialContextFactory.class);
                    ctx = (Context)cls.getConstructor(Map.class).newInstance(env);
                }
                catch (Exception e2) {
                    NamingException ne = new NamingException(e2.getMessage());
                    ne.setRootCause(e2);
                    throw ne;
                }
            }
        }
        return ctx;
    }

    public Context getInitialContext(Hashtable env) throws NamingException {
        return this.getInitialContext((Map)env);
    }
}

