/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.security.resource.ADFSecurityMessages;

@CodeSharingSafe(value="StaticInitializer")
public class ADFSecurityException
extends Exception {
    private static final long serialVersionUID = -1562381005029744323L;
    private Throwable m_Cause;
    private String m_ErrorMsgKey;
    private Object[] m_MsgArgs;
    private ResourceBundle mResourceBundle;
    private static final String s_DefaultMsgKey = "default";
    private static final ResourceBundle sDefaultResourceBundle = ADFSecurityMessages.getBundle();

    public static void init() throws MissingResourceException {
    }

    public ADFSecurityException() {
        this(s_DefaultMsgKey);
    }

    public ADFSecurityException(String msgKey) {
        this(null, msgKey, null);
    }

    public ADFSecurityException(String msgKey, Object[] msgArgs) {
        this(null, msgKey, msgArgs);
    }

    public ADFSecurityException(String msgKey, ResourceBundle resourceBundle) {
        this(null, msgKey, resourceBundle, null);
    }

    public ADFSecurityException(Throwable cause) {
        this(cause, s_DefaultMsgKey, null);
    }

    public ADFSecurityException(Throwable cause, String msgKey, Object obj1, Object obj2, Object obj3) {
        this(cause, msgKey, new Object[]{obj1, obj2, obj3});
    }

    public ADFSecurityException(Throwable cause, String msgKey, ResourceBundle resourceBundle, Object obj1, Object obj2, Object obj3) {
        this(cause, msgKey, resourceBundle, new Object[]{obj1, obj2, obj3});
    }

    public ADFSecurityException(Throwable cause, String msgKey, Object[] msgArgs) {
        this(cause, msgKey, null, msgArgs);
    }

    public ADFSecurityException(Throwable cause, String msgKey, ResourceBundle resourceBundle, Object[] msgArgs) {
        this.m_Cause = cause;
        this.m_ErrorMsgKey = msgKey;
        this.mResourceBundle = resourceBundle;
        this.m_MsgArgs = msgArgs;
    }

    public String getErrorMsgKey() {
        return this.m_ErrorMsgKey;
    }

    public String getErrorMessage() {
        String msg = this.getLocalErrorMessage();
        if (this.m_Cause != null) {
            msg = msg.concat("    \n");
            if (this.m_Cause instanceof ADFSecurityException) {
                String mdsMsg = ((ADFSecurityException)this.m_Cause).getErrorMessage();
                if (mdsMsg != null) {
                    msg = msg.concat(mdsMsg);
                }
            } else {
                String exMsg = this.m_Cause.getMessage();
                if (exMsg != null) {
                    msg = msg.concat(exMsg);
                }
            }
        }
        return msg;
    }

    public String getLocalErrorMessage() {
        String msg = "";
        if (this.m_ErrorMsgKey.equals(s_DefaultMsgKey)) {
            if (this.m_Cause == null) {
                msg = this.getResourceBundle().getString(this.m_ErrorMsgKey);
            }
        } else {
            msg = this.getResourceBundle().getString(this.m_ErrorMsgKey);
            if (this.m_MsgArgs != null) {
                MessageFormat format = new MessageFormat(msg);
                msg = format.format(this.m_MsgArgs);
            }
        }
        return msg;
    }

    public void printErrorMessage() {
        System.out.println(this.getErrorMessage());
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream stream) {
        stream.println();
        stream.println(" Exception: ");
        super.printStackTrace(stream);
        if (this.m_Cause != null) {
            stream.println("Cause: ");
            this.m_Cause.printStackTrace(stream);
        }
        stream.println();
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        writer.println();
        writer.println("Exception: ");
        super.printStackTrace(writer);
        if (this.m_Cause != null) {
            writer.println("Cause: ");
            this.m_Cause.printStackTrace(writer);
        }
        writer.println();
        writer.flush();
    }

    @Override
    public Throwable getCause() {
        return this.m_Cause;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getErrorMessage();
    }

    private ResourceBundle getResourceBundle() {
        if (this.mResourceBundle != null) {
            return this.mResourceBundle;
        }
        return sDefaultResourceBundle;
    }
}

