/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.adf.share.ADFContext;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.jndi.ConnectionException;
import oracle.adf.share.jndi.ConnectionReference;
import oracle.adf.share.jndi.CredentialStoreHelper;
import oracle.adf.share.jndi.MetadataRefAddr;
import oracle.adf.share.jndi.NameParserImpl;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.adf.share.jndi.StringELRefAddr;
import oracle.adf.share.jndi.XmlRefAddr;
import oracle.adf.share.jndi.xml.v2.AnyXmlType;
import oracle.adf.share.jndi.xml.v2.MetadataRefAddrType;
import oracle.adf.share.jndi.xml.v2.ObjectFactory;
import oracle.adf.share.jndi.xml.v2.PropertyType;
import oracle.adf.share.jndi.xml.v2.RefAddrType;
import oracle.adf.share.jndi.xml.v2.RefAddressListType;
import oracle.adf.share.jndi.xml.v2.ReferenceFactoryType;
import oracle.adf.share.jndi.xml.v2.ReferenceListType;
import oracle.adf.share.jndi.xml.v2.ReferenceType;
import oracle.adf.share.jndi.xml.v2.SecureRefAddrType;
import oracle.adf.share.jndi.xml.v2.StringRefAddrType;
import oracle.adf.share.jndi.xml.v2.XmlRefAddrType;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.CredentialNotFoundException;
import oracle.adf.share.security.credentialstore.Credential;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReferenceStoreHelper {
    private ObjectFactory mJaxbFactory = new ObjectFactory();
    private ReferenceListType mReferences = null;
    private Context mCtx = null;
    private Hashtable mEnv = null;
    private Map<String, Credential> mNewCredentials;
    private Map<String, Credential> mDeletedCredentials;
    private Map<String, ReferenceType> mDeletedRefs = new HashMap<String, ReferenceType>();
    private CredentialStoreHelper storage = null;
    private List<ReferenceType> jarReferences = null;
    private ADFLogger mLogger = ADFLogger.createADFLogger(ReferenceStoreHelper.class);
    private static final String resourceBundle = "oracle.adf.share.jndi.resources.Messages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.jndi.resources.Messages");
    private boolean evaluateEls = true;

    public void init(ReferenceListType refs, Context ctx, Hashtable env) {
        Object val;
        this.mReferences = refs;
        this.mCtx = ctx;
        this.mEnv = env;
        if (this.mEnv.containsKey("oracle.adf.share.jndi.EvaluateELs") && (val = this.mEnv.get("oracle.adf.share.jndi.EvaluateELs")) != null) {
            this.evaluateEls = Boolean.parseBoolean((String)val);
        }
    }

    public ReferenceListType getReferences() {
        if (this.mReferences == null) {
            this.mReferences = this.mJaxbFactory.createReferenceListType();
        }
        return this.mReferences;
    }

    private List getJarReferences() {
        if (this.jarReferences == null) {
            this.jarReferences = new ArrayList<ReferenceType>();
        }
        return this.jarReferences;
    }

    public ReferenceListType getSaveableReferences() {
        if (this.mReferences == null) {
            this.mReferences = this.mJaxbFactory.createReferenceListType();
            return this.mReferences;
        }
        if (this.jarReferences == null) {
            return this.mReferences;
        }
        ReferenceListType saveableRefs = this.mJaxbFactory.createReferenceListType();
        for (ReferenceType refTypeObject : this.mReferences.getReference()) {
            ReferenceType refType;
            if (!(refTypeObject instanceof ReferenceType) || this.jarReferences.contains(refType = refTypeObject)) continue;
            saveableRefs.getReference().add(refType);
        }
        return saveableRefs;
    }

    public ADFLogger getLogger() {
        return this.mLogger;
    }

    public void addJarReferences(List<ReferenceListType> refList) throws Exception {
        this.mReferences = this.getReferences();
        for (ReferenceListType refs : refList) {
            List<ReferenceType> list = refs.getReference();
            for (ReferenceType refObj : list) {
                ReferenceType refType = refObj;
                String id = refType.getName();
                if (this.findReferenceType(id) == null) {
                    this.mReferences.getReference().add(refType);
                    this.getJarReferences().add(refType);
                    this.getLogger().finest("Adding jar-connection " + id);
                    continue;
                }
                this.getLogger().finest("Not adding jar-connection " + id + " as a connection with name already exists");
            }
        }
    }

    public Reference findReference(String id) throws NamingException {
        ReferenceType refType = this.findReferenceType(id);
        if (refType == null) {
            return null;
        }
        Reference ref = null;
        try {
            ref = this.createReference(refType);
        }
        catch (Exception e) {
            this.throwNamingException(e);
        }
        return ref;
    }

    public boolean exists(String id) throws NamingException {
        ReferenceType refType = this.findReferenceType(id);
        return refType != null;
    }

    public Object getObjectForReference(String id) throws Exception {
        return this.getObjectForReference(id, null);
    }

    public Object getObjectForReference(String id, Reference reference) throws Exception {
        return this.getObjectForReference(id, reference, false);
    }

    Object getObjectForReference(String id, Reference reference, boolean isLookup) throws Exception {
        ReferenceType refType = null;
        refType = reference != null ? this.createReferenceType(id, reference, isLookup) : this.findReferenceType(id);
        if (refType == null) {
            return null;
        }
        if (reference == null) {
            try {
                reference = this.createReference(refType);
            }
            catch (PartialResultException ex) {
                reference = (Reference)ex.getResolvedObj();
            }
        }
        javax.naming.spi.ObjectFactory fac = this.getJndiObjectFactory(refType.getFactory());
        Name name = NameParserImpl.getInstance().parse(id);
        Object returnObj = fac.getObjectInstance(reference, name, this.mCtx, this.mEnv);
        return returnObj;
    }

    public Map getReferencesMapEx(boolean includeExceptions) throws NamingException {
        HashMap<String, Serializable> refMap = new HashMap<String, Serializable>(10);
        if (this.mReferences == null) {
            return refMap;
        }
        try {
            List<ReferenceType> refList = this.mReferences.getReference();
            for (ReferenceType refType : refList) {
                String id = refType.getName();
                String classname = refType.getClassName();
                Reference ref = null;
                try {
                    ref = this.createReference(refType);
                }
                catch (PartialResultException ex) {
                    ref = (Reference)ex.getResolvedObj();
                    Boolean isMBean = (Boolean)this.mEnv.get("AdfJndiHelper_ConnectionRuntimeMBeansExecuting");
                    if ((isMBean == null || !isMBean.booleanValue()) && this.getLogger().isWarning()) {
                        this.getLogger().warning(ex.getLocalizedMessage());
                    }
                    if (this.getLogger().isFine()) {
                        this.getLogger().fine((Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    if (includeExceptions) {
                        ConnectionException cex = new ConnectionException(ex);
                        cex.setClassName(classname);
                        refMap.put(id, cex);
                        continue;
                    }
                    this.throwNamingException(ex);
                }
                refMap.put(id, ref);
            }
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
        return refMap;
    }

    public Map getReferencesMap() throws NamingException {
        return this.getReferencesMapEx(false);
    }

    public void addReference(String id, Reference ref) throws NamingException {
        ReferenceType refType = this.findReferenceType(id);
        if (refType == null) {
            refType = this.createReferenceType(id, ref);
            ReferenceType _ref = this.getReferenceByCredKey(id);
            if (_ref != null) {
                refType.setAdfCredentialStoreKey(_ref.getAdfCredentialStoreKey());
                refType.setAdfCredentialStoreMapName(_ref.getAdfCredentialStoreMapName());
            } else if (ref instanceof ConnectionReference) {
                ConnectionReference conref = (ConnectionReference)ref;
                refType.setAdfCredentialStoreKey(conref.getAdfCredentialStoreKey());
                refType.setAdfCredentialStoreMapName(conref.getAdfCredentialStoreMapName());
            }
        } else {
            throw new NamingException("Name already in use");
        }
        this.addReferenceType(refType);
    }

    public void removeReference(String id) throws NamingException {
        this.removeReferenceType(id);
    }

    public void saveCredentials() throws Exception {
        if (this.mNewCredentials == null && this.mDeletedCredentials == null) {
            return;
        }
        String namedContext = (String)this.mEnv.get("named.adf.context");
        if (ADFContext.hasCurrent()) {
            this.saveCredentialsInternal(namedContext);
            return;
        }
        ADFContext thisCtx = null;
        thisCtx = namedContext != null && ADFContext.isNamedContextRegistered(namedContext) ? ADFContext.get(namedContext) : ADFContext.getCurrent();
        if (thisCtx != null) {
            thisCtx.setAsCurrent();
        }
        try {
            this.saveCredentialsInternal(namedContext);
        }
        finally {
            if (thisCtx != null) {
                thisCtx.removeAsCurrent();
            }
        }
    }

    private void saveCredentialsInternal(String namedContext) throws Exception {
        if (this.storage == null) {
            this.storage = namedContext == null ? CredentialStoreHelper.getInstance() : new CredentialStoreHelper(namedContext);
        }
        String principal = (String)this.mEnv.get("java.naming.security.principal");
        if (this.mNewCredentials != null) {
            for (Map.Entry entry : this.mNewCredentials.entrySet()) {
                Credential cd;
                String credKey = (String)entry.getKey();
                ReferenceType refT = this.getReferenceByCredKey(credKey);
                if (refT == null) {
                    cd = null;
                    try {
                        cd = this.storage.fetchCredential(principal, (String)entry.getKey());
                    }
                    catch (CredentialNotFoundException credentialNotFoundException) {
                        // empty catch block
                    }
                    if (cd != null && this.areCredentialEqual(cd, (Credential)entry.getValue())) continue;
                    this.storage.storeCredential(principal, (String)entry.getKey(), (Credential)entry.getValue());
                    continue;
                }
                cd = null;
                try {
                    cd = this.storage.fetchCredential(refT.getAdfCredentialStoreMapName(), refT.getAdfCredentialStoreKey(), principal, credKey);
                }
                catch (CredentialNotFoundException credentialNotFoundException) {
                    // empty catch block
                }
                if (cd != null && this.areCredentialEqual(cd, (Credential)entry.getValue())) continue;
                this.storage.storeCredential(refT.getAdfCredentialStoreMapName(), refT.getAdfCredentialStoreKey(), principal, credKey, (Credential)entry.getValue());
            }
            this.mNewCredentials.clear();
            this.mDeletedRefs.clear();
        }
        if (this.mDeletedCredentials != null) {
            Iterator<Object> iter = this.mDeletedCredentials.keySet().iterator();
            while (iter.hasNext()) {
                String string = "";
                try {
                    String string2 = (String)iter.next();
                    ReferenceType refT = this.getReferenceByCredKey(string2);
                    if (refT == null) {
                        this.storage.removeCredential(principal, string2);
                        continue;
                    }
                    this.storage.removeCredential(refT.getAdfCredentialStoreMapName(), refT.getAdfCredentialStoreKey(), principal, string2);
                }
                catch (CredentialNotFoundException cnfe) {
                    this.getLogger().warning(resBundle.getString("CREDENTIAL_NOT_REMOVED"), (Object)string);
                    this.getLogger().fine((Throwable)cnfe);
                }
                catch (ADFSecurityRuntimeException ase) {
                    this.getLogger().warning(resBundle.getString("CREDENTIAL_NOT_REMOVED"), (Object)string);
                    this.getLogger().fine((Throwable)ase);
                }
                catch (Exception ex) {
                    this.getLogger().warning(resBundle.getString("CREDENTIAL_NOT_REMOVED"), (Object)string);
                    this.getLogger().fine((Throwable)ex);
                    throw ex;
                }
            }
            this.mDeletedCredentials.clear();
            this.mDeletedRefs.clear();
        }
    }

    private boolean areCredentialEqual(Credential sc, Credential tc) {
        if (sc == null || tc == null) {
            return false;
        }
        if (sc.isEmpty() && tc.isEmpty()) {
            return true;
        }
        Set keys = sc.keySet();
        for (Object key : keys) {
            String vs2;
            String vs1;
            Object v1 = sc.get(key);
            Object v2 = tc.get(key);
            if (v1 != null && v2 != null && (v1 instanceof char[] && v2 instanceof char[] && (vs1 = new String((char[])v1)).equals(vs2 = new String((char[])v2)) || v1 instanceof String && v2 instanceof String && ((String)v1).equals((String)v2) || v1.equals(v2)) || v1 == null && v2 == null) continue;
            return false;
        }
        return true;
    }

    public void destroy() {
        this.mNewCredentials.clear();
        this.mDeletedCredentials.clear();
        this.mDeletedRefs.clear();
        this.mJaxbFactory = null;
        this.mReferences = null;
        this.mEnv = null;
        this.mNewCredentials = null;
        this.mDeletedCredentials = null;
        this.mDeletedRefs = null;
    }

    private ReferenceType findReferenceType(String id) throws NamingException {
        if (this.mReferences == null) {
            return null;
        }
        try {
            List<ReferenceType> refList = this.mReferences.getReference();
            for (ReferenceType ref : refList) {
                if (!ref.getName().equals(id)) continue;
                return ref;
            }
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
        return null;
    }

    private String searchRefAddressesForStoreKey(ReferenceType ref) throws Exception {
        String skey = null;
        RefAddressListType addrList = ref.getRefAddresses();
        if (addrList == null) {
            return skey;
        }
        for (RefAddrType refAddr : addrList.getReferenceAddrGroup()) {
            String addrType;
            if (!(refAddr instanceof StringRefAddrType) || (addrType = refAddr.getAddrType()) == null || !addrType.endsWith("credentialStoreKey")) continue;
            skey = ((StringRefAddrType)refAddr).getContents();
            break;
        }
        return skey;
    }

    private Reference createReference(ReferenceType ref) throws Exception {
        RefAddressListType addrList;
        ConnectionReference reference = new ConnectionReference(ref.getClassName(), ref.getFactory().getClassName(), null);
        if (ref.isPartial() != null) {
            reference.setPartial(ref.isPartial());
        }
        if (ref.isDeployable() != null) {
            reference.setDeployable(ref.isDeployable());
        }
        if (ref.isManageInOracleEnterpriseManager() != null) {
            reference.setManageInOracleEnterpriseManager(ref.isManageInOracleEnterpriseManager());
        }
        if ((addrList = ref.getRefAddresses()) == null) {
            return reference;
        }
        String adfCredKey = ref.getAdfCredentialStoreKey();
        String mapName = ref.getAdfCredentialStoreMapName();
        String credKey = ref.getCredentialStoreKey();
        reference.setAdfCredentialStoreMapName(mapName);
        reference.setAdfCredentialStoreKey(adfCredKey);
        if (credKey == null) {
            credKey = this.searchRefAddressesForStoreKey(ref);
        }
        String partialResultExceptionRefName = null;
        ConnectionReference partialResultExceptionReference = null;
        Exception partialResultException = null;
        Credential cred = null;
        if (credKey != null && (cred = this.findNewCredential(credKey)) == null) {
            try {
                cred = this.loadCredentials(mapName, adfCredKey, credKey);
            }
            catch (CredentialNotFoundException ex) {
                partialResultExceptionRefName = ref.getName();
                partialResultExceptionReference = reference;
                partialResultException = ex;
            }
            catch (ADFSecurityRuntimeException ex) {
                partialResultExceptionRefName = ref.getName();
                partialResultExceptionReference = reference;
                partialResultException = ex;
            }
        }
        HashSet secureAttrs = null;
        if (cred != null) {
            secureAttrs = new HashSet(cred.keySet());
        }
        for (RefAddrType refAddr : addrList.getReferenceAddrGroup()) {
            if (refAddr instanceof MetadataRefAddrType) {
                reference.add(new MetadataRefAddr(refAddr.getAddrType(), ((MetadataRefAddrType)refAddr).getContents()));
            }
            if (refAddr instanceof XmlRefAddrType) {
                AnyXmlType anyType = ((XmlRefAddrType)refAddr).getContents();
                XmlRefAddr xmlRefAddr = new XmlRefAddr(refAddr.getAddrType(), this.createDocumentFragment(anyType));
                reference.add(xmlRefAddr);
                continue;
            }
            if (refAddr instanceof StringRefAddrType) {
                if (this.evaluateEls) {
                    reference.add(new StringELRefAddr(refAddr.getAddrType(), ((StringRefAddrType)refAddr).getContents()));
                    continue;
                }
                reference.add(new StringRefAddr(refAddr.getAddrType(), ((StringRefAddrType)refAddr).getContents()));
                continue;
            }
            if (!(refAddr instanceof SecureRefAddrType)) continue;
            String attrName = refAddr.getAddrType();
            if ((null == cred || !cred.containsKey(attrName)) && this.getLogger().isWarning()) {
                this.getLogger().warning("No credential could be loaded for Reference = " + reference.toString() + ", SecureRefAddr = " + attrName + ". Setting default value of \"\".");
            }
            reference.add(this.createSecureRefAddr(cred, attrName));
            if (secureAttrs == null || !secureAttrs.contains(attrName)) continue;
            secureAttrs.remove(attrName);
        }
        if (secureAttrs != null) {
            for (String pname : secureAttrs) {
                reference.add(this.createSecureRefAddr(cred, pname));
            }
        }
        if (partialResultExceptionRefName != null && partialResultExceptionReference != null && partialResultException != null) {
            this.throwPartialResultException(partialResultExceptionRefName, partialResultExceptionReference, partialResultException);
        }
        return reference;
    }

    private void throwPartialResultException(String name, ConnectionReference reference, Exception ex) throws PartialResultException {
        reference.setPartial(true);
        PartialResultException pre = new PartialResultException("Incomplete connection reference object for connection:" + name);
        pre.setResolvedObj(reference);
        pre.setRootCause(ex);
        this.getLogger().fine(resBundle.getString("INCOMPLETE_CONNECTION"), new Object[]{name});
        this.getLogger().fine((Throwable)ex);
        throw pre;
    }

    private void addReferenceType(ReferenceType refType) throws NamingException {
        if (this.mReferences == null) {
            this.mReferences = this.mJaxbFactory.createReferenceListType();
        }
        try {
            List<ReferenceType> refList = this.mReferences.getReference();
            refList.add(refType);
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
    }

    private void removeReferenceType(String id) throws NamingException {
        if (this.mReferences == null) {
            return;
        }
        try {
            ReferenceType ref = this.findReferenceType(id);
            if (ref != null) {
                if (ref.getCredentialStoreKey() != null) {
                    this.removeCredential(ref.getName());
                }
                this.mReferences.getReference().remove(ref);
                this.mDeletedRefs.put(id, ref);
            }
        }
        catch (Exception e) {
            this.throwNamingException(e);
        }
    }

    private ReferenceType createReferenceType(String id, Reference ref) {
        return this.createReferenceType(id, ref, false);
    }

    private ReferenceType createReferenceType(String id, Reference ref, boolean isLookup) {
        Credential credential = new Credential();
        ReferenceType aRef = this.mJaxbFactory.createReferenceType();
        aRef.setName(id);
        aRef.setClassName(ref.getClassName());
        ReferenceFactoryType refFact = this.mJaxbFactory.createReferenceFactoryType();
        refFact.setClassName(ref.getFactoryClassName());
        aRef.setFactory(refFact);
        if (ref instanceof ConnectionReference) {
            aRef.setPartial(((ConnectionReference)ref).isPartial());
            aRef.setDeployable(((ConnectionReference)ref).isDeployable());
            aRef.setManageInOracleEnterpriseManager(((ConnectionReference)ref).isManageInOracleEnterpriseManager());
            aRef.setAdfCredentialStoreMapName(((ConnectionReference)ref).getAdfCredentialStoreMapName());
            aRef.setAdfCredentialStoreKey(((ConnectionReference)ref).getAdfCredentialStoreKey());
        }
        RefAddressListType addrList = this.mJaxbFactory.createRefAddressListType();
        Enumeration<RefAddr> e = ref.getAll();
        while (e.hasMoreElements()) {
            String content;
            RefAddr refAddr = e.nextElement();
            if (refAddr instanceof StringRefAddr) {
                StringRefAddrType strRefAddrType = this.mJaxbFactory.createStringRefAddrType();
                content = (String)((StringRefAddr)refAddr).getContent();
                strRefAddrType.setContents(content);
                strRefAddrType.setAddrType(refAddr.getType());
                addrList.getReferenceAddrGroup().add(strRefAddrType);
                continue;
            }
            if (refAddr instanceof XmlRefAddr) {
                XmlRefAddrType xmlRef = this.mJaxbFactory.createXmlRefAddrType();
                xmlRef.setAddrType(refAddr.getType());
                AnyXmlType anyXml = this.mJaxbFactory.createAnyXmlType();
                DocumentFragment df = ((XmlRefAddr)refAddr).getDocumentFragment();
                NodeList nl = df.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node node = nl.item(i);
                    anyXml.getAny().add(node);
                }
                xmlRef.setContents(anyXml);
                addrList.getReferenceAddrGroup().add(xmlRef);
                continue;
            }
            if (refAddr instanceof SecureRefAddr) {
                SecureRefAddr secref = (SecureRefAddr)refAddr;
                String v = secref.getValue();
                credential.put(secref.getName(), v == null ? null : v.toCharArray());
                SecureRefAddrType secRefType = this.mJaxbFactory.createSecureRefAddrType();
                secRefType.setAddrType(refAddr.getType());
                addrList.getReferenceAddrGroup().add(secRefType);
                continue;
            }
            if (!(refAddr instanceof MetadataRefAddr)) continue;
            MetadataRefAddrType mtRefAddrType = this.mJaxbFactory.createMetadataRefAddrType();
            content = (String)((MetadataRefAddr)refAddr).getContent();
            mtRefAddrType.setContents(content);
            mtRefAddrType.setAddrType(refAddr.getType());
            addrList.getReferenceAddrGroup().add(mtRefAddrType);
        }
        if (credential.size() > 0) {
            if (isLookup) {
                aRef.setCredentialStoreKey(id);
            } else {
                aRef.setCredentialStoreKey(this.addCredential(id, credential));
            }
        }
        aRef.setRefAddresses(addrList);
        return aRef;
    }

    private ReferenceType getReferenceByCredKey(String credKey) {
        if (this.mReferences == null) {
            return null;
        }
        List<ReferenceType> refList = this.mReferences.getReference();
        for (ReferenceType refT : refList) {
            String k = refT.getCredentialStoreKey();
            if (k == null || !k.equals(credKey)) continue;
            return refT;
        }
        if (this.mDeletedRefs != null) {
            return this.mDeletedRefs.get(credKey);
        }
        return null;
    }

    private javax.naming.spi.ObjectFactory getJndiObjectFactory(ReferenceFactoryType facType) throws Exception {
        String factoryClassName = facType.getClassName();
        Class factoryClass = ClassUtils.forName((String)factoryClassName, ReferenceStoreHelper.class);
        Object factory = factoryClass.newInstance();
        Properties props = null;
        Iterator<PropertyType> iter = facType.getProperty().iterator();
        while (iter.hasNext()) {
            if (props == null) {
                props = new Properties();
            }
            PropertyType prop = iter.next();
            props.setProperty(prop.getName(), prop.getValue());
        }
        if (props != null) {
            try {
                Method m = factory.getClass().getMethod("setProperties", Properties.class);
                m.invoke(factory, props);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return (javax.naming.spi.ObjectFactory)factory;
    }

    private Credential findNewCredential(String id) {
        Credential credential = null;
        if (this.mNewCredentials != null) {
            credential = this.mNewCredentials.get(id);
        }
        return credential;
    }

    private String addCredential(String id, Credential cred) {
        if (this.mNewCredentials == null) {
            this.mNewCredentials = new HashMap<String, Credential>(10);
        }
        this.mNewCredentials.put(id, cred);
        if (this.mDeletedCredentials != null) {
            this.mDeletedCredentials.remove(id);
        }
        return id;
    }

    private void removeCredential(String id) {
        Credential credential = null;
        if (this.mNewCredentials != null) {
            credential = this.mNewCredentials.remove(id);
        }
        if (credential == null) {
            if (this.mDeletedCredentials == null) {
                this.mDeletedCredentials = new HashMap<String, Credential>(10);
            }
            this.mDeletedCredentials.put(id, credential);
        }
    }

    private Credential loadCredentials(String mapName, String adfCredKey, String credKey) throws Exception {
        String namedContext = (String)this.mEnv.get("named.adf.context");
        if (this.storage == null) {
            this.storage = namedContext == null ? CredentialStoreHelper.getInstance() : new CredentialStoreHelper(namedContext);
        }
        String principal = (String)this.mEnv.get("java.naming.security.principal");
        if (mapName == null || adfCredKey == null) {
            return this.storage.fetchCredential(principal, credKey);
        }
        return this.storage.fetchCredential(mapName, adfCredKey, principal, credKey);
    }

    private Object getCredentialAttrValue(Credential credential, String attrName) {
        if (credential != null && credential.get(attrName) != null) {
            return credential.get(attrName);
        }
        return "";
    }

    private SecureRefAddr createSecureRefAddr(Credential credential, String attrName) {
        Object value = this.getCredentialAttrValue(credential, attrName);
        if (value instanceof String) {
            return new SecureRefAddr(attrName, (String)value);
        }
        if (value instanceof char[]) {
            return new SecureRefAddr(attrName, (char[])value);
        }
        return new SecureRefAddr(attrName, value.toString());
    }

    private DocumentFragment createDocumentFragment(AnyXmlType anyType) throws Exception {
        Document newDoc = null;
        DocumentFragment doc = null;
        for (Node node : anyType.getAny()) {
            if (doc == null) {
                newDoc = this.createDocument();
                doc = newDoc.createDocumentFragment();
            }
            Node newNode = newDoc.importNode(node, true);
            doc.appendChild(newNode);
        }
        return doc;
    }

    private Document createDocument() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder().newDocument();
    }

    private void throwNamingException(Exception ex) throws NamingException {
        NamingException ne = new NamingException();
        ne.setRootCause(ex);
        throw ne;
    }
}

