/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import oracle.adf.share.ADFContext;
import oracle.adf.share.common.rc.util.MetadataRegistry;
import oracle.adf.share.jndi.DocumentBackingStore;
import org.w3c.dom.Document;

public class JarFileBackingStore
extends DocumentBackingStore {
    private static MetadataRegistry rcutils = MetadataRegistry.newInstance();
    private Hashtable mContextEnv = null;
    private HashMap<String, Document> documents = new HashMap(5);

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void initialize(Hashtable contextEnv, String url) throws Exception {
        super.initialize(contextEnv, url);
        this.mContextEnv = contextEnv;
        this.getContextURL().toString();
    }

    private final URL getContextURL() throws Exception {
        Object contextName = this.mContextEnv.get("named.adf.context");
        return ADFContext.get(contextName.toString()).getURL();
    }

    @Override
    public boolean documentExists(String url) {
        return this.commonCacheCheck(url) != null;
    }

    @Override
    public Document readDocument(String url) {
        return this.commonCacheCheck(url);
    }

    @Override
    public Document createDocument(String url) {
        throw new UnsupportedOperationException("ReadOnly");
    }

    @Override
    public void writeDocument(Document doc, String url) {
        throw new UnsupportedOperationException("ReadOnly");
    }

    private final synchronized Document commonCacheCheck(String url) {
        String docKey = url.toLowerCase();
        if (!this.documents.containsKey(docKey)) {
            return this.cacheDocument(url);
        }
        return this.documents.get(docKey);
    }

    protected Document cacheDocument(String url) {
        try {
            URL realUrl = this.resolveDocumentURL(url);
            if (realUrl == null) {
                return null;
            }
            Document doc = rcutils.getDomDocument(realUrl);
            this.documents.put(url.toLowerCase(), doc);
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected URL resolveDocumentURL(String url) throws Exception {
        String baseName;
        int parentX;
        String path = null;
        if (url.charAt(0) == '.' && (parentX = (baseName = this.getContextURL().toString()).lastIndexOf(47)) != -1) {
            path = baseName.substring(0, parentX + 1) + url;
        }
        return new URL(this.removeRelativeItems(path));
    }

    private String removeRelativeItems(String path) {
        if (path.indexOf("/./") == -1 && path.indexOf("/../") == -1) {
            return path;
        }
        ArrayList<String> segments = new ArrayList<String>(Arrays.asList(path.split("/")));
        for (int i = 0; i < segments.size(); ++i) {
            String elem = segments.get(i);
            if (elem.equals(".")) {
                segments.remove(i--);
                continue;
            }
            if (!elem.equals("..")) continue;
            segments.remove(i--);
            segments.remove(i--);
        }
        StringBuilder returnThis = new StringBuilder(path.length());
        for (String seg : segments) {
            returnThis.append(seg + "/");
        }
        return returnThis.substring(0, returnThis.length() - 1);
    }
}

