/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.adf.share.common.rc.util.MetadataRegistry;
import oracle.adf.share.jndi.DocumentBackingStore;
import oracle.adf.share.logging.ADFLogger;
import org.w3c.dom.Document;

public class FileSystemBackingStore
extends DocumentBackingStore {
    private boolean readOnlyStore = false;
    private ADFLogger mLogger = null;

    @Override
    public void initialize(Hashtable contextEnv, String url) throws Exception {
        Object isReadOnly;
        super.initialize(contextEnv, url);
        if (this.getLogger().isFinest()) {
            this.getLogger().log(Level.FINEST, "FileSystemBackingStore is being initialized");
        }
        if ((isReadOnly = contextEnv.get("oracle.adf.share.jndi.FileSystemBackingStore.readonly")) != null && ((String)isReadOnly).equalsIgnoreCase("true")) {
            this.readOnlyStore = true;
            if (this.getLogger().isFinest()) {
                this.getLogger().log(Level.FINEST, "FileSystemBackingStore is read Only");
            }
        }
    }

    public ADFLogger getLogger() {
        if (this.mLogger == null) {
            this.mLogger = ADFLogger.createADFLogger(this.getClass());
        }
        return this.mLogger;
    }

    @Override
    public Document readDocument(String url) throws Exception {
        File file = this.getFile(url);
        if (this.getLogger().isFine()) {
            this.getLogger().log(Level.FINE, "Reading file : " + file.getAbsolutePath());
        }
        return MetadataRegistry.newInstance().getDomDocument(file.toURL());
    }

    @Override
    public void writeDocument(Document doc, String url) throws Exception {
        File file = this.getFile(url);
        URL fileUrl = file.toURL();
        MetadataRegistry.newInstance().saveDocumentTo(doc, fileUrl);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnlyStore;
    }

    @Override
    public Document createDocument(String url) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder().newDocument();
    }

    @Override
    public boolean documentExists(String url) throws Exception {
        return this.getFile(url).exists();
    }

    private File getFile(String url) throws Exception {
        if (url != null && url.length() > 5 && url.charAt(4) == ':' && url.substring(0, 4).equalsIgnoreCase("file")) {
            return new File(url.substring(5));
        }
        return new File(url);
    }
}

