/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.security.Principal;
import oracle.adf.share.ADFContext;
import oracle.adf.share.mt.util.MultiTenantStorage;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.credentialstore.CredentialProvisioner;
import oracle.adf.share.security.credentialstore.CredentialStore;
import oracle.adf.share.security.identitymanagement.UserManager;

public class CredentialStoreHelper {
    private UserManager userMgr;
    private CredentialProvisioner csp;
    private CredentialStore cs;
    private String namedContext = null;
    private static final MultiTenantStorage<CredentialStoreHelper> storeHelperStorage = new MultiTenantStorage();
    private static final MultiTenantStorage<Object> lockHelperStorage = new MultiTenantStorage<Object>(){

        protected Object initialValue() {
            return new Object();
        }
    };

    public static CredentialStoreHelper getInstance() throws Exception {
        return CredentialStoreHelper.getInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CredentialStoreHelper getInternal() throws Exception {
        CredentialStoreHelper credentialStoreHelper = (CredentialStoreHelper)storeHelperStorage.get();
        if (null == credentialStoreHelper) {
            Object object = lockHelperStorage.get();
            synchronized (object) {
                credentialStoreHelper = (CredentialStoreHelper)storeHelperStorage.get();
                if (null == credentialStoreHelper) {
                    credentialStoreHelper = new CredentialStoreHelper();
                    storeHelperStorage.set((Object)credentialStoreHelper);
                }
            }
        }
        return credentialStoreHelper;
    }

    public CredentialStoreHelper() throws Exception {
        this(null);
    }

    public CredentialStoreHelper(String name) throws Exception {
        this.namedContext = name;
        this.csp = new CredentialProvisioner(this.namedContext);
        this.cs = new CredentialStore(this.namedContext);
    }

    public void removeCredential(String principalName, String credKey) throws Exception {
        this.removeCredential(null, null, principalName, credKey);
    }

    public void removeCredential(String mapName, String adfCredKey, String principalName, String credKey) throws Exception {
        Principal principal = this.getPrincipal(principalName);
        this.csp.removeCredential(mapName, adfCredKey, credKey, principal);
    }

    public void storeCredential(String principalName, String credKey, Credential cred) throws Exception {
        this.storeCredential(null, null, principalName, credKey, cred);
    }

    public void storeCredential(String mapName, String adfCredKey, String principalName, String credKey, Credential cred) throws Exception {
        Principal principal = this.getPrincipal(principalName);
        this.csp.storeCredential(cred, mapName, adfCredKey, credKey, principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential fetchCredential(String mapName, String adfCredKey, String principalName, String credKey) throws Exception {
        SecurityContext secCtx = null;
        if (principalName != null) {
            secCtx = this.namedContext == null ? ADFContext.getCurrent().getSecurityContext() : ADFContext.get(this.namedContext).getSecurityContext();
        }
        Principal principal = null;
        try {
            if (secCtx != null && secCtx.getEnvironment().get("java.naming.security.principal") == null) {
                principal = this.getPrincipal(principalName);
                secCtx.addToEnvironment("java.naming.security.principal", principal);
            }
            Credential credential = this.cs.fetchCredential(mapName, adfCredKey, credKey);
            return credential;
        }
        finally {
            if (principal != null) {
                secCtx.removeFromEnvironment("java.naming.security.principal");
            }
        }
    }

    public Credential fetchCredential(String principalName, String credKey) throws Exception {
        return this.fetchCredential(null, null, principalName, credKey);
    }

    Principal getPrincipal(String principalName) {
        if (principalName == null || principalName.equals("anonymous")) {
            return null;
        }
        if (this.userMgr == null) {
            try {
                SecurityContext secCtx = this.namedContext == null ? ADFContext.getCurrent().getSecurityContext() : ADFContext.get(this.namedContext).getSecurityContext();
                this.userMgr = new UserManager(secCtx.getEnvironment());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.userMgr != null ? this.userMgr.getPrincipal(principalName) : null;
    }
}

