/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.adf.share.ADFShareException;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.rc.util.LoaderUtil;
import oracle.adf.share.config.ADFConfigImpl;
import oracle.adf.share.jndi.AdfInitialContext;
import oracle.adf.share.jndi.AdfJndiConfig;
import oracle.adf.share.security.JAASInitialContextFactory;

public class FallbackConfigImpl
extends ADFConfigImpl {
    private List siteDefPackages = null;
    private List sessionDefPackages = null;
    private List defCachePolicies = null;
    private List adfSessionOptionsList = null;
    private Object currentADFSessionOptions = null;
    private Object ADFMDSConfig = null;
    private Method getDefaultMDSInstance = null;
    private Throwable createdBy = null;
    private Logger logger = Logger.getLogger(FallbackConfigImpl.class.getName());
    public static final String FALLBACK_CONFIG_KEY = "__FallbackConfigImpl_inst__";

    FallbackConfigImpl() {
        if (this.logger.isLoggable(Level.FINE)) {
            StringBuilder buf = new StringBuilder();
            buf.append("\n  CREATION STACK, NOT AN ERROR\n");
            LoaderUtil.dumpClassLoaderHierarchy((ClassLoader)ClassUtils.getClassLoader(FallbackConfigImpl.class), (StringBuilder)buf, (String)"    ", (String)"  ");
            this.createdBy = new Throwable(buf.toString());
        }
    }

    @Override
    public Object getMDSInstance() {
        try {
            Object mdsInstance;
            if (this.ADFMDSConfig == null) {
                Class cls = ClassUtils.forName((String)"oracle.adf.share.config.ADFMDSConfig", FallbackConfigImpl.class);
                this.ADFMDSConfig = cls.newInstance();
                this.getDefaultMDSInstance = this.ADFMDSConfig.getClass().getDeclaredMethod("getDefaultMDSInstance", String.class);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                StringBuilder buf = new StringBuilder();
                LoaderUtil.dumpClassLoaderHierarchy((ClassLoader)ClassUtils.getClassLoader(FallbackConfigImpl.class), (StringBuilder)buf, (String)"  ", (String)"  ");
                this.logger.log(Level.FINE, buf.toString(), new Throwable("DIAGNOSTIC AID, NOT AN ERROR", this.createdBy));
            }
            if ((mdsInstance = this.getDefaultMDSInstance.invoke(this.ADFMDSConfig, this._applicationName)) != null) {
                this.cacheMDSInstance(mdsInstance);
            }
            return mdsInstance;
        }
        catch (ADFShareException ex) {
            throw ex;
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            if (t instanceof ADFShareException) {
                throw (ADFShareException)t;
            }
            throw new ADFShareException("getMDSInstance error", t);
        }
        catch (Exception ex) {
            throw new ADFShareException("getMDSInstance error", (Throwable)ex);
        }
    }

    @Override
    public List getSiteDefPackages() {
        try {
            Map sessDefMap = this.getConfigObject("http://xmlns.oracle.com/adf/mds/config");
            if (sessDefMap != null) {
                this.siteDefPackages = (List)sessDefMap.get("SiteDefPackages");
            }
            if (this.siteDefPackages == null) {
                Class cls = ClassUtils.forName((String)"oracle.adf.share.config.ADFMDSConfig", FallbackConfigImpl.class);
                Object obj = cls.newInstance();
                Method m = obj.getClass().getDeclaredMethod("getDefaultSiteDefPackages", String.class);
                this.siteDefPackages = (List)m.invoke(obj, this._applicationName);
            }
            return this.siteDefPackages;
        }
        catch (ADFShareException ex) {
            throw ex;
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            if (t instanceof ADFShareException) {
                throw (ADFShareException)t;
            }
            throw new ADFShareException("getSiteDefPackages error", t);
        }
        catch (Exception ex) {
            throw new ADFShareException("getSiteDefPackages error", (Throwable)ex);
        }
    }

    @Override
    public List getSessionDefPackages() {
        try {
            Map sessDefMap = this.getConfigObject("http://xmlns.oracle.com/adf/mds/config");
            if (sessDefMap != null) {
                this.sessionDefPackages = (List)sessDefMap.get("SessionDefPackages");
            }
            if (this.sessionDefPackages == null) {
                Class cls = ClassUtils.forName((String)"oracle.adf.share.config.ADFMDSConfig", FallbackConfigImpl.class);
                Object obj = cls.newInstance();
                Method m = obj.getClass().getDeclaredMethod("getDefaultSessionDefPackages", String.class);
                this.sessionDefPackages = (List)m.invoke(obj, this._applicationName);
            }
            return this.sessionDefPackages;
        }
        catch (ADFShareException ex) {
            throw ex;
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            if (t instanceof ADFShareException) {
                throw (ADFShareException)t;
            }
            throw new ADFShareException("getSessionDefPackages error", t);
        }
        catch (Exception ex) {
            throw new ADFShareException("getSessionDefPackages error", (Throwable)ex);
        }
    }

    @Override
    public List getDefCachePolicies() {
        try {
            Map sessDefMap = this.getConfigObject("http://xmlns.oracle.com/adf/mds/config");
            if (sessDefMap != null) {
                this.defCachePolicies = (List)sessDefMap.get("DefCachePolicies");
            }
            if (this.defCachePolicies == null) {
                Class cls = ClassUtils.forName((String)"oracle.adf.share.config.ADFMDSConfig", FallbackConfigImpl.class);
                Object obj = cls.newInstance();
                Method m = obj.getClass().getDeclaredMethod("getDefaultDefCachePolicies", String.class);
                this.defCachePolicies = (List)m.invoke(obj, this._applicationName);
            }
            return this.defCachePolicies;
        }
        catch (ADFShareException ex) {
            throw ex;
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            if (t instanceof ADFShareException) {
                throw (ADFShareException)t;
            }
            throw new ADFShareException("getDefCachePolicies error", t);
        }
        catch (Exception ex) {
            throw new ADFShareException("getDefCachePolicies error", (Throwable)ex);
        }
    }

    @Override
    public List getADFSessionOptionsList() {
        try {
            Map sessDefMap = this.getConfigObject("http://xmlns.oracle.com/adf/mds/config");
            if (sessDefMap != null) {
                this.adfSessionOptionsList = (List)sessDefMap.get("ADFSessionOptionsList");
            }
            if (this.adfSessionOptionsList == null) {
                Class cls = ClassUtils.forName((String)"oracle.adf.share.config.ADFMDSConfig", FallbackConfigImpl.class);
                Object obj = cls.newInstance();
                Method m = obj.getClass().getDeclaredMethod("getDefaultADFSessionOptionsList", String.class);
                this.adfSessionOptionsList = (List)m.invoke(obj, this._applicationName);
            }
            return this.adfSessionOptionsList;
        }
        catch (ADFShareException ex) {
            throw ex;
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            if (t instanceof ADFShareException) {
                throw (ADFShareException)t;
            }
            throw new ADFShareException("getADFSessionOptionsList error", t);
        }
        catch (Exception ex) {
            throw new ADFShareException("getADFSessionOptionsList error", (Throwable)ex);
        }
    }

    public Object getCurrentADFSessionOptions(List sessOptsList) {
        try {
            Map sessDefMap = this.getConfigObject("http://xmlns.oracle.com/adf/mds/config");
            if (sessDefMap != null) {
                this.currentADFSessionOptions = sessDefMap.get("CurrentADFSessionOptions");
            }
            if (this.currentADFSessionOptions == null) {
                Class cls = ClassUtils.forName((String)"oracle.adf.share.config.ADFMDSConfig", FallbackConfigImpl.class);
                Object obj = cls.newInstance();
                Method m = obj.getClass().getDeclaredMethod("getCurrentADFSessionOptions", String.class, List.class);
                this.currentADFSessionOptions = m.invoke(obj, this._applicationName, sessOptsList);
            }
            return this.currentADFSessionOptions;
        }
        catch (ADFShareException ex) {
            throw ex;
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            if (t instanceof ADFShareException) {
                throw (ADFShareException)t;
            }
            throw new ADFShareException("getCurrentADFSessionOptions error", t);
        }
        catch (Exception ex) {
            throw new ADFShareException("getCurrentADFSessionOptions error", (Throwable)ex);
        }
    }

    @Override
    public Context getConnectionsContext() throws NamingException {
        Map connMap = this.getConfigObject("http://xmlns.oracle.com/adf/jndi/config");
        if (connMap == null) {
            return FallbackConfigImpl.getDefaultConnectionsContext();
        }
        return AdfInitialContext.newAdfInitialContext(new Hashtable(connMap), FallbackConfigImpl.class);
    }

    static Context getDefaultConnectionsContext() throws NamingException {
        return AdfJndiConfig.getDefaultConnectionsContext();
    }

    @Override
    public Context getSecurityContext() throws NamingException {
        Map secMap = this.getConfigObject("http://xmlns.oracle.com/adf/security/config");
        if (secMap == null) {
            return FallbackConfigImpl.getDefaultSecurityContext();
        }
        JAASInitialContextFactory factory = new JAASInitialContextFactory();
        return factory.getInitialContext(secMap);
    }

    static Context getDefaultSecurityContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>(4);
        env.put("java.naming.factory.initial", "oracle.adf.share.security.JAASInitialContextFactory");
        String auth = System.getProperty("oracle.adf.security.authorization.enforce");
        env.put("oracle.adf.security.authorization.enforce", auth == null || auth.length() == 0 ? "false" : auth);
        String jaznConfig = System.getProperty("oracle.security.jazn.config");
        if (jaznConfig != null && jaznConfig.length() > 0) {
            env.put("oracle.security.jazn.config", jaznConfig);
        }
        env.put("oracle.adf.security.credentialstore", "oracle.adf.share.security.providers.jps.CSFCredentialStore");
        JAASInitialContextFactory factory = new JAASInitialContextFactory();
        return factory.getInitialContext((Hashtable)env);
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        this.ADFMDSConfig = null;
        this.getDefaultMDSInstance = null;
    }
}

