/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import oracle.adf.share.ADFSettings;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.config.ADFConfigFactory;
import oracle.adf.share.config.ADFSettingsImpl;
import oracle.adf.share.logging.ADFLogger;

public class ConfigContainerFactory {
    @CodeSharingSafe(value="MutableStaticField")
    private static final Map<ClassLoader, SoftReference<ADFSettings>> adfSettingsMap = new WeakHashMap<ClassLoader, SoftReference<ADFSettings>>(4);
    private static final Object settingsMapLock = new Object();
    private static final String CLASSNAME = "oracle.adf.share.ConfigContainerFactory";
    private static final String resourceBundle = "oracle.adf.share.config.resources.Messages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.config.resources.Messages");
    public static final String ADF_CONFIG = "oracle.adf.share.ADFConfig";
    public static final String ADF_SETTIINGS = "oracle.adf.share.ADFSettings";
    private static final ADFLogger mLogger = ADFLogger.createADFLogger((String)"oracle.adf.share.ConfigContainerFactory", (String)"oracle.adf.share.config.resources.Messages");

    public static ADFSettings findOrCreateConfig(String configType) {
        if (configType.equals(ADF_CONFIG)) {
            return ADFConfigFactory.findOrCreateADFConfig(false);
        }
        if (configType.equals(ADF_SETTIINGS)) {
            return ConfigContainerFactory.findOrCreateADFSettings();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ADFSettings findOrCreateADFSettings() {
        ADFSettings app = null;
        ClassLoader cl = ClassUtils.getClassLoader(ConfigContainerFactory.class);
        Object object = settingsMapLock;
        synchronized (object) {
            SoftReference<ADFSettings> sr = adfSettingsMap.get(cl);
            if (sr != null) {
                app = sr.get();
            }
            if (app == null) {
                app = new ADFSettingsImpl();
                adfSettingsMap.put(cl, new SoftReference<ADFSettings>(app));
                if (mLogger.isFine()) {
                    mLogger.fine("Adding ADFSettings for ClassLoader " + cl);
                }
            }
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalClearSettingsMap() {
        Object object = settingsMapLock;
        synchronized (object) {
            adfSettingsMap.clear();
        }
    }
}

