/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.utils;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ui.DataValueUtils;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;

public class UiUtils {
    private static final char QA_NAME_SEP_CHAR = '.';

    public static TableCellEditor getTableCellEditor(DataValue dataValue) {
        DefaultCellEditor defaultCellEditor = (DefaultCellEditor)DataValueUtils.getTableCellEditor((DataValue)dataValue);
        defaultCellEditor.setClickCountToStart(1);
        return defaultCellEditor;
    }

    public static TableCellEditor getTableCellEditor(DataValue dataValue, List<DataValue> list) {
        DefaultCellEditor defaultCellEditor = (DefaultCellEditor)DataValueUtils.getTableCellEditor((DataValue)dataValue, list);
        defaultCellEditor.setClickCountToStart(1);
        return defaultCellEditor;
    }

    public static TableCellRenderer getTableCellRenderer(DataValue dataValue) {
        return DataValueUtils.getTableCellRenderer((DataValue)dataValue);
    }

    private static String formatLeafNameForQA(String string) {
        int n = string == null ? 0 : string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            stringBuilder.append(c);
        }
        String string2 = stringBuilder.toString();
        string2 = string2.replace('.', '-');
        return string2;
    }

    public static String formatNameForQA(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append('.');
            }
            if (0 == stringBuilder.length() && string.isEmpty()) continue;
            stringBuilder.append(UiUtils.formatLeafNameForQA(string));
        }
        return stringBuilder.toString();
    }

    public static void nameForQA(JComboBox jComboBox, String string, String ... stringArray) {
        Object object;
        String string2 = UiUtils.formatNameForQA(string).concat("ComboBox");
        if (null != stringArray) {
            object = new ArrayList<String>(Arrays.asList(stringArray));
            ((ArrayList)object).add(string2);
            string2 = UiUtils.formatNameForQA(((ArrayList)object).toArray(stringArray));
        }
        object = "SelectButton";
        jComboBox.setName(string2);
        for (Component component : jComboBox.getComponents()) {
            if (!(component instanceof JButton)) continue;
            ((JButton)component).setName(UiUtils.formatNameForQA(new String[]{string2, object}));
            break;
        }
    }

    public static void nameButtonsForQA(Toolbar toolbar, String string) {
        if (null == toolbar) {
            return;
        }
        String string2 = UiUtils.formatNameForQA(string);
        String string3 = string2.concat("Toolbar");
        toolbar.setName(string3);
        for (Component component : toolbar.getComponents()) {
            if (component instanceof AbstractButton) {
                Object object;
                AbstractButton abstractButton = (AbstractButton)component;
                Action action = abstractButton.getAction();
                String string4 = "";
                if (action instanceof IdeAction) {
                    object = (IdeAction)action;
                    string4 = Ide.findCmdName((int)object.getCommandId());
                }
                object = UiUtils.formatNameForQA(string4).concat("Button");
                abstractButton.setName(UiUtils.formatNameForQA(new String[]{string3, object}));
                continue;
            }
            boolean bl = true;
        }
    }
}

